/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.common;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.manifoldcf.agents.common.XMLContext;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XMLStream {
    protected XMLReader xr = null;
    protected XMLContext currentContext = null;
    protected SAXParseException parseException = null;

    public XMLStream(boolean laxChecking) throws ManifoldCFException {
        try {
            this.xr = XMLReaderFactory.createXMLReader();
            this.xr.setContentHandler(new MyContentHandler());
            this.xr.setErrorHandler(new MyErrorHandler());
            this.xr.setEntityResolver(new MyEntityResolver());
            if (laxChecking) {
                this.xr.setFeature("http://apache.org/xml/features/continue-after-fatal-error", true);
                this.xr.setFeature("http://apache.org/xml/features/ignore-badly-encoded-chars", true);
            }
        }
        catch (SAXException e) {
            Exception e2 = e.getException();
            if (e2 != null && e2 instanceof ManifoldCFException) {
                throw (ManifoldCFException)((Object)e2);
            }
            throw new ManifoldCFException("Error setting up parser: " + e.getMessage(), (Throwable)e);
        }
    }

    public XMLStream() throws ManifoldCFException {
        this(true);
    }

    public void parse(InputStream xmlInputStream) throws ManifoldCFException, ServiceInterruption, IOException {
        try {
            InputSource is = new InputSource(xmlInputStream);
            this.xr.parse(is);
            if (this.parseException != null) {
                throw new ManifoldCFException("XML parse error: " + this.parseException.getMessage(), (Throwable)this.parseException);
            }
        }
        catch (SAXException e) {
            Exception e2 = e.getException();
            if (e2 != null && e2 instanceof ManifoldCFException) {
                throw (ManifoldCFException)((Object)e2);
            }
            if (e2 != null && e2 instanceof ServiceInterruption) {
                throw (ServiceInterruption)e2;
            }
            throw new ManifoldCFException("Error setting up parser: " + e.getMessage(), (Throwable)e);
        }
        catch (RuntimeException e) {
            throw new ManifoldCFException("XML parse error: " + e.getMessage(), (Throwable)e);
        }
    }

    public void cleanup() throws ManifoldCFException {
        this.currentContext.cleanup();
    }

    public void setContext(XMLContext context) {
        this.currentContext = context;
    }

    public XMLContext getContext() {
        return this.currentContext;
    }

    protected static class MyEntityResolver
    implements EntityResolver {
        protected MyEntityResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return new InputSource(new ByteArrayInputStream("<?xml version='1.0' encoding='UTF-8'?>".getBytes(StandardCharsets.UTF_8)));
        }
    }

    protected class MyErrorHandler
    extends DefaultHandler {
        protected MyErrorHandler() {
        }

        @Override
        public void fatalError(SAXParseException exception) {
            XMLStream.this.parseException = exception;
        }
    }

    protected class MyContentHandler
    extends DefaultHandler {
        protected MyContentHandler() {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            super.characters(ch, start, length);
            if (XMLStream.this.currentContext != null) {
                XMLStream.this.currentContext.characters(ch, start, length);
            }
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            super.startElement(namespaceURI, localName, qName, atts);
            if (XMLStream.this.currentContext != null) {
                XMLStream.this.currentContext.startElement(namespaceURI, localName, qName, atts);
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            super.endElement(namespaceURI, localName, qName);
            if (XMLStream.this.currentContext != null) {
                XMLStream.this.currentContext.endElement(namespaceURI, localName, qName);
            }
        }

        @Override
        public void startDocument() throws SAXException {
            super.startDocument();
            if (XMLStream.this.currentContext != null) {
                XMLStream.this.currentContext.startDocument();
            }
        }

        @Override
        public void endDocument() throws SAXException {
            super.endDocument();
            if (XMLStream.this.currentContext != null) {
                XMLStream.this.currentContext.endDocument();
            }
        }
    }
}

