/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents;

import org.apache.manifoldcf.agents.TransactionalAgentsInitializationCommand;
import org.apache.manifoldcf.agents.interfaces.AgentManagerFactory;
import org.apache.manifoldcf.agents.interfaces.IOutputConnectionManager;
import org.apache.manifoldcf.agents.interfaces.IOutputConnectorManager;
import org.apache.manifoldcf.agents.interfaces.OutputConnectionManagerFactory;
import org.apache.manifoldcf.agents.interfaces.OutputConnectorManagerFactory;
import org.apache.manifoldcf.agents.system.Logging;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class UnRegisterOutput
extends TransactionalAgentsInitializationCommand {
    public static final String _rcsid = "@(#)$Id: UnRegisterOutput.java 988245 2010-08-23 18:39:35Z kwright $";
    private final String className;

    public UnRegisterOutput(String className) {
        this.className = className;
    }

    @Override
    protected void doExecute(IThreadContext tc) throws ManifoldCFException {
        IOutputConnectorManager mgr = OutputConnectorManagerFactory.make(tc);
        IOutputConnectionManager connManager = OutputConnectionManagerFactory.make(tc);
        String[] connectionNames = connManager.findConnectionsForConnector(this.className);
        AgentManagerFactory.noteOutputConnectorDeregistration(tc, connectionNames);
        mgr.unregisterConnector(this.className);
        Logging.root.info((Object)("Successfully unregistered output connector '" + this.className + "'"));
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: UnRegisterOutput <classname>");
            System.exit(1);
        }
        String className = args[0];
        try {
            UnRegisterOutput unRegisterOutput = new UnRegisterOutput(className);
            unRegisterOutput.execute();
            System.err.println("Successfully unregistered output connector '" + className + "'");
        }
        catch (ManifoldCFException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

