/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.terms;

import java.util.Comparator;
import java.util.List;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.search.facet.Facet;

public interface TermsFacet
extends Facet,
Iterable<Entry> {
    public static final String TYPE = "terms";

    public long getMissingCount();

    public long getTotalCount();

    public long getOtherCount();

    public List<? extends Entry> getEntries();

    public static enum ComparatorType {
        COUNT(0, new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                int i = o2.getCount() - o1.getCount();
                if (i == 0 && (i = o2.compareTo(o1)) == 0) {
                    i = System.identityHashCode(o2) - System.identityHashCode(o1);
                }
                return i;
            }
        }),
        REVERSE_COUNT(1, new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                return -COUNT.comparator().compare(o1, o2);
            }
        }),
        TERM(2, new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                return o1.compareTo(o2);
            }
        }),
        REVERSE_TERM(3, new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                return -TERM.comparator().compare(o1, o2);
            }
        });

        private final byte id;
        private final Comparator<Entry> comparator;

        private ComparatorType(byte id, Comparator<Entry> comparator) {
            this.id = id;
            this.comparator = comparator;
        }

        public byte id() {
            return this.id;
        }

        public Comparator<Entry> comparator() {
            return this.comparator;
        }

        public static ComparatorType fromId(byte id) {
            if (id == COUNT.id()) {
                return COUNT;
            }
            if (id == REVERSE_COUNT.id()) {
                return REVERSE_COUNT;
            }
            if (id == TERM.id()) {
                return TERM;
            }
            if (id == REVERSE_TERM.id()) {
                return REVERSE_TERM;
            }
            throw new ElasticsearchIllegalArgumentException("No type argument match for terms facet comparator [" + id + "]");
        }

        public static ComparatorType fromString(String type) {
            if ("count".equals(type)) {
                return COUNT;
            }
            if ("term".equals(type)) {
                return TERM;
            }
            if ("reverse_count".equals(type) || "reverseCount".equals(type)) {
                return REVERSE_COUNT;
            }
            if ("reverse_term".equals(type) || "reverseTerm".equals(type)) {
                return REVERSE_TERM;
            }
            throw new ElasticsearchIllegalArgumentException("No type argument match for terms facet comparator [" + type + "]");
        }
    }

    public static interface Entry
    extends Comparable<Entry> {
        public Text getTerm();

        public Number getTermAsNumber();

        public int getCount();
    }
}

