/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.conversion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.elasticsearch.common.mvel2.ConversionHandler;

public class ListCH
implements ConversionHandler {
    public Object convertFrom(Object in) {
        Class<?> type = in.getClass();
        ArrayList<Object> newList = new ArrayList<Object>();
        if (type.isArray()) {
            newList.addAll(Arrays.asList((Object[])in));
        } else if (Collection.class.isAssignableFrom(type)) {
            newList.addAll((Collection)in);
        } else if (Iterable.class.isAssignableFrom(type)) {
            for (Object o : (Iterable)in) {
                newList.add(o);
            }
        }
        return newList;
    }

    public boolean canConvertFrom(Class cls) {
        return cls.isArray() || Collection.class.isAssignableFrom(cls) || Iterable.class.isAssignableFrom(cls);
    }
}

