/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.collect;

import java.util.Iterator;
import java.util.Map;
import org.elasticsearch.common.collect.UnmodifiableIterator;
import org.elasticsearch.common.hppc.LongCollection;
import org.elasticsearch.common.hppc.LongContainer;
import org.elasticsearch.common.hppc.LongLookupContainer;
import org.elasticsearch.common.hppc.LongObjectAssociativeContainer;
import org.elasticsearch.common.hppc.LongObjectMap;
import org.elasticsearch.common.hppc.LongObjectOpenHashMap;
import org.elasticsearch.common.hppc.ObjectContainer;
import org.elasticsearch.common.hppc.cursors.LongCursor;
import org.elasticsearch.common.hppc.cursors.LongObjectCursor;
import org.elasticsearch.common.hppc.cursors.ObjectCursor;
import org.elasticsearch.common.hppc.predicates.LongPredicate;
import org.elasticsearch.common.hppc.procedures.LongObjectProcedure;

public final class ImmutableOpenLongMap<VType>
implements Iterable<LongObjectCursor<VType>> {
    private final LongObjectOpenHashMap<VType> map;
    private static final ImmutableOpenLongMap EMPTY = new ImmutableOpenLongMap(new LongObjectOpenHashMap());

    private ImmutableOpenLongMap(LongObjectOpenHashMap<VType> map) {
        this.map = map;
    }

    public VType get(long key) {
        return this.map.get(key);
    }

    public boolean containsKey(long key) {
        return this.map.containsKey(key);
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Iterator<LongObjectCursor<VType>> iterator() {
        return this.map.iterator();
    }

    public LongLookupContainer keys() {
        return this.map.keys();
    }

    public UnmodifiableIterator<Long> keysIt() {
        final Iterator<LongCursor> iterator = this.map.keys().iterator();
        return new UnmodifiableIterator<Long>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Long next() {
                return ((LongCursor)iterator.next()).value;
            }
        };
    }

    public ObjectContainer<VType> values() {
        return this.map.values();
    }

    public UnmodifiableIterator<VType> valuesIt() {
        final Iterator<ObjectCursor<VType>> iterator = this.map.values().iterator();
        return new UnmodifiableIterator<VType>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public VType next() {
                return ((ObjectCursor)iterator.next()).value;
            }
        };
    }

    public String toString() {
        return this.map.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableOpenLongMap that = (ImmutableOpenLongMap)o;
        return this.map.equals(that.map);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public static <VType> ImmutableOpenLongMap<VType> of() {
        return EMPTY;
    }

    public static <VType> Builder<VType> builder() {
        return new Builder();
    }

    public static <VType> Builder<VType> builder(int size) {
        return new Builder(size);
    }

    public static <VType> Builder<VType> builder(ImmutableOpenLongMap<VType> map) {
        return new Builder<VType>(map);
    }

    public static class Builder<VType>
    implements LongObjectMap<VType> {
        private LongObjectOpenHashMap<VType> map;

        public Builder() {
            this(EMPTY);
        }

        public Builder(int size) {
            this.map = new LongObjectOpenHashMap(size);
        }

        public Builder(ImmutableOpenLongMap<VType> map) {
            this.map = ((ImmutableOpenLongMap)map).map.clone();
        }

        public ImmutableOpenLongMap<VType> build() {
            LongObjectOpenHashMap<VType> map = this.map;
            this.map = null;
            return new ImmutableOpenLongMap(map);
        }

        public Builder<VType> putAll(Map<Long, VType> map) {
            for (Map.Entry<Long, VType> entry : map.entrySet()) {
                this.map.put(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public Builder<VType> fPut(long key, VType value) {
            this.map.put(key, value);
            return this;
        }

        @Override
        public VType put(long key, VType value) {
            return this.map.put(key, value);
        }

        @Override
        public VType get(long key) {
            return this.map.get(key);
        }

        @Override
        public VType getOrDefault(long kType, VType vType) {
            return this.map.getOrDefault(kType, vType);
        }

        public Builder<VType> fRemove(long key) {
            this.map.remove(key);
            return this;
        }

        @Override
        public VType remove(long key) {
            return this.map.remove(key);
        }

        @Override
        public Iterator<LongObjectCursor<VType>> iterator() {
            return this.map.iterator();
        }

        @Override
        public boolean containsKey(long key) {
            return this.map.containsKey(key);
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public int putAll(LongObjectAssociativeContainer<? extends VType> container) {
            return this.map.putAll(container);
        }

        @Override
        public int putAll(Iterable<? extends LongObjectCursor<? extends VType>> iterable) {
            return this.map.putAll(iterable);
        }

        @Override
        public int removeAll(LongContainer container) {
            return this.map.removeAll(container);
        }

        @Override
        public int removeAll(LongPredicate predicate) {
            return this.map.removeAll(predicate);
        }

        @Override
        public <T extends LongObjectProcedure<? super VType>> T forEach(T procedure) {
            return this.map.forEach(procedure);
        }

        @Override
        public LongCollection keys() {
            return this.map.keys();
        }

        @Override
        public ObjectContainer<VType> values() {
            return this.map.values();
        }
    }
}

