/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes.cenc;

import com.coremedia.iso.Hex;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class CencSampleAuxiliaryDataFormat {
    public byte[] iv;
    public List<Pair> pairs = new LinkedList<Pair>();

    public int getSize() {
        int size = this.iv.length;
        if (this.pairs != null && this.pairs.size() > 0) {
            size += 2;
            size += this.pairs.size() * 6;
        }
        return size;
    }

    public Pair createPair(int clear, long encrypted) {
        return new Pair(clear, encrypted);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CencSampleAuxiliaryDataFormat entry = (CencSampleAuxiliaryDataFormat)o;
        if (!new BigInteger(this.iv).equals(new BigInteger(entry.iv))) {
            return false;
        }
        return !(this.pairs != null ? !this.pairs.equals(entry.pairs) : entry.pairs != null);
    }

    public int hashCode() {
        int result = this.iv != null ? Arrays.hashCode(this.iv) : 0;
        result = 31 * result + (this.pairs != null ? this.pairs.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Entry{iv=" + Hex.encodeHex(this.iv) + ", pairs=" + this.pairs + '}';
    }

    public class Pair {
        public int clear;
        public long encrypted;

        public Pair(int clear, long encrypted) {
            this.clear = clear;
            this.encrypted = encrypted;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Pair pair = (Pair)o;
            if (this.clear != pair.clear) {
                return false;
            }
            return this.encrypted == pair.encrypted;
        }

        public int hashCode() {
            int result = this.clear;
            result = 31 * result + (int)(this.encrypted ^ this.encrypted >>> 32);
            return result;
        }

        public String toString() {
            return "clr:" + this.clear + " enc:" + this.encrypted;
        }
    }
}

