/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.builder;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.CompositionTimeToSample;
import com.coremedia.iso.boxes.Container;
import com.coremedia.iso.boxes.DataEntryUrlBox;
import com.coremedia.iso.boxes.DataInformationBox;
import com.coremedia.iso.boxes.DataReferenceBox;
import com.coremedia.iso.boxes.FileTypeBox;
import com.coremedia.iso.boxes.HandlerBox;
import com.coremedia.iso.boxes.MediaBox;
import com.coremedia.iso.boxes.MediaHeaderBox;
import com.coremedia.iso.boxes.MediaInformationBox;
import com.coremedia.iso.boxes.MovieBox;
import com.coremedia.iso.boxes.MovieHeaderBox;
import com.coremedia.iso.boxes.SampleDependencyTypeBox;
import com.coremedia.iso.boxes.SampleSizeBox;
import com.coremedia.iso.boxes.SampleTableBox;
import com.coremedia.iso.boxes.SampleToChunkBox;
import com.coremedia.iso.boxes.StaticChunkOffsetBox;
import com.coremedia.iso.boxes.SyncSampleBox;
import com.coremedia.iso.boxes.TimeToSampleBox;
import com.coremedia.iso.boxes.TrackBox;
import com.coremedia.iso.boxes.TrackHeaderBox;
import com.googlecode.mp4parser.BasicContainer;
import com.googlecode.mp4parser.DataSource;
import com.googlecode.mp4parser.authoring.Movie;
import com.googlecode.mp4parser.authoring.Sample;
import com.googlecode.mp4parser.authoring.Track;
import com.googlecode.mp4parser.authoring.builder.FragmentIntersectionFinder;
import com.googlecode.mp4parser.authoring.builder.Mp4Builder;
import com.googlecode.mp4parser.authoring.builder.TwoSecondIntersectionFinder;
import com.googlecode.mp4parser.util.CastUtils;
import com.googlecode.mp4parser.util.Path;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMp4Builder
implements Mp4Builder {
    Set<StaticChunkOffsetBox> chunkOffsetBoxes = new HashSet<StaticChunkOffsetBox>();
    private static Logger LOG = Logger.getLogger(DefaultMp4Builder.class.getName());
    HashMap<Track, List<Sample>> track2Sample = new HashMap();
    HashMap<Track, long[]> track2SampleSizes = new HashMap();
    private FragmentIntersectionFinder intersectionFinder;

    public void setIntersectionFinder(FragmentIntersectionFinder intersectionFinder) {
        this.intersectionFinder = intersectionFinder;
    }

    @Override
    public Container build(Movie movie) {
        Object sizes;
        if (this.intersectionFinder == null) {
            this.intersectionFinder = new TwoSecondIntersectionFinder(movie, 2);
        }
        LOG.fine("Creating movie " + movie);
        for (Track track : movie.getTracks()) {
            List<Sample> samples = track.getSamples();
            this.putSamples(track, samples);
            sizes = new long[samples.size()];
            int i = 0;
            while (i < ((Object)sizes).length) {
                Sample b = samples.get(i);
                sizes[i] = b.getSize();
                ++i;
            }
            this.track2SampleSizes.put(track, (long[])sizes);
        }
        BasicContainer isoFile = new BasicContainer();
        isoFile.addBox(this.createFileTypeBox(movie));
        HashMap<Track, int[]> chunks = new HashMap<Track, int[]>();
        sizes = movie.getTracks().iterator();
        while (sizes.hasNext()) {
            Track track = (Track)sizes.next();
            chunks.put(track, this.getChunkSizes(track, movie));
        }
        MovieBox moov = this.createMovieBox(movie, chunks);
        isoFile.addBox(moov);
        List<Box> stszs = Path.getPaths((Box)moov, "trak/mdia/minf/stbl/stsz");
        long contentSize = 0L;
        for (Box stsz : stszs) {
            contentSize += DefaultMp4Builder.sum(((SampleSizeBox)stsz).getSampleSizes());
        }
        InterleaveChunkMdat mdat = new InterleaveChunkMdat(movie, chunks, contentSize);
        isoFile.addBox(mdat);
        long dataOffset = mdat.getDataOffset();
        for (StaticChunkOffsetBox chunkOffsetBox : this.chunkOffsetBoxes) {
            long[] offsets = chunkOffsetBox.getChunkOffsets();
            int i = 0;
            while (i < offsets.length) {
                int n = i++;
                offsets[n] = offsets[n] + dataOffset;
            }
        }
        return isoFile;
    }

    protected List<Sample> putSamples(Track track, List<Sample> samples) {
        return this.track2Sample.put(track, samples);
    }

    protected FileTypeBox createFileTypeBox(Movie movie) {
        LinkedList<String> minorBrands = new LinkedList<String>();
        minorBrands.add("isom");
        minorBrands.add("iso2");
        minorBrands.add("avc1");
        return new FileTypeBox("isom", 0L, minorBrands);
    }

    protected MovieBox createMovieBox(Movie movie, Map<Track, int[]> chunks) {
        MovieBox movieBox = new MovieBox();
        MovieHeaderBox mvhd = new MovieHeaderBox();
        mvhd.setCreationTime(new Date());
        mvhd.setModificationTime(new Date());
        mvhd.setMatrix(movie.getMatrix());
        long movieTimeScale = this.getTimescale(movie);
        long duration = 0L;
        for (Track track : movie.getTracks()) {
            long tracksDuration = track.getDuration() * movieTimeScale / track.getTrackMetaData().getTimescale();
            if (tracksDuration <= duration) continue;
            duration = tracksDuration;
        }
        mvhd.setDuration(duration);
        mvhd.setTimescale(movieTimeScale);
        long nextTrackId = 0L;
        for (Track track : movie.getTracks()) {
            long l = nextTrackId = nextTrackId < track.getTrackMetaData().getTrackId() ? track.getTrackMetaData().getTrackId() : nextTrackId;
        }
        mvhd.setNextTrackId(++nextTrackId);
        movieBox.addBox(mvhd);
        for (Track track : movie.getTracks()) {
            movieBox.addBox(this.createTrackBox(track, movie, chunks));
        }
        Box udta = this.createUdta(movie);
        if (udta != null) {
            movieBox.addBox(udta);
        }
        return movieBox;
    }

    protected Box createUdta(Movie movie) {
        return null;
    }

    protected TrackBox createTrackBox(Track track, Movie movie, Map<Track, int[]> chunks) {
        TrackBox trackBox = new TrackBox();
        TrackHeaderBox tkhd = new TrackHeaderBox();
        tkhd.setEnabled(true);
        tkhd.setInMovie(true);
        tkhd.setInPreview(true);
        tkhd.setInPoster(true);
        tkhd.setMatrix(track.getTrackMetaData().getMatrix());
        tkhd.setAlternateGroup(track.getTrackMetaData().getGroup());
        tkhd.setCreationTime(track.getTrackMetaData().getCreationTime());
        tkhd.setDuration(track.getDuration() * this.getTimescale(movie) / track.getTrackMetaData().getTimescale());
        tkhd.setHeight(track.getTrackMetaData().getHeight());
        tkhd.setWidth(track.getTrackMetaData().getWidth());
        tkhd.setLayer(track.getTrackMetaData().getLayer());
        tkhd.setModificationTime(new Date());
        tkhd.setTrackId(track.getTrackMetaData().getTrackId());
        tkhd.setVolume(track.getTrackMetaData().getVolume());
        trackBox.addBox(tkhd);
        MediaBox mdia = new MediaBox();
        trackBox.addBox(mdia);
        MediaHeaderBox mdhd = new MediaHeaderBox();
        mdhd.setCreationTime(track.getTrackMetaData().getCreationTime());
        mdhd.setDuration(track.getDuration());
        mdhd.setTimescale(track.getTrackMetaData().getTimescale());
        mdhd.setLanguage(track.getTrackMetaData().getLanguage());
        mdia.addBox(mdhd);
        HandlerBox hdlr = new HandlerBox();
        mdia.addBox(hdlr);
        hdlr.setHandlerType(track.getHandler());
        MediaInformationBox minf = new MediaInformationBox();
        minf.addBox(track.getMediaHeaderBox());
        DataInformationBox dinf = new DataInformationBox();
        DataReferenceBox dref = new DataReferenceBox();
        dinf.addBox(dref);
        DataEntryUrlBox url = new DataEntryUrlBox();
        url.setFlags(1);
        dref.addBox(url);
        minf.addBox(dinf);
        Box stbl = this.createStbl(track, movie, chunks);
        minf.addBox(stbl);
        mdia.addBox(minf);
        return trackBox;
    }

    protected Box createStbl(Track track, Movie movie, Map<Track, int[]> chunks) {
        SampleTableBox stbl = new SampleTableBox();
        this.createStsd(track, stbl);
        this.createStts(track, stbl);
        this.createCtts(track, stbl);
        this.createStss(track, stbl);
        this.createSdtp(track, stbl);
        this.createStsc(track, chunks, stbl);
        this.createStsz(track, stbl);
        this.createStco(track, movie, chunks, stbl);
        return stbl;
    }

    protected void createStsd(Track track, SampleTableBox stbl) {
        stbl.addBox(track.getSampleDescriptionBox());
    }

    protected void createStco(Track track, Movie movie, Map<Track, int[]> chunks, SampleTableBox stbl) {
        int[] tracksChunkSizes = chunks.get(track);
        StaticChunkOffsetBox stco = new StaticChunkOffsetBox();
        this.chunkOffsetBoxes.add(stco);
        long offset = 0L;
        long[] chunkOffset = new long[tracksChunkSizes.length];
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Calculating chunk offsets for track_" + track.getTrackMetaData().getTrackId());
        }
        int i = 0;
        while (i < tracksChunkSizes.length) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("Calculating chunk offsets for track_" + track.getTrackMetaData().getTrackId() + " chunk " + i);
            }
            for (Track current : movie.getTracks()) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("Adding offsets of track_" + current.getTrackMetaData().getTrackId());
                }
                int[] chunkSizes = chunks.get(current);
                long firstSampleOfChunk = 0L;
                int j = 0;
                while (j < i) {
                    firstSampleOfChunk += (long)chunkSizes[j];
                    ++j;
                }
                if (current == track) {
                    chunkOffset[i] = offset;
                }
                j = CastUtils.l2i(firstSampleOfChunk);
                while ((long)j < firstSampleOfChunk + (long)chunkSizes[i]) {
                    offset += this.track2SampleSizes.get(current)[j];
                    ++j;
                }
            }
            ++i;
        }
        stco.setChunkOffsets(chunkOffset);
        stbl.addBox(stco);
    }

    protected void createStsz(Track track, SampleTableBox stbl) {
        SampleSizeBox stsz = new SampleSizeBox();
        stsz.setSampleSizes(this.track2SampleSizes.get(track));
        stbl.addBox(stsz);
    }

    protected void createStsc(Track track, Map<Track, int[]> chunks, SampleTableBox stbl) {
        int[] tracksChunkSizes = chunks.get(track);
        SampleToChunkBox stsc = new SampleToChunkBox();
        stsc.setEntries(new LinkedList<SampleToChunkBox.Entry>());
        long lastChunkSize = Integer.MIN_VALUE;
        int i = 0;
        while (i < tracksChunkSizes.length) {
            if (lastChunkSize != (long)tracksChunkSizes[i]) {
                stsc.getEntries().add(new SampleToChunkBox.Entry(i + 1, tracksChunkSizes[i], 1L));
                lastChunkSize = tracksChunkSizes[i];
            }
            ++i;
        }
        stbl.addBox(stsc);
    }

    protected void createSdtp(Track track, SampleTableBox stbl) {
        if (track.getSampleDependencies() != null && !track.getSampleDependencies().isEmpty()) {
            SampleDependencyTypeBox sdtp = new SampleDependencyTypeBox();
            sdtp.setEntries(track.getSampleDependencies());
            stbl.addBox(sdtp);
        }
    }

    protected void createStss(Track track, SampleTableBox stbl) {
        long[] syncSamples = track.getSyncSamples();
        if (syncSamples != null && syncSamples.length > 0) {
            SyncSampleBox stss = new SyncSampleBox();
            stss.setSampleNumber(syncSamples);
            stbl.addBox(stss);
        }
    }

    protected void createCtts(Track track, SampleTableBox stbl) {
        List<CompositionTimeToSample.Entry> compositionTimeToSampleEntries = track.getCompositionTimeEntries();
        if (compositionTimeToSampleEntries != null && !compositionTimeToSampleEntries.isEmpty()) {
            CompositionTimeToSample ctts = new CompositionTimeToSample();
            ctts.setEntries(compositionTimeToSampleEntries);
            stbl.addBox(ctts);
        }
    }

    protected void createStts(Track track, SampleTableBox stbl) {
        TimeToSampleBox.Entry lastEntry = null;
        ArrayList<TimeToSampleBox.Entry> entries = new ArrayList<TimeToSampleBox.Entry>();
        long[] lArray = track.getSampleDurations();
        int n = lArray.length;
        int n2 = 0;
        while (n2 < n) {
            long delta = lArray[n2];
            if (lastEntry != null && lastEntry.getDelta() == delta) {
                lastEntry.setCount(lastEntry.getCount() + 1L);
            } else {
                lastEntry = new TimeToSampleBox.Entry(1L, delta);
                entries.add(lastEntry);
            }
            ++n2;
        }
        TimeToSampleBox stts = new TimeToSampleBox();
        stts.setEntries(entries);
        stbl.addBox(stts);
    }

    int[] getChunkSizes(Track track, Movie movie) {
        long[] referenceChunkStarts = this.intersectionFinder.sampleNumbers(track);
        int[] chunkSizes = new int[referenceChunkStarts.length];
        int i = 0;
        while (i < referenceChunkStarts.length) {
            long start = referenceChunkStarts[i] - 1L;
            long end = referenceChunkStarts.length == i + 1 ? (long)track.getSamples().size() : referenceChunkStarts[i + 1] - 1L;
            chunkSizes[i] = CastUtils.l2i(end - start);
            ++i;
        }
        assert ((long)this.track2Sample.get(track).size() == DefaultMp4Builder.sum(chunkSizes)) : "The number of samples and the sum of all chunk lengths must be equal";
        return chunkSizes;
    }

    private static long sum(int[] ls) {
        long rc = 0L;
        int[] nArray = ls;
        int n = ls.length;
        int n2 = 0;
        while (n2 < n) {
            long l = nArray[n2];
            rc += l;
            ++n2;
        }
        return rc;
    }

    private static long sum(long[] ls) {
        long rc = 0L;
        long[] lArray = ls;
        int n = ls.length;
        int n2 = 0;
        while (n2 < n) {
            long l = lArray[n2];
            rc += l;
            ++n2;
        }
        return rc;
    }

    public long getTimescale(Movie movie) {
        long timescale = movie.getTracks().iterator().next().getTrackMetaData().getTimescale();
        for (Track track : movie.getTracks()) {
            timescale = DefaultMp4Builder.gcd(track.getTrackMetaData().getTimescale(), timescale);
        }
        return timescale;
    }

    public static long gcd(long a, long b) {
        if (b == 0L) {
            return a;
        }
        return DefaultMp4Builder.gcd(b, a % b);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InterleaveChunkMdat
    implements Box {
        List<Track> tracks;
        List<List<Sample>> chunkList = new ArrayList<List<Sample>>();
        Container parent;
        long contentSize;

        @Override
        public Container getParent() {
            return this.parent;
        }

        @Override
        public long getOffset() {
            throw new RuntimeException("Doesn't have any meaning for programmatically created boxes");
        }

        @Override
        public void setParent(Container parent) {
            this.parent = parent;
        }

        @Override
        public void parse(DataSource dataSource, ByteBuffer header, long contentSize, BoxParser boxParser) throws IOException {
        }

        private InterleaveChunkMdat(Movie movie, Map<Track, int[]> chunks, long contentSize) {
            this.contentSize = contentSize;
            this.tracks = movie.getTracks();
            int i = 0;
            while (i < chunks.values().iterator().next().length) {
                for (Track track : this.tracks) {
                    int[] chunkSizes = chunks.get(track);
                    long firstSampleOfChunk = 0L;
                    int j = 0;
                    while (j < i) {
                        firstSampleOfChunk += (long)chunkSizes[j];
                        ++j;
                    }
                    List<Sample> chunk = DefaultMp4Builder.this.track2Sample.get(track).subList(CastUtils.l2i(firstSampleOfChunk), CastUtils.l2i(firstSampleOfChunk + (long)chunkSizes[i]));
                    this.chunkList.add(chunk);
                }
                ++i;
            }
        }

        public long getDataOffset() {
            Object b = this;
            long offset = 16L;
            while (b instanceof Box) {
                for (Box box : ((Box)b).getParent().getBoxes()) {
                    if (b == box) break;
                    offset += box.getSize();
                }
                b = ((Box)b).getParent();
            }
            return offset;
        }

        @Override
        public String getType() {
            return "mdat";
        }

        @Override
        public long getSize() {
            return 16L + this.contentSize;
        }

        private boolean isSmallBox(long contentSize) {
            return contentSize + 8L < 0x100000000L;
        }

        @Override
        public void getBox(WritableByteChannel writableByteChannel) throws IOException {
            ByteBuffer bb = ByteBuffer.allocate(16);
            long size = this.getSize();
            if (this.isSmallBox(size)) {
                IsoTypeWriter.writeUInt32(bb, size);
            } else {
                IsoTypeWriter.writeUInt32(bb, 1L);
            }
            bb.put(IsoFile.fourCCtoBytes("mdat"));
            if (this.isSmallBox(size)) {
                bb.put(new byte[8]);
            } else {
                IsoTypeWriter.writeUInt64(bb, size);
            }
            bb.rewind();
            writableByteChannel.write(bb);
            for (List<Sample> samples : this.chunkList) {
                for (Sample sample : samples) {
                    sample.writeTo(writableByteChannel);
                }
            }
        }
    }
}

