/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.lang.Rational;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.exif.FujifilmMakernoteDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FujifilmMakernoteDescriptor
extends TagDescriptor<FujifilmMakernoteDirectory> {
    public FujifilmMakernoteDescriptor(@NotNull FujifilmMakernoteDirectory directory) {
        super(directory);
    }

    @Override
    @Nullable
    public String getDescription(int tagType) {
        switch (tagType) {
            case 4097: {
                return this.getSharpnessDescription();
            }
            case 4098: {
                return this.getWhiteBalanceDescription();
            }
            case 4099: {
                return this.getColorDescription();
            }
            case 4100: {
                return this.getToneDescription();
            }
            case 4112: {
                return this.getFlashModeDescription();
            }
            case 4113: {
                return this.getFlashStrengthDescription();
            }
            case 4128: {
                return this.getMacroDescription();
            }
            case 4129: {
                return this.getFocusModeDescription();
            }
            case 4144: {
                return this.getSlowSyncDescription();
            }
            case 4145: {
                return this.getPictureModeDescription();
            }
            case 4352: {
                return this.getContinuousTakingOrAutoBrackettingDescription();
            }
            case 4864: {
                return this.getBlurWarningDescription();
            }
            case 4865: {
                return this.getFocusWarningDescription();
            }
            case 4866: {
                return this.getAutoExposureWarningDescription();
            }
        }
        return super.getDescription(tagType);
    }

    @Nullable
    public String getSharpnessDescription() {
        Integer value = ((FujifilmMakernoteDirectory)this._directory).getInteger(4097);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                return "Softest";
            }
            case 2: {
                return "Soft";
            }
            case 3: {
                return "Normal";
            }
            case 4: {
                return "Hard";
            }
            case 5: {
                return "Hardest";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getWhiteBalanceDescription() {
        Integer value = ((FujifilmMakernoteDirectory)this._directory).getInteger(4098);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Auto";
            }
            case 256: {
                return "Daylight";
            }
            case 512: {
                return "Cloudy";
            }
            case 768: {
                return "DaylightColor-fluorescence";
            }
            case 769: {
                return "DaywhiteColor-fluorescence";
            }
            case 770: {
                return "White-fluorescence";
            }
            case 1024: {
                return "Incandescence";
            }
            case 3840: {
                return "Custom white balance";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getColorDescription() {
        Integer value = ((FujifilmMakernoteDirectory)this._directory).getInteger(4099);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Normal (STD)";
            }
            case 256: {
                return "High (HARD)";
            }
            case 512: {
                return "Low (ORG)";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getToneDescription() {
        Integer value = ((FujifilmMakernoteDirectory)this._directory).getInteger(4100);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Normal (STD)";
            }
            case 256: {
                return "High (HARD)";
            }
            case 512: {
                return "Low (ORG)";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getFlashModeDescription() {
        Integer value = ((FujifilmMakernoteDirectory)this._directory).getInteger(4112);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Auto";
            }
            case 1: {
                return "On";
            }
            case 2: {
                return "Off";
            }
            case 3: {
                return "Red-eye reduction";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getFlashStrengthDescription() {
        Rational value = ((FujifilmMakernoteDirectory)this._directory).getRational(4113);
        if (value == null) {
            return null;
        }
        return value.toSimpleString(false) + " EV (Apex)";
    }

    @Nullable
    public String getMacroDescription() {
        return this.getOnOffDescription(4128);
    }

    @Nullable
    public String getFocusModeDescription() {
        Integer value = ((FujifilmMakernoteDirectory)this._directory).getInteger(4129);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Auto focus";
            }
            case 1: {
                return "Manual focus";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getSlowSyncDescription() {
        return this.getOnOffDescription(4144);
    }

    @Nullable
    public String getPictureModeDescription() {
        Integer value = ((FujifilmMakernoteDirectory)this._directory).getInteger(4145);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Auto";
            }
            case 1: {
                return "Portrait scene";
            }
            case 2: {
                return "Landscape scene";
            }
            case 4: {
                return "Sports scene";
            }
            case 5: {
                return "Night scene";
            }
            case 6: {
                return "Program AE";
            }
            case 256: {
                return "Aperture priority AE";
            }
            case 512: {
                return "Shutter priority AE";
            }
            case 768: {
                return "Manual exposure";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getContinuousTakingOrAutoBrackettingDescription() {
        return this.getOnOffDescription(4352);
    }

    @Nullable
    public String getBlurWarningDescription() {
        Integer value = ((FujifilmMakernoteDirectory)this._directory).getInteger(4864);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "No blur warning";
            }
            case 1: {
                return "Blur warning";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getFocusWarningDescription() {
        Integer value = ((FujifilmMakernoteDirectory)this._directory).getInteger(4865);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Auto focus good";
            }
            case 1: {
                return "Out of focus";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getAutoExposureWarningDescription() {
        Integer value = ((FujifilmMakernoteDirectory)this._directory).getInteger(4866);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "AE good";
            }
            case 1: {
                return "Over exposed (>1/1000s @ F11)";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    private String getOnOffDescription(int tagType) {
        Integer value = ((FujifilmMakernoteDirectory)this._directory).getInteger(tagType);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Off";
            }
            case 1: {
                return "On";
            }
        }
        return "Unknown (" + value + ")";
    }
}

