/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.commons.impl.dataobjects;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.data.MutableProperties;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AbstractExtensionData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesImpl
extends AbstractExtensionData
implements MutableProperties {
    private static final long serialVersionUID = 1L;
    private final List<PropertyData<?>> propertyList = new ArrayList();
    private final Map<String, PropertyData<?>> properties = new LinkedHashMap();

    public PropertiesImpl() {
    }

    public PropertiesImpl(Collection<PropertyData<?>> properties) {
        this.addProperties(properties);
    }

    public PropertiesImpl(Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("Properties not set!");
        }
        this.addProperties(properties.getPropertyList());
        this.setExtensions(properties.getExtensions());
    }

    public Map<String, PropertyData<?>> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public List<PropertyData<?>> getPropertyList() {
        return Collections.unmodifiableList(this.propertyList);
    }

    protected void addProperties(Collection<PropertyData<?>> properties) {
        if (properties != null) {
            for (PropertyData<?> prop : properties) {
                this.addProperty(prop);
            }
        }
    }

    public void addProperty(PropertyData<?> property) {
        if (property == null) {
            return;
        }
        this.propertyList.add(property);
        this.properties.put(property.getId(), property);
    }

    public void replaceProperty(PropertyData<?> property) {
        if (property == null || property.getId() == null) {
            return;
        }
        this.removeProperty(property.getId());
        this.propertyList.add(property);
        this.properties.put(property.getId(), property);
    }

    public void removeProperty(String id) {
        if (id == null) {
            return;
        }
        Iterator<PropertyData<?>> iterator = this.propertyList.iterator();
        while (iterator.hasNext()) {
            PropertyData<?> property = iterator.next();
            if (!id.equals(property.getId())) continue;
            iterator.remove();
            break;
        }
        this.properties.remove(id);
    }

    @Override
    public String toString() {
        return "Properties Data [properties=" + this.propertyList + "]" + super.toString();
    }
}

