/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.NotFoundException;
import org.jboss.resteasy.core.registry.ClassExpression;
import org.jboss.resteasy.core.registry.RootNode;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.ResteasyUriInfo;

public class ClassNode {
    protected String segment;
    protected Map<String, ClassNode> children = new HashMap<String, ClassNode>();
    protected List<ClassExpression> targets = new ArrayList<ClassExpression>();

    public ClassNode(String segment) {
        this.segment = segment;
    }

    public RootNode match(HttpRequest request, int start) {
        String path = request.getUri().getMatchingPath();
        if (start < path.length() && path.charAt(start) == '/') {
            ++start;
        }
        ArrayList<ClassExpression> potentials = new ArrayList<ClassExpression>();
        this.potentials(path, start, potentials);
        Collections.sort(potentials);
        for (ClassExpression expression : potentials) {
            Pattern pattern = expression.getPattern();
            Matcher matcher = pattern.matcher(path);
            matcher.region(start, path.length());
            if (!matcher.matches()) continue;
            ResteasyUriInfo uriInfo = request.getUri();
            int length = matcher.start(expression.getNumGroups() + 1);
            if (length == -1) {
                uriInfo.pushMatchedURI(path);
            } else {
                String substring = path.substring(0, length);
                uriInfo.pushMatchedURI(substring);
            }
            return expression.getRoot();
        }
        throw new NotFoundException("Could not find resource for full path: " + request.getUri().getRequestUri());
    }

    public void potentials(String path, int start, List<ClassExpression> matches) {
        if (start == path.length()) {
            matches.addAll(this.targets);
            return;
        }
        if (start < path.length()) {
            String simpleSegment = null;
            int endOfSegmentIndex = path.indexOf(47, start);
            simpleSegment = endOfSegmentIndex > -1 ? path.substring(start, endOfSegmentIndex) : path.substring(start);
            ClassNode child = this.children.get(simpleSegment);
            if (child != null) {
                int next = start + simpleSegment.length();
                if (endOfSegmentIndex > -1) {
                    ++next;
                }
                child.potentials(path, next, matches);
            }
        }
        for (ClassExpression exp : this.targets) {
            matches.add(exp);
        }
    }
}

