/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf.wellknown;

import java.util.HashMap;
import org.apache.poi.hpsf.wellknown.PropertyIDMap;

public class SectionIDMap
extends HashMap {
    public static final byte[] SUMMARY_INFORMATION_ID = new byte[]{-14, -97, -123, -32, 79, -7, 16, 104, -85, -111, 8, 0, 43, 39, -77, -39};
    public static final byte[][] DOCUMENT_SUMMARY_INFORMATION_ID = new byte[][]{{-43, -51, -43, 2, 46, -100, 16, 27, -109, -105, 8, 0, 43, 44, -7, -82}, {-43, -51, -43, 5, 46, -100, 16, 27, -109, -105, 8, 0, 43, 44, -7, -82}};
    public static final String UNDEFINED = "[undefined]";
    private static SectionIDMap defaultMap;

    public static SectionIDMap getInstance() {
        if (defaultMap == null) {
            SectionIDMap m = new SectionIDMap();
            m.put(SUMMARY_INFORMATION_ID, PropertyIDMap.getSummaryInformationProperties());
            m.put(DOCUMENT_SUMMARY_INFORMATION_ID[0], PropertyIDMap.getDocumentSummaryInformationProperties());
            defaultMap = m;
        }
        return defaultMap;
    }

    public static String getPIDString(byte[] sectionFormatID, long pid) {
        PropertyIDMap m = SectionIDMap.getInstance().get(sectionFormatID);
        if (m == null) {
            return UNDEFINED;
        }
        String s = (String)m.get(pid);
        if (s == null) {
            return UNDEFINED;
        }
        return s;
    }

    public PropertyIDMap get(byte[] sectionFormatID) {
        return (PropertyIDMap)super.get(new String(sectionFormatID));
    }

    @Override
    public Object get(Object sectionFormatID) {
        return this.get((byte[])sectionFormatID);
    }

    @Override
    public Object put(byte[] sectionFormatID, PropertyIDMap propertyIDMap) {
        return super.put(new String(sectionFormatID), propertyIDMap);
    }

    @Override
    public Object put(Object key, Object value) {
        return this.put((byte[])key, (PropertyIDMap)value);
    }
}

