/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util.internal.instant;

import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.core.time.MutableInstant;
import org.apache.logging.log4j.core.util.internal.instant.InstantPatternFormatter;
import org.jspecify.annotations.Nullable;

final class InstantPatternDynamicFormatter
implements InstantPatternFormatter {
    static final ChronoUnit PRECISION_THRESHOLD = ChronoUnit.MINUTES;
    private final AtomicReference<TimestampedFormatter> timestampedFormatterRef;

    InstantPatternDynamicFormatter(String pattern, Locale locale, TimeZone timeZone) {
        TimestampedFormatter timestampedFormatter = InstantPatternDynamicFormatter.createTimestampedFormatter(pattern, locale, timeZone, null);
        this.timestampedFormatterRef = new AtomicReference<TimestampedFormatter>(timestampedFormatter);
    }

    @Override
    public String getPattern() {
        return this.timestampedFormatterRef.get().formatter.getPattern();
    }

    @Override
    public Locale getLocale() {
        return this.timestampedFormatterRef.get().formatter.getLocale();
    }

    @Override
    public TimeZone getTimeZone() {
        return this.timestampedFormatterRef.get().formatter.getTimeZone();
    }

    @Override
    public ChronoUnit getPrecision() {
        return this.timestampedFormatterRef.get().formatter.getPrecision();
    }

    @Override
    public void formatTo(StringBuilder buffer, org.apache.logging.log4j.core.time.Instant instant) {
        Objects.requireNonNull(buffer, "buffer");
        Objects.requireNonNull(instant, "instant");
        this.getEffectiveFormatter(instant).formatTo(buffer, instant);
    }

    private InstantPatternFormatter getEffectiveFormatter(org.apache.logging.log4j.core.time.Instant instant) {
        TimestampedFormatter oldTimestampedFormatter = this.timestampedFormatterRef.get();
        long instantEpochMinutes = InstantPatternDynamicFormatter.toEpochMinutes(instant);
        InstantPatternFormatter oldFormatter = oldTimestampedFormatter.formatter;
        if (oldTimestampedFormatter.instantEpochMinutes == instantEpochMinutes) {
            return oldFormatter;
        }
        TimestampedFormatter newTimestampedFormatter = InstantPatternDynamicFormatter.createTimestampedFormatter(oldFormatter.getPattern(), oldFormatter.getLocale(), oldFormatter.getTimeZone(), instant);
        this.timestampedFormatterRef.compareAndSet(oldTimestampedFormatter, newTimestampedFormatter);
        return newTimestampedFormatter.formatter;
    }

    private static TimestampedFormatter createTimestampedFormatter(String pattern, Locale locale, TimeZone timeZone, @Nullable org.apache.logging.log4j.core.time.Instant creationInstant) {
        if (creationInstant == null) {
            creationInstant = new MutableInstant();
            Instant currentInstant = Instant.now();
            ((MutableInstant)creationInstant).initFromEpochSecond(currentInstant.getEpochSecond(), creationInstant.getNanoOfSecond());
        }
        InstantPatternFormatter formatter = InstantPatternDynamicFormatter.createFormatter(pattern, locale, timeZone, PRECISION_THRESHOLD, creationInstant);
        long creationInstantEpochMinutes = InstantPatternDynamicFormatter.toEpochMinutes(creationInstant);
        return new TimestampedFormatter(creationInstantEpochMinutes, formatter);
    }

    private static InstantPatternFormatter createFormatter(String pattern, Locale locale, TimeZone timeZone, ChronoUnit precisionThreshold, org.apache.logging.log4j.core.time.Instant creationInstant) {
        List<PatternSequence> sequences = InstantPatternDynamicFormatter.sequencePattern(pattern, precisionThreshold);
        final List formatters = sequences.stream().map(sequence -> {
            InstantPatternFormatter formatter = sequence.createFormatter(locale, timeZone);
            boolean constant = sequence.isConstantForDurationOf(precisionThreshold);
            if (!constant) {
                return formatter;
            }
            StringBuilder buffer = new StringBuilder();
            formatter.formatTo(buffer, creationInstant);
            final String formattedInstant = buffer.toString();
            return new AbstractFormatter(formatter.getPattern(), locale, timeZone, formatter.getPrecision()){

                @Override
                public void formatTo(StringBuilder buffer, org.apache.logging.log4j.core.time.Instant instant) {
                    buffer.append(formattedInstant);
                }
            };
        }).collect(Collectors.toList());
        switch (formatters.size()) {
            case 0: {
                return new AbstractFormatter(pattern, locale, timeZone, ChronoUnit.FOREVER){

                    @Override
                    public void formatTo(StringBuilder buffer, org.apache.logging.log4j.core.time.Instant instant) {
                    }
                };
            }
            case 1: {
                return (InstantPatternFormatter)formatters.get(0);
            }
        }
        ChronoUnit precision = new CompositePatternSequence(sequences).precision;
        return new AbstractFormatter(pattern, locale, timeZone, precision){

            @Override
            public void formatTo(StringBuilder buffer, org.apache.logging.log4j.core.time.Instant instant) {
                for (int formatterIndex = 0; formatterIndex < formatters.size(); ++formatterIndex) {
                    InstantPatternFormatter formatter = (InstantPatternFormatter)formatters.get(formatterIndex);
                    formatter.formatTo(buffer, instant);
                }
            }
        };
    }

    static List<PatternSequence> sequencePattern(String pattern, ChronoUnit precisionThreshold) {
        List<PatternSequence> sequences = InstantPatternDynamicFormatter.sequencePattern(pattern);
        List<PatternSequence> mergedSequences = InstantPatternDynamicFormatter.mergeDynamicSequences(sequences, precisionThreshold);
        return InstantPatternDynamicFormatter.mergeConsequentEffectivelyConstantSequences(mergedSequences, precisionThreshold);
    }

    private static List<PatternSequence> sequencePattern(String pattern) {
        if (pattern.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<PatternSequence> sequences = new ArrayList<PatternSequence>();
        int startIndex = 0;
        while (startIndex < pattern.length()) {
            PatternSequence sequence;
            char c = pattern.charAt(startIndex);
            boolean dynamic = InstantPatternDynamicFormatter.isDynamicPatternLetter(c);
            if (dynamic) {
                int endIndex;
                for (endIndex = startIndex + 1; endIndex < pattern.length() && pattern.charAt(endIndex) == c; ++endIndex) {
                }
                String sequenceContent = pattern.substring(startIndex, endIndex);
                sequence = new DynamicPatternSequence(sequenceContent);
                sequences.add(sequence);
                startIndex = endIndex;
                continue;
            }
            if (c == '\'') {
                int endIndex = pattern.indexOf(39, startIndex + 1);
                if (endIndex < 0) {
                    String message = String.format("pattern ends with an incomplete string literal that started at index %d: `%s`", startIndex, pattern);
                    throw new IllegalArgumentException(message);
                }
                String sequenceLiteral = startIndex + 1 == endIndex ? "'" : pattern.substring(startIndex + 1, endIndex);
                sequence = new StaticPatternSequence(sequenceLiteral);
                sequences.add(sequence);
                startIndex = endIndex + 1;
                continue;
            }
            StaticPatternSequence sequence2 = new StaticPatternSequence("" + c);
            sequences.add(sequence2);
            ++startIndex;
        }
        return InstantPatternDynamicFormatter.mergeConsequentStaticPatternSequences(sequences);
    }

    private static boolean isDynamicPatternLetter(char c) {
        return "GuyDMLdgQqYwWEecFaBhKkHmsSAnNVvzOXxZ".indexOf(c) >= 0;
    }

    private static List<PatternSequence> mergeConsequentStaticPatternSequences(List<PatternSequence> sequences) {
        if (sequences.size() < 2) {
            return sequences;
        }
        ArrayList<PatternSequence> mergedSequences = new ArrayList<PatternSequence>();
        ArrayList<StaticPatternSequence> accumulatedSequences = new ArrayList<StaticPatternSequence>();
        for (PatternSequence sequence : sequences) {
            if (sequence instanceof StaticPatternSequence) {
                accumulatedSequences.add((StaticPatternSequence)sequence);
                continue;
            }
            InstantPatternDynamicFormatter.mergeConsequentStaticPatternSequences(mergedSequences, accumulatedSequences);
            mergedSequences.add(sequence);
        }
        InstantPatternDynamicFormatter.mergeConsequentStaticPatternSequences(mergedSequences, accumulatedSequences);
        return mergedSequences;
    }

    private static void mergeConsequentStaticPatternSequences(List<PatternSequence> mergedSequences, List<StaticPatternSequence> accumulatedSequences) {
        InstantPatternDynamicFormatter.mergeAccumulatedSequences(mergedSequences, accumulatedSequences, () -> {
            String literal = accumulatedSequences.stream().map(sequence -> sequence.literal).collect(Collectors.joining());
            return new StaticPatternSequence(literal);
        });
    }

    private static List<PatternSequence> mergeDynamicSequences(List<PatternSequence> sequences, ChronoUnit precisionThreshold) {
        int firstDynamicSequenceIndex = -1;
        int lastDynamicSequenceIndex = -1;
        for (int sequenceIndex = 0; sequenceIndex < sequences.size(); ++sequenceIndex) {
            PatternSequence sequence = sequences.get(sequenceIndex);
            boolean constant = sequence.isConstantForDurationOf(precisionThreshold);
            if (constant) continue;
            if (firstDynamicSequenceIndex < 0) {
                firstDynamicSequenceIndex = sequenceIndex;
            }
            lastDynamicSequenceIndex = sequenceIndex;
        }
        if (firstDynamicSequenceIndex < 0 || firstDynamicSequenceIndex == lastDynamicSequenceIndex) {
            return sequences;
        }
        ArrayList<PatternSequence> mergedSequences = new ArrayList<PatternSequence>();
        if (firstDynamicSequenceIndex > 0) {
            mergedSequences.addAll(sequences.subList(0, firstDynamicSequenceIndex));
        }
        CompositePatternSequence mergedDynamicSequence = new CompositePatternSequence(sequences.subList(firstDynamicSequenceIndex, lastDynamicSequenceIndex + 1));
        mergedSequences.add(mergedDynamicSequence);
        if (lastDynamicSequenceIndex + 1 < sequences.size()) {
            mergedSequences.addAll(sequences.subList(lastDynamicSequenceIndex + 1, sequences.size()));
        }
        return mergedSequences;
    }

    private static List<PatternSequence> mergeConsequentEffectivelyConstantSequences(List<PatternSequence> sequences, ChronoUnit precisionThreshold) {
        if (sequences.size() < 2) {
            return sequences;
        }
        ArrayList<PatternSequence> mergedSequences = new ArrayList<PatternSequence>();
        boolean accumulatorConstant = true;
        ArrayList<PatternSequence> accumulatedSequences = new ArrayList<PatternSequence>();
        for (PatternSequence sequence : sequences) {
            boolean sequenceConstant = sequence.isConstantForDurationOf(precisionThreshold);
            if (sequenceConstant != accumulatorConstant) {
                InstantPatternDynamicFormatter.mergeConsequentEffectivelyConstantSequences(mergedSequences, accumulatedSequences);
                accumulatorConstant = sequenceConstant;
            }
            accumulatedSequences.add(sequence);
        }
        InstantPatternDynamicFormatter.mergeConsequentEffectivelyConstantSequences(mergedSequences, accumulatedSequences);
        return mergedSequences;
    }

    private static void mergeConsequentEffectivelyConstantSequences(List<PatternSequence> mergedSequences, List<PatternSequence> accumulatedSequences) {
        InstantPatternDynamicFormatter.mergeAccumulatedSequences(mergedSequences, accumulatedSequences, () -> new CompositePatternSequence(accumulatedSequences));
    }

    private static <S extends PatternSequence> void mergeAccumulatedSequences(List<PatternSequence> mergedSequences, List<S> accumulatedSequences, Supplier<PatternSequence> mergedSequenceSupplier) {
        if (accumulatedSequences.isEmpty()) {
            return;
        }
        PatternSequence mergedSequence = accumulatedSequences.size() == 1 ? (PatternSequence)accumulatedSequences.get(0) : mergedSequenceSupplier.get();
        mergedSequences.add(mergedSequence);
        accumulatedSequences.clear();
    }

    private static long toEpochMinutes(org.apache.logging.log4j.core.time.Instant instant) {
        return instant.getEpochSecond() / 60L;
    }

    private static TemporalAccessor toTemporalAccessor(org.apache.logging.log4j.core.time.Instant instant) {
        return instant instanceof TemporalAccessor ? (TemporalAccessor)((Object)instant) : Instant.ofEpochSecond(instant.getEpochSecond(), instant.getNanoOfSecond());
    }

    private static final class TimestampedFormatter {
        private final long instantEpochMinutes;
        private final InstantPatternFormatter formatter;

        private TimestampedFormatter(long instantEpochMinutes, InstantPatternFormatter formatter) {
            this.instantEpochMinutes = instantEpochMinutes;
            this.formatter = formatter;
        }
    }

    static final class CompositePatternSequence
    extends PatternSequence {
        CompositePatternSequence(List<PatternSequence> sequences) {
            super(CompositePatternSequence.concatSequencePatterns(sequences), CompositePatternSequence.findSequenceMaxPrecision(sequences));
            if (sequences.size() < 2) {
                throw new IllegalArgumentException("was expecting two or more sequences: " + sequences);
            }
        }

        private static ChronoUnit findSequenceMaxPrecision(List<PatternSequence> sequences) {
            return sequences.stream().map(sequence -> sequence.precision).min(Comparator.comparing(ChronoUnit::getDuration)).get();
        }

        private static String concatSequencePatterns(List<PatternSequence> sequences) {
            return sequences.stream().map(sequence -> sequence.pattern).collect(Collectors.joining());
        }
    }

    static final class DynamicPatternSequence
    extends PatternSequence {
        DynamicPatternSequence(String content) {
            super(content, DynamicPatternSequence.contentPrecision(content));
        }

        private static @Nullable ChronoUnit contentPrecision(String content) {
            DynamicPatternSequence.validateContent(content);
            String paddingRemovedContent = DynamicPatternSequence.removePadding(content);
            if (paddingRemovedContent.matches("[GuyY]+")) {
                return ChronoUnit.YEARS;
            }
            if (paddingRemovedContent.matches("[MLQq]+")) {
                return ChronoUnit.MONTHS;
            }
            if (paddingRemovedContent.matches("[wW]+")) {
                return ChronoUnit.WEEKS;
            }
            if (paddingRemovedContent.matches("[DdgEecF]+")) {
                return ChronoUnit.DAYS;
            }
            if (paddingRemovedContent.matches("[aBhKkH]+") || paddingRemovedContent.matches("[ZxXOzvV]+")) {
                return ChronoUnit.HOURS;
            }
            if (paddingRemovedContent.contains("m")) {
                return ChronoUnit.MINUTES;
            }
            if (paddingRemovedContent.contains("s")) {
                return ChronoUnit.SECONDS;
            }
            if (paddingRemovedContent.matches("S{2,3}") || paddingRemovedContent.contains("A")) {
                return ChronoUnit.MILLIS;
            }
            if (paddingRemovedContent.matches("S{4,6}")) {
                return ChronoUnit.MICROS;
            }
            if (paddingRemovedContent.equals("S") || paddingRemovedContent.matches("S{7,9}") || paddingRemovedContent.matches("[nN]+")) {
                return ChronoUnit.NANOS;
            }
            String message = String.format("unrecognized pattern: `%s`", content);
            throw new IllegalArgumentException(message);
        }

        private static void validateContent(String content) {
            String paddingRemovedContent = DynamicPatternSequence.removePadding(content);
            if (paddingRemovedContent.isEmpty()) {
                String message = String.format("empty content: `%s`", content);
                throw new IllegalArgumentException(message);
            }
            char letter = paddingRemovedContent.charAt(0);
            boolean dynamic = InstantPatternDynamicFormatter.isDynamicPatternLetter(letter);
            if (!dynamic) {
                String message = String.format("pattern sequence doesn't start with a dynamic pattern letter: `%s`", content);
                throw new IllegalArgumentException(message);
            }
            boolean repeated = paddingRemovedContent.matches("^(\\Q" + letter + "\\E)+$");
            if (!repeated) {
                String message = String.format("was expecting letter `%c` to be repeated through the entire pattern sequence: `%s`", Character.valueOf(letter), content);
                throw new IllegalArgumentException(message);
            }
        }

        private static String removePadding(String content) {
            return content.replaceAll("^p+", "");
        }
    }

    static final class StaticPatternSequence
    extends PatternSequence {
        private final String literal;

        StaticPatternSequence(String literal) {
            super((String)(literal.equals("'") ? "''" : "'" + literal + "'"), ChronoUnit.FOREVER);
            this.literal = literal;
        }

        @Override
        InstantPatternFormatter createFormatter(Locale locale, TimeZone timeZone) {
            return new AbstractFormatter(this.pattern, locale, timeZone, this.precision){

                @Override
                public void formatTo(StringBuilder buffer, org.apache.logging.log4j.core.time.Instant instant) {
                    buffer.append(literal);
                }
            };
        }
    }

    static abstract class PatternSequence {
        final String pattern;
        final ChronoUnit precision;

        PatternSequence(String pattern, ChronoUnit precision) {
            DateTimeFormatter.ofPattern(pattern);
            this.pattern = pattern;
            this.precision = precision;
        }

        InstantPatternFormatter createFormatter(Locale locale, TimeZone timeZone) {
            final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(this.pattern, locale).withZone(timeZone.toZoneId());
            return new AbstractFormatter(this.pattern, locale, timeZone, this.precision){

                @Override
                public void formatTo(StringBuilder buffer, org.apache.logging.log4j.core.time.Instant instant) {
                    TemporalAccessor instantAccessor = InstantPatternDynamicFormatter.toTemporalAccessor(instant);
                    dateTimeFormatter.formatTo(instantAccessor, buffer);
                }
            };
        }

        private boolean isConstantForDurationOf(ChronoUnit thresholdPrecision) {
            return this.precision.compareTo(thresholdPrecision) >= 0;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            PatternSequence sequence = (PatternSequence)object;
            return Objects.equals(this.pattern, sequence.pattern) && this.precision == sequence.precision;
        }

        public int hashCode() {
            return Objects.hash(this.pattern, this.precision);
        }

        public String toString() {
            return String.format("<%s>%s", this.pattern, this.precision);
        }
    }

    private static abstract class AbstractFormatter
    implements InstantPatternFormatter {
        private final String pattern;
        private final Locale locale;
        private final TimeZone timeZone;
        private final ChronoUnit precision;

        private AbstractFormatter(String pattern, Locale locale, TimeZone timeZone, ChronoUnit precision) {
            this.pattern = pattern;
            this.locale = locale;
            this.timeZone = timeZone;
            this.precision = precision;
        }

        @Override
        public ChronoUnit getPrecision() {
            return this.precision;
        }

        @Override
        public String getPattern() {
            return this.pattern;
        }

        @Override
        public Locale getLocale() {
            return this.locale;
        }

        @Override
        public TimeZone getTimeZone() {
            return this.timeZone;
        }
    }
}

