/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json.resolver;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.kit.recycler.Recycler;
import org.apache.logging.log4j.layout.template.json.resolver.EventResolver;
import org.apache.logging.log4j.layout.template.json.resolver.EventResolverContext;
import org.apache.logging.log4j.layout.template.json.resolver.TemplateResolverConfig;
import org.apache.logging.log4j.layout.template.json.util.JsonWriter;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterConsumer;
import org.apache.logging.log4j.message.ParameterVisitable;

public final class MessageParameterResolver
implements EventResolver {
    private final Recycler<ParameterConsumerState> parameterConsumerStateRecycler;
    private final boolean stringified;
    private final int index;
    private static final ParameterConsumer<ParameterConsumerState> PARAMETER_CONSUMER = (parameter, index, state) -> {
        boolean arrayNeeded;
        boolean bl = arrayNeeded = state.resolver.index < 0;
        if (arrayNeeded && index > 0) {
            state.jsonWriter.writeSeparator();
        }
        if (arrayNeeded || state.resolver.index == index) {
            if (state.resolver.stringified) {
                String stringifiedParameter = String.valueOf(parameter);
                state.jsonWriter.writeString(stringifiedParameter);
            } else {
                state.jsonWriter.writeValue(parameter);
            }
        }
    };

    MessageParameterResolver(EventResolverContext context, TemplateResolverConfig config) {
        this.parameterConsumerStateRecycler = context.getConfiguration().getRecyclerFactory().create(ParameterConsumerState::new);
        this.stringified = config.getBoolean("stringified", false);
        Integer index = config.getInteger("index");
        if (index != null && index < 0) {
            throw new IllegalArgumentException("was expecting a positive index: " + config);
        }
        this.index = index == null ? -1 : index;
    }

    static String getName() {
        return "messageParameter";
    }

    @Override
    public void resolve(LogEvent logEvent, JsonWriter jsonWriter) {
        Message message = logEvent.getMessage();
        if (message instanceof ParameterVisitable) {
            ParameterVisitable parameterVisitable = (ParameterVisitable)message;
            this.resolve(parameterVisitable, jsonWriter);
            return;
        }
        Object[] parameters = message.getParameters();
        if (parameters == null || parameters.length == 0 || this.index >= parameters.length) {
            if (this.index < 0) {
                jsonWriter.writeArrayStart();
                jsonWriter.writeArrayEnd();
            } else {
                jsonWriter.writeNull();
            }
            return;
        }
        if (this.index < 0) {
            jsonWriter.writeArrayStart();
            for (int i = 0; i < parameters.length; ++i) {
                if (i > 0) {
                    jsonWriter.writeSeparator();
                }
                Object parameter = parameters[i];
                if (this.stringified) {
                    String stringifiedParameter = String.valueOf(parameter);
                    jsonWriter.writeString(stringifiedParameter);
                    continue;
                }
                jsonWriter.writeValue(parameter);
            }
            jsonWriter.writeArrayEnd();
        } else {
            Object parameter = parameters[this.index];
            if (this.stringified) {
                String stringifiedParameter = String.valueOf(parameter);
                jsonWriter.writeString(stringifiedParameter);
            } else {
                jsonWriter.writeValue(parameter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    private void resolve(ParameterVisitable parameterVisitable, JsonWriter jsonWriter) {
        ParameterConsumerState parameterConsumerState = (ParameterConsumerState)this.parameterConsumerStateRecycler.acquire();
        try {
            boolean arrayNeeded;
            boolean bl = arrayNeeded = this.index < 0;
            if (arrayNeeded) {
                jsonWriter.writeArrayStart();
            }
            StringBuilder buf = jsonWriter.getStringBuilder();
            int startIndex = buf.length();
            parameterConsumerState.resolver = this;
            parameterConsumerState.jsonWriter = jsonWriter;
            parameterVisitable.forEachParameter(PARAMETER_CONSUMER, (Object)parameterConsumerState);
            if (arrayNeeded) {
                jsonWriter.writeArrayEnd();
            } else if (startIndex == buf.length()) {
                jsonWriter.writeNull();
            }
        }
        finally {
            this.parameterConsumerStateRecycler.release((Object)parameterConsumerState);
        }
    }

    private static final class ParameterConsumerState {
        private MessageParameterResolver resolver;
        private JsonWriter jsonWriter;

        private ParameterConsumerState() {
        }
    }
}

