/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Arguments used to upgrade a CDP Private Cloud Control Plane")
public class ApiUpgradeControlPlaneArgs {
    @SerializedName(value="kubeConfig")
    private String kubeConfig = null;
    @SerializedName(value="valuesYaml")
    private String valuesYaml = null;
    @SerializedName(value="remoteRepoUrl")
    private String remoteRepoUrl = null;

    public ApiUpgradeControlPlaneArgs kubeConfig(String kubeConfig) {
        this.kubeConfig = kubeConfig;
        return this;
    }

    @ApiModelProperty(value="The content of the kubeconfig file of the kubernetes environment on which the control plane is running Simplified example:<br> <br> apiVersion: v1<br> clusters:<br> - cluster:<br> &emsp;&emsp;certificate-authority-data: abc123<br> &emsp;&emsp;server: https://example-server.domain.com:6443<br> &emsp;name: example-cluster.domain.com:6443<br> contexts:<br> - context:<br> &emsp;&emsp;cluster: ocp-cluster1<br> &emsp;&emsp;user: admin<br> &emsp;name: admin<br> current-context: admin<br> kind: Config<br> preferences: {}<br> users:<br> - name: admin<br> &emsp;user:<br> &emsp;&emsp;client-certificate-data: abc123<br> &emsp;&emsp;client-key-data: xyz987<br> <br> For more information on the kubeconfig file, read the documentation <a target=\"_blank\" href=https://docs.cloudera.com/r/cdp-pvc-kubernetes>here</a>.")
    public String getKubeConfig() {
        return this.kubeConfig;
    }

    public void setKubeConfig(String kubeConfig) {
        this.kubeConfig = kubeConfig;
    }

    public ApiUpgradeControlPlaneArgs valuesYaml(String valuesYaml) {
        this.valuesYaml = valuesYaml;
        return this;
    }

    @ApiModelProperty(value="To see sample values.yaml files, read the documentation <a target=\"_blank\" href=https://docs.cloudera.com/r/cdp-pvc-upgrade-values-yaml>here</a>.")
    public String getValuesYaml() {
        return this.valuesYaml;
    }

    public void setValuesYaml(String valuesYaml) {
        this.valuesYaml = valuesYaml;
    }

    public ApiUpgradeControlPlaneArgs remoteRepoUrl(String remoteRepoUrl) {
        this.remoteRepoUrl = remoteRepoUrl;
        return this;
    }

    @ApiModelProperty(value="The url of the remote repository where the private cloud artifacts for the target version of the upgrade are hosted")
    public String getRemoteRepoUrl() {
        return this.remoteRepoUrl;
    }

    public void setRemoteRepoUrl(String remoteRepoUrl) {
        this.remoteRepoUrl = remoteRepoUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiUpgradeControlPlaneArgs apiUpgradeControlPlaneArgs = (ApiUpgradeControlPlaneArgs)o;
        return Objects.equals(this.kubeConfig, apiUpgradeControlPlaneArgs.kubeConfig) && Objects.equals(this.valuesYaml, apiUpgradeControlPlaneArgs.valuesYaml) && Objects.equals(this.remoteRepoUrl, apiUpgradeControlPlaneArgs.remoteRepoUrl);
    }

    public int hashCode() {
        return Objects.hash(this.kubeConfig, this.valuesYaml, this.remoteRepoUrl);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiUpgradeControlPlaneArgs {\n");
        sb.append("    kubeConfig: ").append(this.toIndentedString(this.kubeConfig)).append("\n");
        sb.append("    valuesYaml: ").append(this.toIndentedString(this.valuesYaml)).append("\n");
        sb.append("    remoteRepoUrl: ").append(this.toIndentedString(this.remoteRepoUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

