/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiServiceRef;
import com.cloudera.api.swagger.model.ReplicationStrategy;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Replication arguments for HDFS.")
public class ApiOzoneReplicationArguments {
    @SerializedName(value="sourceService")
    private ApiServiceRef sourceService = null;
    @SerializedName(value="sourcePath")
    private String sourcePath = null;
    @SerializedName(value="destinationPath")
    private String destinationPath = null;
    @SerializedName(value="mapreduceServiceName")
    private String mapreduceServiceName = null;
    @SerializedName(value="schedulerPoolName")
    private String schedulerPoolName = null;
    @SerializedName(value="userName")
    private String userName = null;
    @SerializedName(value="sourceUser")
    private String sourceUser = null;
    @SerializedName(value="numMaps")
    private BigDecimal numMaps = null;
    @SerializedName(value="dryRun")
    private Boolean dryRun = null;
    @SerializedName(value="bandwidthPerMap")
    private BigDecimal bandwidthPerMap = null;
    @SerializedName(value="abortOnError")
    private Boolean abortOnError = null;
    @SerializedName(value="removeMissingFiles")
    private Boolean removeMissingFiles = null;
    @SerializedName(value="preserveReplicationCount")
    private Boolean preserveReplicationCount = null;
    @SerializedName(value="preserveBlockSize")
    private Boolean preserveBlockSize = null;
    @SerializedName(value="preservePermissions")
    private Boolean preservePermissions = null;
    @SerializedName(value="logPath")
    private String logPath = null;
    @SerializedName(value="skipChecksumChecks")
    private Boolean skipChecksumChecks = null;
    @SerializedName(value="skipListingChecksumChecks")
    private Boolean skipListingChecksumChecks = null;
    @SerializedName(value="skipTrash")
    private Boolean skipTrash = null;
    @SerializedName(value="replicationStrategy")
    private ReplicationStrategy replicationStrategy = null;
    @SerializedName(value="preserveXAttrs")
    private Boolean preserveXAttrs = null;
    @SerializedName(value="exclusionFilters")
    private List<String> exclusionFilters = null;
    @SerializedName(value="raiseSnapshotDiffFailures")
    private Boolean raiseSnapshotDiffFailures = null;
    @SerializedName(value="deleteLatestSourceSnapshotOnJobFailure")
    private Boolean deleteLatestSourceSnapshotOnJobFailure = null;
    @SerializedName(value="destinationCloudAccount")
    private String destinationCloudAccount = null;
    @SerializedName(value="originalSourcePath")
    private String originalSourcePath = null;
    @SerializedName(value="originalDestinationPath")
    private String originalDestinationPath = null;

    public ApiOzoneReplicationArguments sourceService(ApiServiceRef sourceService) {
        this.sourceService = sourceService;
        return this;
    }

    @ApiModelProperty(value="The service to replicate from.")
    public ApiServiceRef getSourceService() {
        return this.sourceService;
    }

    public void setSourceService(ApiServiceRef sourceService) {
        this.sourceService = sourceService;
    }

    public ApiOzoneReplicationArguments sourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
        return this;
    }

    @ApiModelProperty(value="The path to replicate.")
    public String getSourcePath() {
        return this.sourcePath;
    }

    public void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    public ApiOzoneReplicationArguments destinationPath(String destinationPath) {
        this.destinationPath = destinationPath;
        return this;
    }

    @ApiModelProperty(value="The destination to replicate to.")
    public String getDestinationPath() {
        return this.destinationPath;
    }

    public void setDestinationPath(String destinationPath) {
        this.destinationPath = destinationPath;
    }

    public ApiOzoneReplicationArguments mapreduceServiceName(String mapreduceServiceName) {
        this.mapreduceServiceName = mapreduceServiceName;
        return this;
    }

    @ApiModelProperty(value="The mapreduce service to use for the replication job.")
    public String getMapreduceServiceName() {
        return this.mapreduceServiceName;
    }

    public void setMapreduceServiceName(String mapreduceServiceName) {
        this.mapreduceServiceName = mapreduceServiceName;
    }

    public ApiOzoneReplicationArguments schedulerPoolName(String schedulerPoolName) {
        this.schedulerPoolName = schedulerPoolName;
        return this;
    }

    @ApiModelProperty(value="Name of the scheduler pool to use when submitting the MapReduce job. Currently supports the capacity and fair schedulers. The option is ignored if a different scheduler is configured.")
    public String getSchedulerPoolName() {
        return this.schedulerPoolName;
    }

    public void setSchedulerPoolName(String schedulerPoolName) {
        this.schedulerPoolName = schedulerPoolName;
    }

    public ApiOzoneReplicationArguments userName(String userName) {
        this.userName = userName;
        return this;
    }

    @ApiModelProperty(value="The user which will execute the MapReduce job. Required if running with Kerberos enabled.")
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public ApiOzoneReplicationArguments sourceUser(String sourceUser) {
        this.sourceUser = sourceUser;
        return this;
    }

    @ApiModelProperty(value="The user which will perform operations on source cluster. Required if running with Kerberos enabled.")
    public String getSourceUser() {
        return this.sourceUser;
    }

    public void setSourceUser(String sourceUser) {
        this.sourceUser = sourceUser;
    }

    public ApiOzoneReplicationArguments numMaps(BigDecimal numMaps) {
        this.numMaps = numMaps;
        return this;
    }

    @ApiModelProperty(value="The number of mappers to use for the mapreduce replication job.")
    public BigDecimal getNumMaps() {
        return this.numMaps;
    }

    public void setNumMaps(BigDecimal numMaps) {
        this.numMaps = numMaps;
    }

    public ApiOzoneReplicationArguments dryRun(Boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    @ApiModelProperty(value="Whether to perform a dry run. Defaults to false.")
    public Boolean getDryRun() {
        return this.dryRun;
    }

    public void setDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
    }

    public ApiOzoneReplicationArguments bandwidthPerMap(BigDecimal bandwidthPerMap) {
        this.bandwidthPerMap = bandwidthPerMap;
        return this;
    }

    @ApiModelProperty(value="The maximum bandwidth (in MB) per mapper in the mapreduce replication job.")
    public BigDecimal getBandwidthPerMap() {
        return this.bandwidthPerMap;
    }

    public void setBandwidthPerMap(BigDecimal bandwidthPerMap) {
        this.bandwidthPerMap = bandwidthPerMap;
    }

    public ApiOzoneReplicationArguments abortOnError(Boolean abortOnError) {
        this.abortOnError = abortOnError;
        return this;
    }

    @ApiModelProperty(value="Whether to abort on a replication failure. Defaults to false.")
    public Boolean getAbortOnError() {
        return this.abortOnError;
    }

    public void setAbortOnError(Boolean abortOnError) {
        this.abortOnError = abortOnError;
    }

    public ApiOzoneReplicationArguments removeMissingFiles(Boolean removeMissingFiles) {
        this.removeMissingFiles = removeMissingFiles;
        return this;
    }

    @ApiModelProperty(value="Whether to delete destination files that are missing in source. Defaults to false.")
    public Boolean getRemoveMissingFiles() {
        return this.removeMissingFiles;
    }

    public void setRemoveMissingFiles(Boolean removeMissingFiles) {
        this.removeMissingFiles = removeMissingFiles;
    }

    public ApiOzoneReplicationArguments preserveReplicationCount(Boolean preserveReplicationCount) {
        this.preserveReplicationCount = preserveReplicationCount;
        return this;
    }

    @ApiModelProperty(value="Whether to preserve the HDFS replication count. Defaults to false.")
    public Boolean getPreserveReplicationCount() {
        return this.preserveReplicationCount;
    }

    public void setPreserveReplicationCount(Boolean preserveReplicationCount) {
        this.preserveReplicationCount = preserveReplicationCount;
    }

    public ApiOzoneReplicationArguments preserveBlockSize(Boolean preserveBlockSize) {
        this.preserveBlockSize = preserveBlockSize;
        return this;
    }

    @ApiModelProperty(value="Whether to preserve the HDFS block size. Defaults to false.")
    public Boolean getPreserveBlockSize() {
        return this.preserveBlockSize;
    }

    public void setPreserveBlockSize(Boolean preserveBlockSize) {
        this.preserveBlockSize = preserveBlockSize;
    }

    public ApiOzoneReplicationArguments preservePermissions(Boolean preservePermissions) {
        this.preservePermissions = preservePermissions;
        return this;
    }

    @ApiModelProperty(value="Whether to preserve the HDFS owner, group and permissions. Defaults to false. Starting from V10, it also preserves ACLs. Defaults to null (no preserve). ACLs is preserved if both clusters enable ACL support, and replication ignores any ACL related failures.")
    public Boolean getPreservePermissions() {
        return this.preservePermissions;
    }

    public void setPreservePermissions(Boolean preservePermissions) {
        this.preservePermissions = preservePermissions;
    }

    public ApiOzoneReplicationArguments logPath(String logPath) {
        this.logPath = logPath;
        return this;
    }

    @ApiModelProperty(value="The HDFS path where the replication log files should be written to.")
    public String getLogPath() {
        return this.logPath;
    }

    public void setLogPath(String logPath) {
        this.logPath = logPath;
    }

    public ApiOzoneReplicationArguments skipChecksumChecks(Boolean skipChecksumChecks) {
        this.skipChecksumChecks = skipChecksumChecks;
        return this;
    }

    @ApiModelProperty(value="Whether to skip checksum based file validation during replication. Defaults to false.")
    public Boolean getSkipChecksumChecks() {
        return this.skipChecksumChecks;
    }

    public void setSkipChecksumChecks(Boolean skipChecksumChecks) {
        this.skipChecksumChecks = skipChecksumChecks;
    }

    public ApiOzoneReplicationArguments skipListingChecksumChecks(Boolean skipListingChecksumChecks) {
        this.skipListingChecksumChecks = skipListingChecksumChecks;
        return this;
    }

    @ApiModelProperty(value="Whether to skip checksum based file comparison during replication. Defaults to false.")
    public Boolean getSkipListingChecksumChecks() {
        return this.skipListingChecksumChecks;
    }

    public void setSkipListingChecksumChecks(Boolean skipListingChecksumChecks) {
        this.skipListingChecksumChecks = skipListingChecksumChecks;
    }

    public ApiOzoneReplicationArguments skipTrash(Boolean skipTrash) {
        this.skipTrash = skipTrash;
        return this;
    }

    @ApiModelProperty(value="Whether to permanently delete destination files that are missing in source. Defaults to null.")
    public Boolean getSkipTrash() {
        return this.skipTrash;
    }

    public void setSkipTrash(Boolean skipTrash) {
        this.skipTrash = skipTrash;
    }

    public ApiOzoneReplicationArguments replicationStrategy(ReplicationStrategy replicationStrategy) {
        this.replicationStrategy = replicationStrategy;
        return this;
    }

    @ApiModelProperty(value="The strategy for distributing the file replication tasks among the mappers of the MR job associated with a replication. Default is ReplicationStrategy#STATIC.")
    public ReplicationStrategy getReplicationStrategy() {
        return this.replicationStrategy;
    }

    public void setReplicationStrategy(ReplicationStrategy replicationStrategy) {
        this.replicationStrategy = replicationStrategy;
    }

    public ApiOzoneReplicationArguments preserveXAttrs(Boolean preserveXAttrs) {
        this.preserveXAttrs = preserveXAttrs;
        return this;
    }

    @ApiModelProperty(value="Whether to preserve XAttrs, default to false This is introduced in V10. To preserve XAttrs, both CDH versions should be >= 5.2. Replication fails if either cluster does not support XAttrs.")
    public Boolean getPreserveXAttrs() {
        return this.preserveXAttrs;
    }

    public void setPreserveXAttrs(Boolean preserveXAttrs) {
        this.preserveXAttrs = preserveXAttrs;
    }

    public ApiOzoneReplicationArguments exclusionFilters(List<String> exclusionFilters) {
        this.exclusionFilters = exclusionFilters;
        return this;
    }

    public ApiOzoneReplicationArguments addExclusionFiltersItem(String exclusionFiltersItem) {
        if (this.exclusionFilters == null) {
            this.exclusionFilters = new ArrayList<String>();
        }
        this.exclusionFilters.add(exclusionFiltersItem);
        return this;
    }

    @ApiModelProperty(value="Specify regular expression strings to match full paths of files and directories matching source paths and exclude them from the replication. Optional. Available since V11.")
    public List<String> getExclusionFilters() {
        return this.exclusionFilters;
    }

    public void setExclusionFilters(List<String> exclusionFilters) {
        this.exclusionFilters = exclusionFilters;
    }

    public ApiOzoneReplicationArguments raiseSnapshotDiffFailures(Boolean raiseSnapshotDiffFailures) {
        this.raiseSnapshotDiffFailures = raiseSnapshotDiffFailures;
        return this;
    }

    @ApiModelProperty(value="Flag indicating if failures during snapshotDiff should be ignored or not. When it is set to false then, replication will fallback to full copy listing in case of any error in snapshot diff handling and it will ignore snapshot delete/rename failures at the end of a replication. The flag is by default set to false in distcp tool which means it will ignore snapshot diff failures and mark replication as success for snapshot delete/rename failures. In UI, the flag is set to true by default when source CM Version is greater than 5.14.")
    public Boolean getRaiseSnapshotDiffFailures() {
        return this.raiseSnapshotDiffFailures;
    }

    public void setRaiseSnapshotDiffFailures(Boolean raiseSnapshotDiffFailures) {
        this.raiseSnapshotDiffFailures = raiseSnapshotDiffFailures;
    }

    public ApiOzoneReplicationArguments deleteLatestSourceSnapshotOnJobFailure(Boolean deleteLatestSourceSnapshotOnJobFailure) {
        this.deleteLatestSourceSnapshotOnJobFailure = deleteLatestSourceSnapshotOnJobFailure;
        return this;
    }

    @ApiModelProperty(value="A flag configuring distcp behaviour for the case when the distcp mapreduce job fails. This failure is sometimes due to some issues with the snapshot. By default, in case of mapreduce job failure the latest source side snapshot is deleted. Set this flag to false to make this replication not delete the last successfully replicated old snapshot of the source dataset in case of job failure. The default value of this flag is true. Not setting this flag is equivalent to the value true.")
    public Boolean getDeleteLatestSourceSnapshotOnJobFailure() {
        return this.deleteLatestSourceSnapshotOnJobFailure;
    }

    public void setDeleteLatestSourceSnapshotOnJobFailure(Boolean deleteLatestSourceSnapshotOnJobFailure) {
        this.deleteLatestSourceSnapshotOnJobFailure = deleteLatestSourceSnapshotOnJobFailure;
    }

    public ApiOzoneReplicationArguments destinationCloudAccount(String destinationCloudAccount) {
        this.destinationCloudAccount = destinationCloudAccount;
        return this;
    }

    @ApiModelProperty(value="The cloud account name which is used in direct hive cloud replication, if specified.")
    public String getDestinationCloudAccount() {
        return this.destinationCloudAccount;
    }

    public void setDestinationCloudAccount(String destinationCloudAccount) {
        this.destinationCloudAccount = destinationCloudAccount;
    }

    public ApiOzoneReplicationArguments originalSourcePath(String originalSourcePath) {
        this.originalSourcePath = originalSourcePath;
        return this;
    }

    @ApiModelProperty(value="")
    public String getOriginalSourcePath() {
        return this.originalSourcePath;
    }

    public void setOriginalSourcePath(String originalSourcePath) {
        this.originalSourcePath = originalSourcePath;
    }

    public ApiOzoneReplicationArguments originalDestinationPath(String originalDestinationPath) {
        this.originalDestinationPath = originalDestinationPath;
        return this;
    }

    @ApiModelProperty(value="")
    public String getOriginalDestinationPath() {
        return this.originalDestinationPath;
    }

    public void setOriginalDestinationPath(String originalDestinationPath) {
        this.originalDestinationPath = originalDestinationPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiOzoneReplicationArguments apiOzoneReplicationArguments = (ApiOzoneReplicationArguments)o;
        return Objects.equals(this.sourceService, apiOzoneReplicationArguments.sourceService) && Objects.equals(this.sourcePath, apiOzoneReplicationArguments.sourcePath) && Objects.equals(this.destinationPath, apiOzoneReplicationArguments.destinationPath) && Objects.equals(this.mapreduceServiceName, apiOzoneReplicationArguments.mapreduceServiceName) && Objects.equals(this.schedulerPoolName, apiOzoneReplicationArguments.schedulerPoolName) && Objects.equals(this.userName, apiOzoneReplicationArguments.userName) && Objects.equals(this.sourceUser, apiOzoneReplicationArguments.sourceUser) && Objects.equals(this.numMaps, apiOzoneReplicationArguments.numMaps) && Objects.equals(this.dryRun, apiOzoneReplicationArguments.dryRun) && Objects.equals(this.bandwidthPerMap, apiOzoneReplicationArguments.bandwidthPerMap) && Objects.equals(this.abortOnError, apiOzoneReplicationArguments.abortOnError) && Objects.equals(this.removeMissingFiles, apiOzoneReplicationArguments.removeMissingFiles) && Objects.equals(this.preserveReplicationCount, apiOzoneReplicationArguments.preserveReplicationCount) && Objects.equals(this.preserveBlockSize, apiOzoneReplicationArguments.preserveBlockSize) && Objects.equals(this.preservePermissions, apiOzoneReplicationArguments.preservePermissions) && Objects.equals(this.logPath, apiOzoneReplicationArguments.logPath) && Objects.equals(this.skipChecksumChecks, apiOzoneReplicationArguments.skipChecksumChecks) && Objects.equals(this.skipListingChecksumChecks, apiOzoneReplicationArguments.skipListingChecksumChecks) && Objects.equals(this.skipTrash, apiOzoneReplicationArguments.skipTrash) && Objects.equals((Object)this.replicationStrategy, (Object)apiOzoneReplicationArguments.replicationStrategy) && Objects.equals(this.preserveXAttrs, apiOzoneReplicationArguments.preserveXAttrs) && Objects.equals(this.exclusionFilters, apiOzoneReplicationArguments.exclusionFilters) && Objects.equals(this.raiseSnapshotDiffFailures, apiOzoneReplicationArguments.raiseSnapshotDiffFailures) && Objects.equals(this.deleteLatestSourceSnapshotOnJobFailure, apiOzoneReplicationArguments.deleteLatestSourceSnapshotOnJobFailure) && Objects.equals(this.destinationCloudAccount, apiOzoneReplicationArguments.destinationCloudAccount) && Objects.equals(this.originalSourcePath, apiOzoneReplicationArguments.originalSourcePath) && Objects.equals(this.originalDestinationPath, apiOzoneReplicationArguments.originalDestinationPath);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sourceService, this.sourcePath, this.destinationPath, this.mapreduceServiceName, this.schedulerPoolName, this.userName, this.sourceUser, this.numMaps, this.dryRun, this.bandwidthPerMap, this.abortOnError, this.removeMissingFiles, this.preserveReplicationCount, this.preserveBlockSize, this.preservePermissions, this.logPath, this.skipChecksumChecks, this.skipListingChecksumChecks, this.skipTrash, this.replicationStrategy, this.preserveXAttrs, this.exclusionFilters, this.raiseSnapshotDiffFailures, this.deleteLatestSourceSnapshotOnJobFailure, this.destinationCloudAccount, this.originalSourcePath, this.originalDestinationPath});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiOzoneReplicationArguments {\n");
        sb.append("    sourceService: ").append(this.toIndentedString(this.sourceService)).append("\n");
        sb.append("    sourcePath: ").append(this.toIndentedString(this.sourcePath)).append("\n");
        sb.append("    destinationPath: ").append(this.toIndentedString(this.destinationPath)).append("\n");
        sb.append("    mapreduceServiceName: ").append(this.toIndentedString(this.mapreduceServiceName)).append("\n");
        sb.append("    schedulerPoolName: ").append(this.toIndentedString(this.schedulerPoolName)).append("\n");
        sb.append("    userName: ").append(this.toIndentedString(this.userName)).append("\n");
        sb.append("    sourceUser: ").append(this.toIndentedString(this.sourceUser)).append("\n");
        sb.append("    numMaps: ").append(this.toIndentedString(this.numMaps)).append("\n");
        sb.append("    dryRun: ").append(this.toIndentedString(this.dryRun)).append("\n");
        sb.append("    bandwidthPerMap: ").append(this.toIndentedString(this.bandwidthPerMap)).append("\n");
        sb.append("    abortOnError: ").append(this.toIndentedString(this.abortOnError)).append("\n");
        sb.append("    removeMissingFiles: ").append(this.toIndentedString(this.removeMissingFiles)).append("\n");
        sb.append("    preserveReplicationCount: ").append(this.toIndentedString(this.preserveReplicationCount)).append("\n");
        sb.append("    preserveBlockSize: ").append(this.toIndentedString(this.preserveBlockSize)).append("\n");
        sb.append("    preservePermissions: ").append(this.toIndentedString(this.preservePermissions)).append("\n");
        sb.append("    logPath: ").append(this.toIndentedString(this.logPath)).append("\n");
        sb.append("    skipChecksumChecks: ").append(this.toIndentedString(this.skipChecksumChecks)).append("\n");
        sb.append("    skipListingChecksumChecks: ").append(this.toIndentedString(this.skipListingChecksumChecks)).append("\n");
        sb.append("    skipTrash: ").append(this.toIndentedString(this.skipTrash)).append("\n");
        sb.append("    replicationStrategy: ").append(this.toIndentedString((Object)this.replicationStrategy)).append("\n");
        sb.append("    preserveXAttrs: ").append(this.toIndentedString(this.preserveXAttrs)).append("\n");
        sb.append("    exclusionFilters: ").append(this.toIndentedString(this.exclusionFilters)).append("\n");
        sb.append("    raiseSnapshotDiffFailures: ").append(this.toIndentedString(this.raiseSnapshotDiffFailures)).append("\n");
        sb.append("    deleteLatestSourceSnapshotOnJobFailure: ").append(this.toIndentedString(this.deleteLatestSourceSnapshotOnJobFailure)).append("\n");
        sb.append("    destinationCloudAccount: ").append(this.toIndentedString(this.destinationCloudAccount)).append("\n");
        sb.append("    originalSourcePath: ").append(this.toIndentedString(this.originalSourcePath)).append("\n");
        sb.append("    originalDestinationPath: ").append(this.toIndentedString(this.originalDestinationPath)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

