/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Arguments to install certificates on a host")
public class ApiGenerateHostCertsArguments {
    @SerializedName(value="sshPort")
    private BigDecimal sshPort = null;
    @SerializedName(value="userName")
    private String userName = null;
    @SerializedName(value="password")
    private String password = null;
    @SerializedName(value="privateKey")
    private String privateKey = null;
    @SerializedName(value="passphrase")
    private String passphrase = null;
    @SerializedName(value="subjectAltName")
    private List<String> subjectAltName = null;

    public ApiGenerateHostCertsArguments sshPort(BigDecimal sshPort) {
        this.sshPort = sshPort;
        return this;
    }

    @ApiModelProperty(example="22", value="SSH port. If unset, defaults to 22.")
    public BigDecimal getSshPort() {
        return this.sshPort;
    }

    public void setSshPort(BigDecimal sshPort) {
        this.sshPort = sshPort;
    }

    public ApiGenerateHostCertsArguments userName(String userName) {
        this.userName = userName;
        return this;
    }

    @ApiModelProperty(value="The username used to authenticate with the hosts. Root access to your hosts is required to install Cloudera packages. The installer will connect to your hosts via SSH and log in either directly as root or as another user with password-less sudo privileges to become root.")
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public ApiGenerateHostCertsArguments password(String password) {
        this.password = password;
        return this;
    }

    @ApiModelProperty(value="The password used to authenticate with the hosts. Specify either this or a private key. For password-less login, use an empty string as password.")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public ApiGenerateHostCertsArguments privateKey(String privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    @ApiModelProperty(value="The private key to authenticate with the hosts. Specify either this or a password. <br> The private key, if specified, needs to be a standard PEM-encoded key as a single string, with all line breaks replaced with the line-feed control character '\\n'. <br> A value will typically look like the following string: <br> -----BEGIN RSA PRIVATE KEY-----\\n[base-64 encoded key]\\n-----END RSA PRIVATE KEY----- <br>")
    public String getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public ApiGenerateHostCertsArguments passphrase(String passphrase) {
        this.passphrase = passphrase;
        return this;
    }

    @ApiModelProperty(value="The passphrase associated with the private key used to authenticate with the hosts (optional).")
    public String getPassphrase() {
        return this.passphrase;
    }

    public void setPassphrase(String passphrase) {
        this.passphrase = passphrase;
    }

    public ApiGenerateHostCertsArguments subjectAltName(List<String> subjectAltName) {
        this.subjectAltName = subjectAltName;
        return this;
    }

    public ApiGenerateHostCertsArguments addSubjectAltNameItem(String subjectAltNameItem) {
        if (this.subjectAltName == null) {
            this.subjectAltName = new ArrayList<String>();
        }
        this.subjectAltName.add(subjectAltNameItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<String> getSubjectAltName() {
        return this.subjectAltName;
    }

    public void setSubjectAltName(List<String> subjectAltName) {
        this.subjectAltName = subjectAltName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiGenerateHostCertsArguments apiGenerateHostCertsArguments = (ApiGenerateHostCertsArguments)o;
        return Objects.equals(this.sshPort, apiGenerateHostCertsArguments.sshPort) && Objects.equals(this.userName, apiGenerateHostCertsArguments.userName) && Objects.equals(this.password, apiGenerateHostCertsArguments.password) && Objects.equals(this.privateKey, apiGenerateHostCertsArguments.privateKey) && Objects.equals(this.passphrase, apiGenerateHostCertsArguments.passphrase) && Objects.equals(this.subjectAltName, apiGenerateHostCertsArguments.subjectAltName);
    }

    public int hashCode() {
        return Objects.hash(this.sshPort, this.userName, this.password, this.privateKey, this.passphrase, this.subjectAltName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiGenerateHostCertsArguments {\n");
        sb.append("    sshPort: ").append(this.toIndentedString(this.sshPort)).append("\n");
        sb.append("    userName: ").append(this.toIndentedString(this.userName)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    privateKey: ").append(this.toIndentedString(this.privateKey)).append("\n");
        sb.append("    passphrase: ").append(this.toIndentedString(this.passphrase)).append("\n");
        sb.append("    subjectAltName: ").append(this.toIndentedString(this.subjectAltName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

