/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.security.token;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import org.apache.knox.gateway.services.security.token.TokenMetadata;

public class KnoxToken
implements Comparable<KnoxToken> {
    public static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static final ThreadLocal<DateFormat> KNOX_TOKEN_TS_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat(DATE_FORMAT, Locale.getDefault()));
    private final String tokenId;
    private final long issueTime;
    private final long expiration;
    private final long maxLifetime;
    private TokenMetadata metadata;

    public KnoxToken(String tokenId, long issueTime, long expiration, long maxLifetimeDuration) {
        this(tokenId, issueTime, expiration, maxLifetimeDuration, new TokenMetadata(Collections.emptyMap()));
    }

    public KnoxToken(String tokenId, long issueTime, long expiration, long maxLifetime, TokenMetadata metadata) {
        this.tokenId = tokenId;
        this.issueTime = issueTime;
        this.expiration = expiration;
        this.maxLifetime = maxLifetime;
        this.metadata = metadata;
    }

    public String getTokenId() {
        return this.tokenId;
    }

    public String getIssueTime() {
        return KNOX_TOKEN_TS_FORMAT.get().format(new Date(this.issueTime));
    }

    public long getIssueTimeLong() {
        return this.issueTime;
    }

    public String getExpiration() {
        return KNOX_TOKEN_TS_FORMAT.get().format(new Date(this.expiration));
    }

    public long getExpirationLong() {
        return this.expiration;
    }

    public String getMaxLifetime() {
        return KNOX_TOKEN_TS_FORMAT.get().format(new Date(this.maxLifetime));
    }

    public long getMaxLifetimeLong() {
        return this.maxLifetime;
    }

    public TokenMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(TokenMetadata metadata) {
        this.metadata = metadata;
    }

    public String getMetadataValue(String key) {
        return this.metadata == null ? null : this.metadata.getMetadata(key);
    }

    public boolean hasMetadata(String key) {
        return this.getMetadataValue(key) != null;
    }

    @Override
    public int compareTo(KnoxToken other) {
        return Long.compare(this.issueTime, other.issueTime);
    }

    public void addMetadata(String name, String value) {
        this.metadata.add(name, value);
    }
}

