/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.registry.impl;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.knox.gateway.GatewayMessages;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteRulesDescriptor;
import org.apache.knox.gateway.filter.rewrite.impl.xml.XmlUrlRewriteRulesExporter;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.service.definition.Route;
import org.apache.knox.gateway.service.definition.ServiceDefinition;
import org.apache.knox.gateway.service.definition.ServiceDefinitionChangeListener;
import org.apache.knox.gateway.service.definition.ServiceDefinitionPair;
import org.apache.knox.gateway.services.Service;
import org.apache.knox.gateway.services.ServiceLifecycleException;
import org.apache.knox.gateway.services.registry.ServiceDefEntry;
import org.apache.knox.gateway.services.registry.ServiceDefinitionRegistry;
import org.apache.knox.gateway.services.registry.ServiceDefinitionRegistryException;
import org.apache.knox.gateway.services.registry.impl.DefaultServiceDefEntry;
import org.apache.knox.gateway.util.ServiceDefinitionsLoader;
import org.apache.knox.gateway.util.urltemplate.Matcher;
import org.apache.knox.gateway.util.urltemplate.Parser;
import org.apache.knox.gateway.util.urltemplate.Template;

public class DefaultServiceDefinitionRegistry
implements ServiceDefinitionRegistry,
Service {
    private static GatewayMessages LOG = (GatewayMessages)MessagesFactory.get(GatewayMessages.class);
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock writeLock = this.lock.writeLock();
    private final Lock readLock = this.lock.readLock();
    private final Collection<ServiceDefinitionChangeListener> listeners = new HashSet<ServiceDefinitionChangeListener>();
    private final XmlUrlRewriteRulesExporter xmlRewriteRulesExporter = new XmlUrlRewriteRulesExporter();
    private GatewayConfig gatewayConfig;
    private Matcher<ServiceDefEntry> entries = new Matcher();
    private Set<ServiceDefinitionPair> serviceDefinitions;
    private JAXBContext jaxbContext;

    public void init(GatewayConfig config, Map<String, String> options) throws ServiceLifecycleException {
        this.gatewayConfig = config;
        this.writeLock.lock();
        try {
            this.populateServiceDefinitions();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void populateServiceDefinitions() {
        this.serviceDefinitions = ServiceDefinitionsLoader.loadServiceDefinitions(new File(this.gatewayConfig.getGatewayServicesDir()));
        for (ServiceDefinition serviceDefinition : this.getServices()) {
            List routes = serviceDefinition.getRoutes();
            for (Route route : routes) {
                try {
                    Template template = Parser.parseTemplate((String)route.getPath());
                    this.addServiceDefEntry(template, serviceDefinition);
                }
                catch (URISyntaxException e) {
                    LOG.failedToParsePath(route.getPath(), e);
                }
            }
        }
    }

    private void addServiceDefEntry(Template template, ServiceDefinition serviceDefinition) {
        ServiceDefEntry entry = (ServiceDefEntry)this.entries.get(template);
        if (entry == null) {
            this.entries.add(template, (Object)new DefaultServiceDefEntry(serviceDefinition.getRole(), serviceDefinition.getName(), template.getPattern()));
        }
    }

    public void start() throws ServiceLifecycleException {
    }

    public void stop() throws ServiceLifecycleException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceDefEntry getMatchingService(String urlPattern) {
        this.readLock.lock();
        try {
            Matcher.Match match = null;
            try {
                match = this.entries.match(Parser.parseLiteral((String)urlPattern));
            }
            catch (URISyntaxException e) {
                LOG.failedToParsePath(urlPattern, e);
            }
            if (match != null) {
                ServiceDefEntry serviceDefEntry = (ServiceDefEntry)match.getValue();
                return serviceDefEntry;
            }
            ServiceDefEntry serviceDefEntry = null;
            return serviceDefEntry;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<ServiceDefinitionPair> getServiceDefinitions() {
        this.readLock.lock();
        try {
            Set<ServiceDefinitionPair> set = Collections.unmodifiableSet(this.serviceDefinitions);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void saveServiceDefinition(ServiceDefinitionPair serviceDefinition) throws ServiceDefinitionRegistryException {
        this.saveOrUpdateServiceDefinition(serviceDefinition, false);
        LOG.savedServiceDefinitionChange(serviceDefinition.getService().getName(), serviceDefinition.getService().getRole(), serviceDefinition.getService().getVersion());
    }

    public void saveOrUpdateServiceDefinition(ServiceDefinitionPair serviceDefinition) throws ServiceDefinitionRegistryException {
        this.saveOrUpdateServiceDefinition(serviceDefinition, true);
        LOG.updatedServiceDefinitionChange(serviceDefinition.getService().getName(), serviceDefinition.getService().getRole(), serviceDefinition.getService().getVersion());
    }

    public void saveOrUpdateServiceDefinition(ServiceDefinitionPair serviceDefinition, boolean allowUpdate) throws ServiceDefinitionRegistryException {
        ServiceDefinition service = serviceDefinition.getService();
        Optional<ServiceDefinition> persistedServiceDefinition = this.findServiceDefinition(service.getName(), service.getRole(), service.getVersion());
        if (persistedServiceDefinition.isPresent() && !allowUpdate) {
            throw new ServiceDefinitionRegistryException("The requested service definition (" + serviceDefinition.toString() + ") already exists!");
        }
        this.writeLock.lock();
        try {
            Path serviceDefinitionFolderPath = this.createServiceDefinitionFolders(service.getName(), service.getVersion());
            this.writeOutServiceDefinitionFile(service, serviceDefinitionFolderPath);
            if (serviceDefinition.getRewriteRules() != null) {
                this.writeOutRewriteRules(serviceDefinition.getRewriteRules(), serviceDefinitionFolderPath);
            }
            this.populateServiceDefinitions();
        }
        catch (IOException | JAXBException e) {
            throw new ServiceDefinitionRegistryException("Error while persisting service definition " + serviceDefinition.toString(), e);
        }
        finally {
            this.writeLock.unlock();
        }
        this.notifyListeners(service.getName(), service.getRole(), service.getVersion());
    }

    private Path createServiceDefinitionFolders(String name, String version) throws IOException {
        Path serviceDefinitionPath = Paths.get(this.gatewayConfig.getGatewayServicesDir(), name, version);
        return Files.createDirectories(serviceDefinitionPath, new FileAttribute[0]);
    }

    private void writeOutServiceDefinitionFile(ServiceDefinition serviceDefinition, Path serviceDefinitionFolderPath) throws JAXBException, IOException {
        Marshaller marshaller = this.getJaxbContext().createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        try (BufferedWriter serviceDefinitionXmlFileWriter = Files.newBufferedWriter(Paths.get(serviceDefinitionFolderPath.toAbsolutePath().toString(), "service.xml"), StandardCharsets.UTF_8, new OpenOption[0]);){
            marshaller.marshal((Object)serviceDefinition, (Writer)serviceDefinitionXmlFileWriter);
        }
    }

    private void writeOutRewriteRules(UrlRewriteRulesDescriptor rewriteRules, Path serviceDefinitionFolderPath) throws IOException {
        try (BufferedWriter rewriteRuleXmlFileWriter = Files.newBufferedWriter(Paths.get(serviceDefinitionFolderPath.toAbsolutePath().toString(), "rewrite.xml"), StandardCharsets.UTF_8, new OpenOption[0]);){
            this.xmlRewriteRulesExporter.store(rewriteRules, (Writer)rewriteRuleXmlFileWriter, true);
        }
    }

    private JAXBContext getJaxbContext() throws JAXBException {
        if (this.jaxbContext == null) {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ServiceDefinition.class});
        }
        return this.jaxbContext;
    }

    public void deleteServiceDefinition(String name, String role, String version) throws ServiceDefinitionRegistryException {
        Optional<ServiceDefinition> serviceDefinition = this.findServiceDefinition(name, role, version);
        if (serviceDefinition.isPresent()) {
            this.writeLock.lock();
            try {
                this.removeServiceDefinitionFolders(name, version);
                this.populateServiceDefinitions();
            }
            catch (IOException e) {
                throw new ServiceDefinitionRegistryException("Error while deleting service definition " + serviceDefinition.toString(), (Throwable)e);
            }
            finally {
                this.writeLock.unlock();
            }
        } else {
            throw new ServiceDefinitionRegistryException("There is no service definition with the given attributes: " + name + "," + role + "," + version);
        }
        this.notifyListeners(name, role, version);
        LOG.deletedServiceDefinitionChange(name, role, version);
    }

    private Set<ServiceDefinition> getServices() {
        return this.serviceDefinitions.stream().map(serviceDefinitionPair -> serviceDefinitionPair.getService()).collect(Collectors.toSet());
    }

    private Optional<ServiceDefinition> findServiceDefinition(String name, String role, String version) {
        return this.getServices().stream().filter(sd -> sd.getName().equalsIgnoreCase(name) && sd.getRole().equalsIgnoreCase(role) && sd.getVersion().equalsIgnoreCase(version)).findFirst();
    }

    private void removeServiceDefinitionFolders(String name, String version) throws IOException {
        Path serviceDefinitionPath = Paths.get(this.gatewayConfig.getGatewayServicesDir(), name, version);
        Files.walkFileTree(serviceDefinitionPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
        Path serviceFolderPath = Paths.get(this.gatewayConfig.getGatewayServicesDir(), name).toAbsolutePath();
        File serviceFolder = serviceFolderPath.toFile();
        if (serviceFolder.isDirectory() && serviceFolder.listFiles().length == 0) {
            Files.delete(serviceFolderPath);
        }
    }

    public void addServiceDefinitionChangeListener(ServiceDefinitionChangeListener listener) {
        this.listeners.add(listener);
    }

    private void notifyListeners(String name, String role, String version) {
        this.listeners.forEach(listener -> listener.onServiceDefinitionChange(name, role, version));
    }
}

