/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.filter;

import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.knox.gateway.GatewayMessages;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.filter.RequestUpdateHandler;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;

public class PortMappingHelperHandler
extends HandlerWrapper {
    private static final GatewayMessages LOG = (GatewayMessages)MessagesFactory.get(GatewayMessages.class);
    private final GatewayConfig config;
    private final String defaultTopologyRedirectContext;

    public PortMappingHelperHandler(GatewayConfig config) {
        this.config = config;
        this.defaultTopologyRedirectContext = this.getDefaultTopologyRedirectContext(config);
    }

    private String getDefaultTopologyRedirectContext(GatewayConfig config) {
        String defaultTopologyName = config.getDefaultTopologyName();
        String defaultTopologyRedirectContext = null;
        if (defaultTopologyName == null && config.getGatewayPortMappings().containsValue(config.getGatewayPort())) {
            for (Map.Entry entry : config.getGatewayPortMappings().entrySet()) {
                if (!((Integer)entry.getValue()).equals(config.getGatewayPort())) continue;
                defaultTopologyRedirectContext = "/" + config.getGatewayPath() + "/" + (String)entry.getKey();
                break;
            }
        }
        if (defaultTopologyName != null && (defaultTopologyRedirectContext = config.getDefaultAppRedirectPath()) != null && defaultTopologyRedirectContext.trim().isEmpty()) {
            defaultTopologyRedirectContext = null;
        }
        if (defaultTopologyRedirectContext != null) {
            LOG.defaultTopologySetup(defaultTopologyName, defaultTopologyRedirectContext);
        }
        return defaultTopologyRedirectContext;
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String baseURI = baseRequest.getRequestURI();
        int port = baseRequest.getLocalPort();
        if (this.config.isGatewayPortMappingEnabled() && this.config.getGatewayPortMappings().containsValue(port)) {
            this.handlePortMapping(target, baseRequest, request, response, port);
        } else if (this.defaultTopologyRedirectContext != null && !baseURI.startsWith("/" + this.config.getGatewayPath())) {
            this.handleDefaultTopologyMapping(target, baseRequest, request, response);
        } else {
            super.handle(target, baseRequest, request, response);
        }
    }

    private void handlePortMapping(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response, int port) throws IOException, ServletException {
        String topologyName = this.config.getGatewayPortMappings().entrySet().stream().filter(e -> ((Integer)e.getValue()).equals(port)).map(Map.Entry::getKey).findFirst().orElse(null);
        String gatewayTopologyContext = "/" + this.config.getGatewayPath() + "/" + topologyName;
        String newTarget = target;
        if (!target.contains(gatewayTopologyContext)) {
            newTarget = gatewayTopologyContext + target;
        }
        if (!baseRequest.getRequestURI().contains(gatewayTopologyContext)) {
            RequestUpdateHandler.ForwardedRequest newRequest = new RequestUpdateHandler.ForwardedRequest(request, gatewayTopologyContext);
            baseRequest.setPathInfo(gatewayTopologyContext + baseRequest.getPathInfo());
            baseRequest.setURIPathQuery(gatewayTopologyContext + baseRequest.getRequestURI());
            LOG.topologyPortMappingUpdateRequest(target, newTarget);
            super.handle(newTarget, baseRequest, (HttpServletRequest)newRequest, response);
        } else {
            super.handle(newTarget, baseRequest, request, response);
        }
    }

    private void handleDefaultTopologyMapping(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        RequestUpdateHandler.ForwardedRequest newRequest = new RequestUpdateHandler.ForwardedRequest(request, this.defaultTopologyRedirectContext);
        String newTarget = this.defaultTopologyRedirectContext + target;
        LOG.defaultTopologyForward(target, newTarget);
        super.handle(newTarget, baseRequest, (HttpServletRequest)newRequest, response);
    }
}

