/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.session;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.client.ClientFactoryManager;
import org.apache.sshd.client.future.AuthFuture;
import org.apache.sshd.client.future.DefaultAuthFuture;
import org.apache.sshd.client.session.AbstractClientSession;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.session.ClientUserAuthService;
import org.apache.sshd.common.Service;
import org.apache.sshd.common.ServiceFactory;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.kex.KexState;
import org.apache.sshd.common.session.SessionListener;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;

public class ClientSessionImpl
extends AbstractClientSession {
    private AuthFuture authFuture;
    private Map<Object, Object> metadataMap = new HashMap<Object, Object>();
    private boolean initialServiceRequestSent;
    private ServiceFactory currentServiceFactory;
    private Service nextService;
    private ServiceFactory nextServiceFactory;

    public ClientSessionImpl(ClientFactoryManager client, IoSession ioSession) throws Exception {
        super(client, ioSession);
        List<ServiceFactory> factories;
        int numFactories;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Client session created: {}", (Object)ioSession);
        }
        ValidateUtils.checkTrue((numFactories = GenericUtils.size(factories = client.getServiceFactories())) > 0 && numFactories <= 2, "One or two services must be configured: %d", numFactories);
        this.currentServiceFactory = factories.get(0);
        this.currentService = this.currentServiceFactory.create(this);
        if (numFactories > 1) {
            this.nextServiceFactory = factories.get(1);
            this.nextService = this.nextServiceFactory.create(this);
        } else {
            this.nextServiceFactory = null;
        }
        this.authFuture = new DefaultAuthFuture(ioSession.getRemoteAddress(), this.futureLock);
        this.authFuture.setAuthed(false);
        this.signalSessionCreated(ioSession);
        this.initializeProxyConnector();
        if (this.sendImmediateClientIdentification) {
            this.sendClientIdentification();
            if (this.sendImmediateKexInit) {
                this.initializeKeyExchangePhase();
            }
        }
    }

    @Override
    protected List<Service> getServices() {
        if (this.nextService != null) {
            return Arrays.asList(this.currentService, this.nextService);
        }
        return super.getServices();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthFuture auth() throws IOException {
        if (this.getUsername() == null) {
            throw new IllegalStateException("No username specified when the session was created");
        }
        ClientUserAuthService authService = this.getUserAuthService();
        Object object = this.sessionLock;
        synchronized (object) {
            String serviceName = this.nextServiceName();
            this.authFuture = ValidateUtils.checkNotNull(authService.auth(serviceName), "No auth future generated by service=%s", (Object)serviceName);
            return this.authFuture;
        }
    }

    @Override
    public void exceptionCaught(Throwable t) {
        this.signalAuthFailure(this.authFuture, t);
        super.exceptionCaught(t);
    }

    @Override
    protected void preClose() {
        this.signalAuthFailure(this.authFuture, new SshException("Session is being closed"));
        super.preClose();
    }

    @Override
    protected void handleDisconnect(int code, String msg, String lang, Buffer buffer) throws Exception {
        this.signalAuthFailure(this.authFuture, new SshException(code, msg));
        super.handleDisconnect(code, msg, lang, buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void signalAuthFailure(AuthFuture future, Throwable t) {
        boolean signalled = false;
        if (future != null) {
            AuthFuture authFuture = future;
            synchronized (authFuture) {
                if (!future.isDone()) {
                    future.setException(t);
                    signalled = true;
                }
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("signalAuthFailure({}) type={}, signalled={}: {}", new Object[]{this, t.getClass().getSimpleName(), signalled, t.getMessage()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String nextServiceName() {
        Object object = this.sessionLock;
        synchronized (object) {
            return this.nextServiceFactory.getName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchToNextService() throws IOException {
        Object object = this.sessionLock;
        synchronized (object) {
            if (this.nextService == null) {
                throw new IllegalStateException("No service available");
            }
            this.currentServiceFactory = this.nextServiceFactory;
            this.currentService = this.nextService;
            this.nextServiceFactory = null;
            this.nextService = null;
            this.currentService.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void signalSessionEvent(SessionListener.Event event) throws IOException {
        if (SessionListener.Event.KeyEstablished.equals((Object)event)) {
            this.sendInitialServiceRequest();
        }
        Object object = this.futureLock;
        synchronized (object) {
            this.futureLock.notifyAll();
        }
        super.signalSessionEvent(event);
    }

    protected void sendInitialServiceRequest() throws IOException {
        if (this.initialServiceRequestSent) {
            return;
        }
        this.initialServiceRequestSent = true;
        String serviceName = this.currentServiceFactory.getName();
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendInitialServiceRequest({}) Send SSH_MSG_SERVICE_REQUEST for {}", (Object)this, (Object)serviceName);
        }
        Buffer request = this.createBuffer((byte)5, serviceName.length() + 8);
        request.putString(serviceName);
        this.writePacket(request);
        this.currentService.start();
    }

    @Override
    public Set<ClientSession.ClientSessionEvent> waitFor(Collection<ClientSession.ClientSessionEvent> mask, long timeout) {
        Objects.requireNonNull(mask, "No mask specified");
        boolean traceEnabled = this.log.isTraceEnabled();
        long startTime = System.currentTimeMillis();
        Object object = this.futureLock;
        synchronized (object) {
            long remWait = timeout;
            EnumSet<ClientSession.ClientSessionEvent> cond = EnumSet.noneOf(ClientSession.ClientSessionEvent.class);
            while (true) {
                block16: {
                    long now;
                    long usedTime;
                    this.updateCurrentSessionState(cond);
                    boolean nothingInCommon = Collections.disjoint(cond, mask);
                    if (!nothingInCommon) {
                        if (traceEnabled) {
                            this.log.trace("waitFor({}) call return mask={}, cond={}", new Object[]{this, mask, cond});
                        }
                        return cond;
                    }
                    if (timeout > 0L && ((usedTime = (now = System.currentTimeMillis()) - startTime) >= timeout || remWait <= 0L)) {
                        if (traceEnabled) {
                            this.log.trace("waitFor({}) call timeout {}/{} for mask={}: {}", new Object[]{this, usedTime, timeout, mask, cond});
                        }
                        cond.add(ClientSession.ClientSessionEvent.TIMEOUT);
                        return cond;
                    }
                    if (traceEnabled) {
                        this.log.trace("waitFor({}) Waiting {} millis for lock on mask={}, cond={}", new Object[]{this, timeout, mask, cond});
                    }
                    long nanoStart = System.nanoTime();
                    try {
                        if (timeout > 0L) {
                            this.futureLock.wait(remWait);
                        } else {
                            this.futureLock.wait();
                        }
                        long nanoEnd = System.nanoTime();
                        long nanoDuration = nanoEnd - nanoStart;
                        if (traceEnabled) {
                            this.log.trace("waitFor({}) Lock notified after {} nanos", (Object)this, (Object)nanoDuration);
                        }
                        if (timeout > 0L) {
                            long waitDuration = TimeUnit.MILLISECONDS.convert(nanoDuration, TimeUnit.NANOSECONDS);
                            if (waitDuration <= 0L) {
                                waitDuration = 123L;
                            }
                            remWait -= waitDuration;
                        }
                    }
                    catch (InterruptedException e) {
                        long nanoEnd = System.nanoTime();
                        long nanoDuration = nanoEnd - nanoStart;
                        if (!traceEnabled) break block16;
                        this.log.trace("waitFor({}) mask={} - ignoring interrupted exception after {} nanos", new Object[]{this, mask, nanoDuration});
                    }
                }
                cond.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ClientSession.ClientSessionEvent> getSessionState() {
        EnumSet<ClientSession.ClientSessionEvent> state = EnumSet.noneOf(ClientSession.ClientSessionEvent.class);
        Object object = this.futureLock;
        synchronized (object) {
            return this.updateCurrentSessionState(state);
        }
    }

    protected <C extends Collection<ClientSession.ClientSessionEvent>> C updateCurrentSessionState(C state) {
        if (this.closeFuture.isClosed()) {
            state.add((ClientSession.ClientSessionEvent)ClientSession.ClientSessionEvent.CLOSED);
        }
        if (this.isAuthenticated()) {
            state.add((ClientSession.ClientSessionEvent)ClientSession.ClientSessionEvent.AUTHED);
        }
        if (KexState.DONE.equals(this.kexState.get()) && this.authFuture.isFailure()) {
            state.add((ClientSession.ClientSessionEvent)ClientSession.ClientSessionEvent.WAIT_AUTH);
        }
        return state;
    }

    @Override
    public Map<Object, Object> getMetadataMap() {
        return this.metadataMap;
    }
}

