/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.build;

import aQute.bnd.build.Project;
import aQute.bnd.build.Run;
import aQute.bnd.build.Workspace;
import aQute.bnd.build.api.BuildInfo;
import aQute.bnd.build.api.OnWorkspace;
import aQute.bnd.osgi.Processor;
import aQute.bnd.service.RepositoryPlugin;
import aQute.lib.collections.MultiMap;
import aQute.lib.concurrent.serial.SerialExecutor;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

class WorkspaceNotifier
implements Closeable {
    final MultiMap<ET, Receipt> ons = new MultiMap();
    final Map<ET, Object> last = new HashMap<ET, Object>();
    final Object lock = new Object();
    final Workspace workspace;
    final List<Runnable> events = new ArrayList<Runnable>();
    final SerialExecutor serial = new SerialExecutor(Processor.getExecutor());
    int revision = 1000;
    boolean closed;
    volatile boolean mute = true;

    WorkspaceNotifier(Workspace workspace) {
        this.workspace = workspace;
        this.last.put(ET.INIT, workspace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int initialized() {
        Object object = this.lock;
        synchronized (object) {
            this.last.clear();
            this.broadcast(ET.INIT, this.workspace);
            return ++this.revision;
        }
    }

    void message(Workspace workspace) {
        this.broadcast(ET.MESSAGE, workspace);
    }

    void closing(Workspace workspace) {
        this.broadcast(ET.CLOSING, workspace);
    }

    void repos(List<RepositoryPlugin> repos) {
        this.broadcast(ET.REPOS, repos);
    }

    void build(BuildInfo buildInfo) {
        this.broadcast(ET.BUILD, buildInfo);
    }

    public void projects(Collection<Project> projects) {
        this.broadcast(ET.PROJECTS, projects);
    }

    public void changedProject(Project project) {
        if (project.getClass() == Project.class) {
            this.broadcast(ET.CHANGEDPROJECT, project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void broadcast(ET type, T arg) {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed || this.mute) {
                return;
            }
            this.last.put(type, arg);
            Object list = this.ons.get((Object)type);
            if (list == null) {
                return;
            }
            this.serial.run(() -> WorkspaceNotifier.lambda$broadcast$1((List)list, arg));
        }
    }

    OnWorkspace on(final String name) {
        OnWorkspace on = new OnWorkspace(){
            List<Receipt> callbacks = new ArrayList<Receipt>();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private <T> OnWorkspace register(ET type, Consumer<T> cb) {
                Receipt r = new Receipt(type, cb, name);
                Object object = WorkspaceNotifier.this.lock;
                synchronized (object) {
                    if (!WorkspaceNotifier.this.closed) {
                        this.callbacks.add(r);
                        WorkspaceNotifier.this.ons.add(type, r);
                        Object v = WorkspaceNotifier.this.last.get((Object)type);
                        if (v != null) {
                            WorkspaceNotifier.this.serial.run(() -> r.callback(v));
                        }
                    }
                    return this;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                Object object = WorkspaceNotifier.this.lock;
                synchronized (object) {
                    this.callbacks.forEach(Receipt::close);
                }
            }

            @Override
            public OnWorkspace initial(Consumer<? super Workspace> cb) {
                return this.register(ET.INIT, cb);
            }

            @Override
            public OnWorkspace message(Consumer<? super Workspace> cb) {
                return this.register(ET.MESSAGE, cb);
            }

            @Override
            public OnWorkspace closing(Consumer<? super Workspace> cb) {
                return this.register(ET.CLOSING, cb);
            }

            @Override
            public OnWorkspace repositoriesReady(Consumer<? super Collection<RepositoryPlugin>> cb) {
                return this.register(ET.REPOS, cb);
            }

            @Override
            public OnWorkspace build(Consumer<? super BuildInfo> cb) {
                return this.register(ET.BUILD, cb);
            }

            @Override
            public OnWorkspace projects(Consumer<? super Collection<Project>> cb) {
                return this.register(ET.PROJECTS, cb);
            }

            @Override
            public OnWorkspace changedProject(Consumer<? super Project> cb) {
                return this.register(ET.CHANGEDPROJECT, cb);
            }

            @Override
            public OnWorkspace changedRun(Consumer<? super Run> cb) {
                return this.register(ET.CHANGEDBNDRUN, cb);
            }
        };
        return on;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> void ifSameRevision(int revision, ET type, T arg) {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            if (revision != this.revision) {
                return;
            }
            this.broadcast(type, arg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.closed = true;
        }
    }

    private static /* synthetic */ void lambda$broadcast$1(List list, Object arg) {
        list.forEach(receipt -> receipt.callback(arg));
    }

    static enum ET {
        INIT,
        MESSAGE,
        CLOSING,
        REPOS,
        BUILD,
        PROJECTS,
        CHANGEDPROJECT,
        CHANGEDBNDRUN;

    }

    class Receipt {
        final ET type;
        final Consumer<Object> callback;
        final String name;
        boolean closed = false;

        <T> Receipt(ET type, Consumer<T> cb, String name) {
            this.type = type;
            this.name = name;
            this.callback = cb;
        }

        synchronized void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            WorkspaceNotifier.this.ons.get((Object)this.type).remove(this);
        }

        synchronized void callback(Object o) {
            if (this.closed) {
                return;
            }
            try {
                this.callback.accept(o);
            }
            catch (Exception e) {
                Workspace.logger.error("{} callback from workspace notifier for type {} failed. Ignored", new Object[]{this.name, this.type, e});
            }
        }
    }
}

