/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util;

import java.util.Comparator;
import java.util.Map;
import java.util.Objects;

public class Pair<F, S>
implements Map.Entry<F, S> {
    private static final Comparator<Map.Entry<Comparable, ?>> BY_KEY_COMPARATOR = (o1, o2) -> {
        Comparable k1 = (Comparable)o1.getKey();
        Comparable k2 = (Comparable)o2.getKey();
        return k1.compareTo(k2);
    };
    private final F first;
    private final S second;

    public Pair(F first, S second) {
        this.first = first;
        this.second = second;
    }

    @Override
    public final F getKey() {
        return this.getFirst();
    }

    @Override
    public S getValue() {
        return this.getSecond();
    }

    @Override
    public S setValue(S value) {
        throw new UnsupportedOperationException("setValue(" + value + ") N/A");
    }

    public final F getFirst() {
        return this.first;
    }

    public final S getSecond() {
        return this.second;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.getFirst()) * 31 + Objects.hashCode(this.getSecond());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Pair other = (Pair)obj;
        return Objects.equals(this.getFirst(), other.getFirst()) && Objects.equals(this.getSecond(), other.getSecond());
    }

    public String toString() {
        return Objects.toString(this.getFirst()) + ", " + Objects.toString(this.getSecond());
    }

    public static <K extends Comparable<K>, V> Comparator<Map.Entry<K, V>> byKeyEntryComparator() {
        return BY_KEY_COMPARATOR;
    }
}

