/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.compression;

import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.sshd.common.Compression;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.util.Buffer;

public class CompressionZlib
implements Compression {
    private static final int BUF_SIZE = 4096;
    private byte[] tmpbuf = new byte[4096];
    private Deflater compresser;
    private Inflater decompresser;

    public boolean isDelayed() {
        return false;
    }

    public void init(Compression.Type type, int level) {
        this.compresser = new Deflater(level);
        this.decompresser = new Inflater();
    }

    public void compress(Buffer buffer) throws IOException {
        int len;
        this.compresser.setInput(buffer.array(), buffer.rpos(), buffer.available());
        buffer.wpos(buffer.rpos());
        while ((len = this.compresser.deflate(this.tmpbuf, 0, this.tmpbuf.length, 2)) > 0) {
            buffer.putRawBytes(this.tmpbuf, 0, len);
        }
    }

    public void uncompress(Buffer from, Buffer to) throws IOException {
        this.decompresser.setInput(from.array(), from.rpos(), from.available());
        try {
            int len;
            while ((len = this.decompresser.inflate(this.tmpbuf)) > 0) {
                to.putRawBytes(this.tmpbuf, 0, len);
            }
        }
        catch (DataFormatException e) {
            throw new IOException("Error decompressing data", e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements NamedFactory<Compression> {
        @Override
        public String getName() {
            return "zlib";
        }

        @Override
        public Compression create() {
            return new CompressionZlib();
        }
    }
}

