/*
 * Decompiled with CFR 0.152.
 */
package org.jledit.command.editor;

import org.jledit.ConsoleEditor;
import org.jledit.command.undo.UndoableCommand;

public abstract class AbstractUndoableCommand
implements UndoableCommand {
    private final ConsoleEditor editor;
    private int beforeLine;
    private int beforeColumn;
    private int afterLine;
    private int afterColumn;

    public AbstractUndoableCommand(ConsoleEditor editor) {
        this.editor = editor;
    }

    @Override
    public final void execute() {
        this.beforeLine = this.editor.getLine();
        this.beforeColumn = this.editor.getColumn();
        this.doExecute();
        this.afterLine = this.editor.getLine();
        this.afterColumn = this.editor.getColumn();
    }

    @Override
    public final void redo() {
        if (!this.getEditor().isReadOnly()) {
            this.getEditor().move(this.getBeforeLine(), this.getBeforeColumn());
            this.doExecute();
        }
    }

    public ConsoleEditor getEditor() {
        return this.editor;
    }

    @Override
    public int getBeforeLine() {
        return this.beforeLine;
    }

    public void setBeforeLine(int line) {
        this.beforeLine = line;
    }

    @Override
    public int getBeforeColumn() {
        return this.beforeColumn;
    }

    public void setBeforeColumn(int column) {
        this.beforeColumn = column;
    }

    @Override
    public int getAfterLine() {
        return this.afterLine;
    }

    public void setAfterLine(int afterLine) {
        this.afterLine = afterLine;
    }

    @Override
    public int getAfterColumn() {
        return this.afterColumn;
    }

    public void setAfterColumn(int afterColumn) {
        this.afterColumn = afterColumn;
    }
}

