/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.util.Collection;
import java.util.StringTokenizer;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.james.core.MailAddress;
import org.apache.mailet.Experimental;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMatcher;

@Experimental
public class CompareNumericHeaderValue
extends GenericMatcher {
    private String headerName = null;
    private int comparisonOperator;
    private static final int LT = -2;
    private static final int LE = -1;
    private static final int EQ = 0;
    private static final int GE = 1;
    private static final int GT = 2;
    private Double headerValue;

    public void init() throws MessagingException {
        StringTokenizer st = new StringTokenizer(this.getCondition(), " \t", false);
        if (!st.hasMoreTokens()) {
            throw new MessagingException("Missing headerName");
        }
        this.headerName = st.nextToken().trim();
        if (st.hasMoreTokens()) {
            String comparisonOperatorString;
            switch (comparisonOperatorString = st.nextToken().trim()) {
                case "<": 
                case "LT": {
                    this.comparisonOperator = -2;
                    break;
                }
                case "<=": 
                case "=<": 
                case "LE": {
                    this.comparisonOperator = -1;
                    break;
                }
                case "==": 
                case "=": 
                case "EQ": {
                    this.comparisonOperator = 0;
                    break;
                }
                case ">=": 
                case "=>": 
                case "GE": {
                    this.comparisonOperator = 1;
                    break;
                }
                case ">": 
                case "GT": {
                    this.comparisonOperator = 2;
                    break;
                }
                default: {
                    throw new MessagingException("Bad comparisonOperator: \"" + comparisonOperatorString + "\"");
                }
            }
        } else {
            throw new MessagingException("Missing comparisonOperator");
        }
        if (st.hasMoreTokens()) {
            String headerValueString = st.nextToken().trim();
            try {
                this.headerValue = Double.valueOf(headerValueString);
            }
            catch (NumberFormatException nfe) {
                throw new MessagingException("Bad header comparison value: \"" + headerValueString + "\"", (Exception)nfe);
            }
        } else {
            throw new MessagingException("Missing headerValue threshold");
        }
    }

    public Collection<MailAddress> match(Mail mail) throws MessagingException {
        if (this.headerName == null) {
            throw new IllegalStateException("Null headerName");
        }
        MimeMessage message = mail.getMessage();
        String[] headerArray = message.getHeader(this.headerName);
        if (headerArray != null && headerArray.length > 0) {
            try {
                int comparison = Double.valueOf(headerArray[0].trim()).compareTo(this.headerValue);
                switch (this.comparisonOperator) {
                    case -2: {
                        if (comparison < 0) {
                            return mail.getRecipients();
                        }
                        break;
                    }
                    case -1: {
                        if (comparison <= 0) {
                            return mail.getRecipients();
                        }
                        break;
                    }
                    case 0: {
                        if (comparison == 0) {
                            return mail.getRecipients();
                        }
                        break;
                    }
                    case 1: {
                        if (comparison >= 0) {
                            return mail.getRecipients();
                        }
                        break;
                    }
                    case 2: {
                        if (comparison > 0) {
                            return mail.getRecipients();
                        }
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown comparisonOperator" + this.comparisonOperator);
                    }
                }
            }
            catch (NumberFormatException nfe) {
                throw new MessagingException("Bad header value found in message: \"" + headerArray[0] + "\"", (Exception)nfe);
            }
        }
        return null;
    }
}

