/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal.response.error;

import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import com.datastax.oss.protocol.internal.response.Error;

public class WriteTimeout
extends Error {
    public final int consistencyLevel;
    public final int received;
    public final int blockFor;
    public final String writeType;

    public WriteTimeout(String message, int consistencyLevel, int received, int blockFor, String writeType) {
        super(4352, message);
        this.consistencyLevel = consistencyLevel;
        this.received = received;
        this.blockFor = blockFor;
        this.writeType = writeType;
    }

    public static class SubCodec
    extends Error.SubCodec {
        public SubCodec(int protocolVersion) {
            super(4352, protocolVersion);
        }

        @Override
        public <B> void encode(B dest, Message message, PrimitiveCodec<B> encoder) {
            WriteTimeout writeTimeout = (WriteTimeout)message;
            encoder.writeString(writeTimeout.message, dest);
            encoder.writeUnsignedShort(writeTimeout.consistencyLevel, dest);
            encoder.writeInt(writeTimeout.received, dest);
            encoder.writeInt(writeTimeout.blockFor, dest);
            encoder.writeString(writeTimeout.writeType, dest);
        }

        @Override
        public int encodedSize(Message message) {
            WriteTimeout writeTimeout = (WriteTimeout)message;
            return PrimitiveSizes.sizeOfString(writeTimeout.message) + 2 + 4 + 4 + PrimitiveSizes.sizeOfString(writeTimeout.writeType);
        }

        @Override
        public <B> Message decode(B source, PrimitiveCodec<B> decoder) {
            String message = decoder.readString(source);
            int consistencyLevel = decoder.readUnsignedShort(source);
            int received = decoder.readInt(source);
            int blockFor = decoder.readInt(source);
            String writeType = decoder.readString(source);
            return new WriteTimeout(message, consistencyLevel, received, blockFor, writeType);
        }
    }
}

