/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.indices.SegmentSortMissing;
import org.opensearch.client.opensearch.indices.SegmentSortMode;
import org.opensearch.client.opensearch.indices.SegmentSortOrder;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class IndexSegmentSort
implements JsonpSerializable {
    private final List<String> field;
    private final List<SegmentSortOrder> order;
    private final List<SegmentSortMode> mode;
    private final List<SegmentSortMissing> missing;
    public static final JsonpDeserializer<IndexSegmentSort> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndexSegmentSort::setupIndexSegmentSortDeserializer);

    private IndexSegmentSort(Builder builder) {
        this.field = ApiTypeHelper.unmodifiableRequired(builder.field, (Object)this, "field");
        this.order = ApiTypeHelper.unmodifiableRequired(builder.order, (Object)this, "order");
        this.mode = ApiTypeHelper.unmodifiable(builder.mode);
        this.missing = ApiTypeHelper.unmodifiable(builder.missing);
    }

    public static IndexSegmentSort of(Function<Builder, ObjectBuilder<IndexSegmentSort>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> field() {
        return this.field;
    }

    public final List<SegmentSortOrder> order() {
        return this.order;
    }

    public final List<SegmentSortMode> mode() {
        return this.mode;
    }

    public final List<SegmentSortMissing> missing() {
        return this.missing;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.field)) {
            generator.writeKey("field");
            generator.writeStartArray();
            for (String string : this.field) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.order)) {
            generator.writeKey("order");
            generator.writeStartArray();
            for (SegmentSortOrder segmentSortOrder : this.order) {
                segmentSortOrder.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.mode)) {
            generator.writeKey("mode");
            generator.writeStartArray();
            for (SegmentSortMode segmentSortMode : this.mode) {
                segmentSortMode.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.missing)) {
            generator.writeKey("missing");
            generator.writeStartArray();
            for (SegmentSortMissing segmentSortMissing : this.missing) {
                segmentSortMissing.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupIndexSegmentSortDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::field, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "field");
        op.add(Builder::order, JsonpDeserializer.arrayDeserializer(SegmentSortOrder._DESERIALIZER), "order");
        op.add(Builder::mode, JsonpDeserializer.arrayDeserializer(SegmentSortMode._DESERIALIZER), "mode");
        op.add(Builder::missing, JsonpDeserializer.arrayDeserializer(SegmentSortMissing._DESERIALIZER), "missing");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<IndexSegmentSort> {
        private List<String> field;
        private List<SegmentSortOrder> order;
        @Nullable
        private List<SegmentSortMode> mode;
        @Nullable
        private List<SegmentSortMissing> missing;

        public final Builder field(List<String> list) {
            this.field = Builder._listAddAll(this.field, list);
            return this;
        }

        public final Builder field(String value, String ... values) {
            this.field = Builder._listAdd(this.field, value, values);
            return this;
        }

        public final Builder order(List<SegmentSortOrder> list) {
            this.order = Builder._listAddAll(this.order, list);
            return this;
        }

        public final Builder order(SegmentSortOrder value, SegmentSortOrder ... values) {
            this.order = Builder._listAdd(this.order, value, values);
            return this;
        }

        public final Builder mode(List<SegmentSortMode> list) {
            this.mode = Builder._listAddAll(this.mode, list);
            return this;
        }

        public final Builder mode(SegmentSortMode value, SegmentSortMode ... values) {
            this.mode = Builder._listAdd(this.mode, value, values);
            return this;
        }

        public final Builder missing(List<SegmentSortMissing> list) {
            this.missing = Builder._listAddAll(this.missing, list);
            return this;
        }

        public final Builder missing(SegmentSortMissing value, SegmentSortMissing ... values) {
            this.missing = Builder._listAdd(this.missing, value, values);
            return this;
        }

        @Override
        public IndexSegmentSort build() {
            this._checkSingleUse();
            return new IndexSegmentSort(this);
        }
    }
}

