/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.aes;

import com.github.fge.lambdas.Throwing;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteSource;
import com.google.common.io.FileBackedOutputStream;
import com.google.crypto.tink.subtle.AesGcmHkdfStreaming;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.apache.james.blob.aes.CryptoConfig;
import org.apache.james.blob.aes.PBKDF2StreamingAeadFactory;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStoreDAO;
import org.apache.james.blob.api.BucketName;
import org.apache.james.blob.api.ObjectNotFoundException;
import org.apache.james.blob.api.ObjectStoreIOException;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class AESBlobStoreDAO
implements BlobStoreDAO {
    public static final int FILE_THRESHOLD_100_KB = 102400;
    private final BlobStoreDAO underlying;
    private final AesGcmHkdfStreaming streamingAead;

    public AESBlobStoreDAO(BlobStoreDAO underlying, CryptoConfig cryptoConfig) {
        this.underlying = underlying;
        this.streamingAead = PBKDF2StreamingAeadFactory.newAesGcmHkdfStreaming(cryptoConfig);
    }

    public FileBackedOutputStream encrypt(InputStream input) {
        FileBackedOutputStream fileBackedOutputStream;
        FileBackedOutputStream encryptedContent = new FileBackedOutputStream(102400);
        try {
            OutputStream outputStream = this.streamingAead.newEncryptingStream((OutputStream)encryptedContent, PBKDF2StreamingAeadFactory.EMPTY_ASSOCIATED_DATA);
            input.transferTo(outputStream);
            outputStream.close();
            fileBackedOutputStream = encryptedContent;
        }
        catch (Throwable throwable) {
            try {
                try {
                    encryptedContent.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | GeneralSecurityException e) {
                throw new RuntimeException("Unable to build payload for object storage, failed to encrypt", e);
            }
        }
        encryptedContent.close();
        return fileBackedOutputStream;
    }

    public InputStream decrypt(InputStream ciphertext) throws IOException {
        try {
            return this.streamingAead.newDecryptingStream(ciphertext, PBKDF2StreamingAeadFactory.EMPTY_ASSOCIATED_DATA);
        }
        catch (GeneralSecurityException e) {
            throw new IOException("Incorrect crypto setup", e);
        }
    }

    public InputStream read(BucketName bucketName, BlobId blobId) throws ObjectStoreIOException, ObjectNotFoundException {
        try {
            return this.decrypt(this.underlying.read(bucketName, blobId));
        }
        catch (IOException e) {
            throw new ObjectStoreIOException("Error reading blob " + blobId.asString(), (Throwable)e);
        }
    }

    public Publisher<InputStream> readReactive(BucketName bucketName, BlobId blobId) {
        return Mono.from((Publisher)this.underlying.readReactive(bucketName, blobId)).map((Function)Throwing.function(this::decrypt));
    }

    public Publisher<byte[]> readBytes(BucketName bucketName, BlobId blobId) {
        return Mono.from((Publisher)this.underlying.readBytes(bucketName, blobId)).map(ByteArrayInputStream::new).map((Function)Throwing.function(this::decrypt)).map((Function)Throwing.function(IOUtils::toByteArray));
    }

    public Publisher<Void> save(BucketName bucketName, BlobId blobId, byte[] data) {
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkNotNull((Object)blobId);
        Preconditions.checkNotNull((Object)data);
        return this.save(bucketName, blobId, new ByteArrayInputStream(data));
    }

    public Publisher<Void> save(BucketName bucketName, BlobId blobId, InputStream inputStream) {
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkNotNull((Object)blobId);
        Preconditions.checkNotNull((Object)inputStream);
        return Mono.using(() -> this.encrypt(inputStream), fileBackedOutputStream -> Mono.from((Publisher)this.underlying.save(bucketName, blobId, fileBackedOutputStream.asByteSource())), (Consumer)Throwing.consumer(FileBackedOutputStream::reset)).onErrorMap(e -> new ObjectStoreIOException("Exception occurred while saving bytearray", e));
    }

    public Publisher<Void> save(BucketName bucketName, BlobId blobId, ByteSource content) {
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkNotNull((Object)blobId);
        Preconditions.checkNotNull((Object)content);
        return Mono.using(() -> ((ByteSource)content).openStream(), in -> Mono.from(this.save(bucketName, blobId, (InputStream)in)), (Consumer)Throwing.consumer(InputStream::close));
    }

    public Publisher<Void> delete(BucketName bucketName, BlobId blobId) {
        return this.underlying.delete(bucketName, blobId);
    }

    public Publisher<Void> delete(BucketName bucketName, Collection<BlobId> blobIds) {
        return this.underlying.delete(bucketName, blobIds);
    }

    public Publisher<Void> deleteBucket(BucketName bucketName) {
        return this.underlying.deleteBucket(bucketName);
    }

    public Publisher<BucketName> listBuckets() {
        return this.underlying.listBuckets();
    }

    public Publisher<BlobId> listBlobs(BucketName bucketName) {
        return this.underlying.listBlobs(bucketName);
    }
}

