/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph;

import com.datastax.dse.driver.api.core.graph.GraphExecutionInfo;
import com.datastax.dse.driver.api.core.graph.GraphStatement;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.cql.QueryTrace;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.internal.core.util.concurrent.CompletableFutures;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletionStage;

public class GraphExecutionInfoConverter {
    public static ExecutionInfo convert(final GraphExecutionInfo graphExecutionInfo) {
        return new ExecutionInfo(){

            @Override
            @NonNull
            public Request getRequest() {
                return graphExecutionInfo.getStatement();
            }

            @Override
            @NonNull
            public Statement<?> getStatement() {
                throw new ClassCastException("GraphStatement cannot be cast to Statement");
            }

            @Override
            @Nullable
            public Node getCoordinator() {
                return graphExecutionInfo.getCoordinator();
            }

            @Override
            public int getSpeculativeExecutionCount() {
                return graphExecutionInfo.getSpeculativeExecutionCount();
            }

            @Override
            public int getSuccessfulExecutionIndex() {
                return graphExecutionInfo.getSuccessfulExecutionIndex();
            }

            @Override
            @NonNull
            public List<Map.Entry<Node, Throwable>> getErrors() {
                return graphExecutionInfo.getErrors();
            }

            @Override
            @Nullable
            public ByteBuffer getPagingState() {
                return null;
            }

            @Override
            @NonNull
            public List<String> getWarnings() {
                return graphExecutionInfo.getWarnings();
            }

            @Override
            @NonNull
            public Map<String, ByteBuffer> getIncomingPayload() {
                return graphExecutionInfo.getIncomingPayload();
            }

            @Override
            public boolean isSchemaInAgreement() {
                return true;
            }

            @Override
            @Nullable
            public UUID getTracingId() {
                return null;
            }

            @Override
            @NonNull
            public CompletionStage<QueryTrace> getQueryTraceAsync() {
                return CompletableFutures.failedFuture(new IllegalStateException("Tracing was disabled for this request"));
            }

            @Override
            public int getResponseSizeInBytes() {
                return -1;
            }

            @Override
            public int getCompressedResponseSizeInBytes() {
                return -1;
            }
        };
    }

    public static GraphExecutionInfo convert(final ExecutionInfo executionInfo) {
        return new GraphExecutionInfo(){

            @Override
            public GraphStatement<?> getStatement() {
                return (GraphStatement)executionInfo.getRequest();
            }

            @Override
            public Node getCoordinator() {
                return executionInfo.getCoordinator();
            }

            @Override
            public int getSpeculativeExecutionCount() {
                return executionInfo.getSpeculativeExecutionCount();
            }

            @Override
            public int getSuccessfulExecutionIndex() {
                return executionInfo.getSuccessfulExecutionIndex();
            }

            @Override
            public List<Map.Entry<Node, Throwable>> getErrors() {
                return executionInfo.getErrors();
            }

            @Override
            public List<String> getWarnings() {
                return executionInfo.getWarnings();
            }

            @Override
            public Map<String, ByteBuffer> getIncomingPayload() {
                return executionInfo.getIncomingPayload();
            }
        };
    }
}

