/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.listener.AccessLogRequestHandler;
import com.unboundid.ldap.listener.InMemoryDirectoryServerConfig;
import com.unboundid.ldap.listener.InMemoryDirectoryServerPassword;
import com.unboundid.ldap.listener.InMemoryDirectoryServerSnapshot;
import com.unboundid.ldap.listener.InMemoryListenerConfig;
import com.unboundid.ldap.listener.InMemoryPasswordEncoder;
import com.unboundid.ldap.listener.InMemoryRequestHandler;
import com.unboundid.ldap.listener.JSONAccessLogRequestHandler;
import com.unboundid.ldap.listener.LDAPDebuggerRequestHandler;
import com.unboundid.ldap.listener.LDAPListener;
import com.unboundid.ldap.listener.LDAPListenerConfig;
import com.unboundid.ldap.listener.LDAPListenerRequestHandler;
import com.unboundid.ldap.listener.ListenerMessages;
import com.unboundid.ldap.listener.ReadOnlyInMemoryDirectoryServerConfig;
import com.unboundid.ldap.listener.StartTLSRequestHandler;
import com.unboundid.ldap.listener.ToCodeRequestHandler;
import com.unboundid.ldap.listener.interceptor.InMemoryOperationInterceptorRequestHandler;
import com.unboundid.ldap.protocol.BindRequestProtocolOp;
import com.unboundid.ldap.protocol.BindResponseProtocolOp;
import com.unboundid.ldap.protocol.CompareRequestProtocolOp;
import com.unboundid.ldap.protocol.CompareResponseProtocolOp;
import com.unboundid.ldap.protocol.ExtendedRequestProtocolOp;
import com.unboundid.ldap.protocol.ExtendedResponseProtocolOp;
import com.unboundid.ldap.protocol.LDAPMessage;
import com.unboundid.ldap.protocol.SearchRequestProtocolOp;
import com.unboundid.ldap.protocol.SearchResultDoneProtocolOp;
import com.unboundid.ldap.sdk.AddRequest;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.CompareRequest;
import com.unboundid.ldap.sdk.CompareResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.DeleteRequest;
import com.unboundid.ldap.sdk.DereferencePolicy;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.FullLDAPInterface;
import com.unboundid.ldap.sdk.InternalSDKHelper;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.LDAPSearchException;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModifyDNRequest;
import com.unboundid.ldap.sdk.ModifyRequest;
import com.unboundid.ldap.sdk.PLAINBindRequest;
import com.unboundid.ldap.sdk.ReadOnlyAddRequest;
import com.unboundid.ldap.sdk.ReadOnlyCompareRequest;
import com.unboundid.ldap.sdk.ReadOnlyDeleteRequest;
import com.unboundid.ldap.sdk.ReadOnlyModifyDNRequest;
import com.unboundid.ldap.sdk.ReadOnlyModifyRequest;
import com.unboundid.ldap.sdk.ReadOnlySearchRequest;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.RootDSE;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultListener;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldif.LDIFException;
import com.unboundid.ldif.LDIFReader;
import com.unboundid.ldif.LDIFWriter;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Debug;
import com.unboundid.util.Mutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.net.SocketFactory;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class InMemoryDirectoryServer
implements FullLDAPInterface {
    @NotNull
    private final InMemoryRequestHandler inMemoryHandler;
    @NotNull
    private final Map<String, LDAPListener> listeners;
    @NotNull
    private final Map<String, LDAPListenerConfig> ldapListenerConfigs;
    @NotNull
    private final Map<String, SocketFactory> clientSocketFactories;
    @NotNull
    private final ReadOnlyInMemoryDirectoryServerConfig config;

    public InMemoryDirectoryServer(String ... baseDNs) throws LDAPException {
        this(new InMemoryDirectoryServerConfig(baseDNs));
    }

    public InMemoryDirectoryServer(@NotNull InMemoryDirectoryServerConfig cfg) throws LDAPException {
        Validator.ensureNotNull(cfg);
        this.config = new ReadOnlyInMemoryDirectoryServerConfig(cfg);
        LDAPListenerRequestHandler requestHandler = this.inMemoryHandler = new InMemoryRequestHandler(this.config);
        if (this.config.getAccessLogHandler() != null) {
            requestHandler = new AccessLogRequestHandler(this.config.getAccessLogHandler(), requestHandler);
        }
        if (this.config.getJSONAccessLogHandler() != null) {
            requestHandler = new JSONAccessLogRequestHandler(this.config.getJSONAccessLogHandler(), requestHandler);
        }
        if (this.config.getLDAPDebugLogHandler() != null) {
            requestHandler = new LDAPDebuggerRequestHandler(this.config.getLDAPDebugLogHandler(), requestHandler);
        }
        if (this.config.getCodeLogPath() != null) {
            try {
                requestHandler = new ToCodeRequestHandler(this.config.getCodeLogPath(), this.config.includeRequestProcessingInCodeLog(), requestHandler);
            }
            catch (IOException ioe) {
                Debug.debugException(ioe);
                throw new LDAPException(ResultCode.LOCAL_ERROR, ListenerMessages.ERR_MEM_DS_CANNOT_OPEN_CODE_LOG.get(this.config.getCodeLogPath(), StaticUtils.getExceptionMessage(ioe)), ioe);
            }
        }
        if (!this.config.getOperationInterceptors().isEmpty()) {
            requestHandler = new InMemoryOperationInterceptorRequestHandler(this.config.getOperationInterceptors(), requestHandler);
        }
        List<InMemoryListenerConfig> listenerConfigs = this.config.getListenerConfigs();
        this.listeners = new LinkedHashMap<String, LDAPListener>(StaticUtils.computeMapCapacity(listenerConfigs.size()));
        this.ldapListenerConfigs = new LinkedHashMap<String, LDAPListenerConfig>(StaticUtils.computeMapCapacity(listenerConfigs.size()));
        this.clientSocketFactories = new LinkedHashMap<String, SocketFactory>(StaticUtils.computeMapCapacity(listenerConfigs.size()));
        for (InMemoryListenerConfig c : listenerConfigs) {
            String name = StaticUtils.toLowerCase(c.getListenerName());
            LDAPListenerRequestHandler listenerRequestHandler = c.getStartTLSSocketFactory() == null ? requestHandler : new StartTLSRequestHandler(c.getStartTLSSocketFactory(), requestHandler, c.requestClientCertificate(), c.requireClientCertificate());
            LDAPListenerConfig listenerCfg = new LDAPListenerConfig(c.getListenPort(), listenerRequestHandler);
            listenerCfg.setMaxConnections(this.config.getMaxConnections());
            listenerCfg.setMaxMessageSizeBytes(this.config.getMaxMessageSizeBytes());
            listenerCfg.setExceptionHandler(this.config.getListenerExceptionHandler());
            listenerCfg.setListenAddress(c.getListenAddress());
            listenerCfg.setServerSocketFactory(c.getServerSocketFactory());
            listenerCfg.setRequestClientCertificate(c.requestClientCertificate());
            listenerCfg.setRequireClientCertificate(c.requireClientCertificate());
            this.ldapListenerConfigs.put(name, listenerCfg);
            if (c.getClientSocketFactory() == null) continue;
            this.clientSocketFactories.put(name, c.getClientSocketFactory());
        }
    }

    public synchronized void startListening() throws LDAPException {
        ArrayList<String> messages = new ArrayList<String>(this.listeners.size());
        for (Map.Entry<String, LDAPListenerConfig> cfgEntry : this.ldapListenerConfigs.entrySet()) {
            String name = cfgEntry.getKey();
            if (this.listeners.containsKey(name)) continue;
            LDAPListenerConfig listenerConfig = cfgEntry.getValue();
            LDAPListener listener = new LDAPListener(listenerConfig);
            try {
                listener.startListening();
                listenerConfig.setListenPort(listener.getListenPort());
                this.listeners.put(name, listener);
            }
            catch (Exception e) {
                Debug.debugException(e);
                messages.add(ListenerMessages.ERR_MEM_DS_START_FAILED.get(name, StaticUtils.getExceptionMessage(e)));
            }
        }
        if (!messages.isEmpty()) {
            throw new LDAPException(ResultCode.LOCAL_ERROR, StaticUtils.concatenateStrings(messages));
        }
    }

    public synchronized void startListening(@NotNull String listenerName) throws LDAPException {
        String name = StaticUtils.toLowerCase(listenerName);
        if (this.listeners.containsKey(name)) {
            return;
        }
        LDAPListenerConfig listenerConfig = this.ldapListenerConfigs.get(name);
        if (listenerConfig == null) {
            throw new LDAPException(ResultCode.PARAM_ERROR, ListenerMessages.ERR_MEM_DS_NO_SUCH_LISTENER.get(listenerName));
        }
        LDAPListener listener = new LDAPListener(listenerConfig);
        try {
            listener.startListening();
            listenerConfig.setListenPort(listener.getListenPort());
            this.listeners.put(name, listener);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, ListenerMessages.ERR_MEM_DS_START_FAILED.get(name, StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @Override
    public void close() {
        this.shutDown(true);
    }

    public synchronized void closeAllConnections(boolean sendNoticeOfDisconnection) {
        for (LDAPListener l : this.listeners.values()) {
            try {
                l.closeAllConnections(sendNoticeOfDisconnection);
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
    }

    public synchronized void shutDown(boolean closeExistingConnections) {
        for (LDAPListener l : this.listeners.values()) {
            try {
                l.shutDown(closeExistingConnections);
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        this.listeners.clear();
    }

    public synchronized void shutDown(@NotNull String listenerName, boolean closeExistingConnections) {
        String name = StaticUtils.toLowerCase(listenerName);
        LDAPListener listener = this.listeners.remove(name);
        if (listener != null) {
            listener.shutDown(closeExistingConnections);
        }
    }

    public synchronized void restartServer() throws LDAPException {
        block2: {
            this.shutDown(true);
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                Debug.debugException(e);
                if (!(e instanceof InterruptedException)) break block2;
                Thread.currentThread().interrupt();
            }
        }
        this.startListening();
    }

    public synchronized void restartListener(@NotNull String listenerName) throws LDAPException {
        block2: {
            this.shutDown(listenerName, true);
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                Debug.debugException(e);
                if (!(e instanceof InterruptedException)) break block2;
                Thread.currentThread().interrupt();
            }
        }
        this.startListening(listenerName);
    }

    @NotNull
    public ReadOnlyInMemoryDirectoryServerConfig getConfig() {
        return this.config;
    }

    @NotNull
    InMemoryRequestHandler getInMemoryRequestHandler() {
        return this.inMemoryHandler;
    }

    @NotNull
    public InMemoryDirectoryServerSnapshot createSnapshot() {
        return this.inMemoryHandler.createSnapshot();
    }

    public void restoreSnapshot(@NotNull InMemoryDirectoryServerSnapshot snapshot) {
        this.inMemoryHandler.restoreSnapshot(snapshot);
    }

    @NotNull
    public List<DN> getBaseDNs() {
        return this.inMemoryHandler.getBaseDNs();
    }

    @NotNull
    public LDAPConnection getConnection() throws LDAPException {
        return this.getConnection(null, null);
    }

    @NotNull
    public LDAPConnection getConnection(@Nullable LDAPConnectionOptions options) throws LDAPException {
        return this.getConnection(null, options);
    }

    @NotNull
    public LDAPConnection getConnection(@Nullable String listenerName) throws LDAPException {
        return this.getConnection(listenerName, null);
    }

    @NotNull
    public synchronized LDAPConnection getConnection(@Nullable String listenerName, @Nullable LDAPConnectionOptions options) throws LDAPException {
        String hostAddress;
        SocketFactory clientSocketFactory;
        LDAPListenerConfig listenerConfig;
        String name;
        if (listenerName == null) {
            name = this.getFirstListenerName();
            if (name == null) {
                throw new LDAPException(ResultCode.CONNECT_ERROR, ListenerMessages.ERR_MEM_DS_GET_CONNECTION_NO_LISTENERS.get());
            }
            listenerConfig = this.ldapListenerConfigs.get(name);
            clientSocketFactory = this.clientSocketFactories.get(name);
        } else {
            name = StaticUtils.toLowerCase(listenerName);
            if (!this.listeners.containsKey(name)) {
                throw new LDAPException(ResultCode.CONNECT_ERROR, ListenerMessages.ERR_MEM_DS_GET_CONNECTION_LISTENER_NOT_RUNNING.get(listenerName));
            }
            listenerConfig = this.ldapListenerConfigs.get(name);
            clientSocketFactory = this.clientSocketFactories.get(name);
        }
        if (StaticUtils.isWithinUnitTest()) {
            hostAddress = "127.0.0.1";
        } else {
            InetAddress listenAddress = listenerConfig.getListenAddress();
            if (listenAddress == null || listenAddress.isAnyLocalAddress()) {
                try {
                    hostAddress = LDAPConnectionOptions.DEFAULT_NAME_RESOLVER.getLocalHost().getHostAddress();
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    hostAddress = "127.0.0.1";
                }
            } else {
                hostAddress = listenAddress.getHostAddress();
            }
        }
        return new LDAPConnection(clientSocketFactory, options, hostAddress, listenerConfig.getListenPort());
    }

    @NotNull
    public LDAPConnectionPool getConnectionPool(int maxConnections) throws LDAPException {
        return this.getConnectionPool(null, null, 1, maxConnections);
    }

    @NotNull
    public LDAPConnectionPool getConnectionPool(@Nullable String listenerName, @Nullable LDAPConnectionOptions options, int initialConnections, int maxConnections) throws LDAPException {
        LDAPConnection conn = this.getConnection(listenerName, options);
        return new LDAPConnectionPool(conn, initialConnections, maxConnections);
    }

    @Nullable
    public InetAddress getListenAddress() {
        return this.getListenAddress(null);
    }

    @Nullable
    public synchronized InetAddress getListenAddress(@Nullable String listenerName) {
        String name;
        LDAPListenerConfig listenerCfg;
        if (StaticUtils.isWithinUnitTest()) {
            try {
                return InetAddress.getByName("127.0.0.1");
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        if ((listenerCfg = this.ldapListenerConfigs.get(name = listenerName == null ? this.getFirstListenerName() : StaticUtils.toLowerCase(listenerName))) == null) {
            return null;
        }
        return listenerCfg.getListenAddress();
    }

    public int getListenPort() {
        return this.getListenPort(null);
    }

    public synchronized int getListenPort(@Nullable String listenerName) {
        String name = listenerName == null ? this.getFirstListenerName() : StaticUtils.toLowerCase(listenerName);
        LDAPListener listener = this.listeners.get(name);
        if (listener == null) {
            return -1;
        }
        return listener.getListenPort();
    }

    @Nullable
    public SocketFactory getClientSocketFactory() {
        return this.getClientSocketFactory(null);
    }

    @Nullable
    public synchronized SocketFactory getClientSocketFactory(@Nullable String listenerName) {
        String name = listenerName == null ? this.getFirstListenerName() : StaticUtils.toLowerCase(listenerName);
        return this.clientSocketFactories.get(name);
    }

    @Nullable
    private String getFirstListenerName() {
        for (Map.Entry<String, LDAPListenerConfig> e : this.ldapListenerConfigs.entrySet()) {
            String name = e.getKey();
            if (!this.listeners.containsKey(name)) continue;
            return name;
        }
        return null;
    }

    public long getProcessingDelayMillis() {
        return this.inMemoryHandler.getProcessingDelayMillis();
    }

    public void setProcessingDelayMillis(long processingDelayMillis) {
        this.inMemoryHandler.setProcessingDelayMillis(processingDelayMillis);
    }

    public int countEntries() {
        return this.countEntries(false);
    }

    public int countEntries(boolean includeChangeLog) {
        return this.inMemoryHandler.countEntries(includeChangeLog);
    }

    public int countEntriesBelow(@NotNull String baseDN) throws LDAPException {
        return this.inMemoryHandler.countEntriesBelow(baseDN);
    }

    public void clear() {
        this.inMemoryHandler.clear();
    }

    public int importFromLDIF(boolean clear, @NotNull String path) throws LDAPException {
        return this.importFromLDIF(clear, new File(path));
    }

    public int importFromLDIF(boolean clear, @NotNull File ldifFile) throws LDAPException {
        LDIFReader reader;
        try {
            reader = new LDIFReader(ldifFile);
            Schema schema = this.getSchema();
            if (schema != null) {
                reader.setSchema(schema);
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, ListenerMessages.ERR_MEM_DS_INIT_FROM_LDIF_CANNOT_CREATE_READER.get(ldifFile.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
        }
        return this.importFromLDIF(clear, reader);
    }

    public int importFromLDIF(boolean clear, @NotNull LDIFReader reader) throws LDAPException {
        return this.inMemoryHandler.importFromLDIF(clear, reader);
    }

    public int exportToLDIF(@NotNull String path, boolean excludeGeneratedAttrs, boolean excludeChangeLog) throws LDAPException {
        LDIFWriter ldifWriter;
        try {
            ldifWriter = new LDIFWriter(path);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, ListenerMessages.ERR_MEM_DS_EXPORT_TO_LDIF_CANNOT_CREATE_WRITER.get(path, StaticUtils.getExceptionMessage(e)), e);
        }
        return this.exportToLDIF(ldifWriter, excludeGeneratedAttrs, excludeChangeLog, true);
    }

    public int exportToLDIF(@NotNull LDIFWriter ldifWriter, boolean excludeGeneratedAttrs, boolean excludeChangeLog, boolean closeWriter) throws LDAPException {
        return this.inMemoryHandler.exportToLDIF(ldifWriter, excludeGeneratedAttrs, excludeChangeLog, closeWriter);
    }

    public int applyChangesFromLDIF(@NotNull String path) throws LDAPException {
        return this.applyChangesFromLDIF(new File(path));
    }

    public int applyChangesFromLDIF(@NotNull File ldifFile) throws LDAPException {
        LDIFReader reader;
        try {
            reader = new LDIFReader(ldifFile);
            Schema schema = this.getSchema();
            if (schema != null) {
                reader.setSchema(schema);
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, ListenerMessages.ERR_MEM_DS_APPLY_CHANGES_FROM_LDIF_CANNOT_CREATE_READER.get(ldifFile.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
        }
        return this.applyChangesFromLDIF(reader);
    }

    public int applyChangesFromLDIF(@NotNull LDIFReader reader) throws LDAPException {
        return this.inMemoryHandler.applyChangesFromLDIF(reader);
    }

    @Override
    @Nullable
    public RootDSE getRootDSE() throws LDAPException {
        return new RootDSE(this.inMemoryHandler.getEntry(""));
    }

    @Override
    @Nullable
    public Schema getSchema() throws LDAPException {
        return this.inMemoryHandler.getSchema();
    }

    @Override
    @Nullable
    public Schema getSchema(@Nullable String entryDN) throws LDAPException {
        return this.inMemoryHandler.getSchema();
    }

    @Override
    @Nullable
    public SearchResultEntry getEntry(@NotNull String dn) throws LDAPException {
        return this.searchForEntry(dn, SearchScope.BASE, Filter.createPresenceFilter("objectClass"), new String[0]);
    }

    @Override
    @Nullable
    public SearchResultEntry getEntry(@NotNull String dn, String ... attributes) throws LDAPException {
        return this.searchForEntry(dn, SearchScope.BASE, Filter.createPresenceFilter("objectClass"), attributes);
    }

    @Override
    @NotNull
    public LDAPResult add(@NotNull String dn, Attribute ... attributes) throws LDAPException {
        return this.add(new AddRequest(dn, attributes));
    }

    @Override
    @NotNull
    public LDAPResult add(@NotNull String dn, @NotNull Collection<Attribute> attributes) throws LDAPException {
        return this.add(new AddRequest(dn, attributes));
    }

    @Override
    @NotNull
    public LDAPResult add(@NotNull Entry entry) throws LDAPException {
        return this.add(new AddRequest(entry));
    }

    @Override
    @NotNull
    public LDAPResult add(String ... ldifLines) throws LDIFException, LDAPException {
        return this.add(new AddRequest(ldifLines));
    }

    @Override
    @NotNull
    public LDAPResult add(@NotNull AddRequest addRequest) throws LDAPException {
        return this.inMemoryHandler.add(addRequest);
    }

    @Override
    @NotNull
    public LDAPResult add(@NotNull ReadOnlyAddRequest addRequest) throws LDAPException {
        return this.add(addRequest.duplicate());
    }

    public void addEntries(Entry ... entries) throws LDAPException {
        this.addEntries(Arrays.asList(entries));
    }

    public void addEntries(@NotNull List<? extends Entry> entries) throws LDAPException {
        this.inMemoryHandler.addEntries(entries);
    }

    public void addEntries(String ... ldifEntryLines) throws LDAPException {
        ByteStringBuffer buffer = new ByteStringBuffer();
        for (String line : ldifEntryLines) {
            buffer.append(line);
            buffer.append(StaticUtils.EOL_BYTES);
        }
        ArrayList<Entry> entryList = new ArrayList<Entry>(10);
        LDIFReader reader = new LDIFReader(buffer.asInputStream());
        Schema schema = this.getSchema();
        if (schema != null) {
            reader.setSchema(schema);
        }
        try {
            Entry entry;
            while ((entry = reader.readEntry()) != null) {
                entryList.add(entry);
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.PARAM_ERROR, ListenerMessages.ERR_MEM_DS_ADD_ENTRIES_LDIF_PARSE_EXCEPTION.get(StaticUtils.getExceptionMessage(e)), e);
        }
        this.addEntries(entryList);
    }

    @Override
    @NotNull
    public BindResult bind(@Nullable String bindDN, @Nullable String password) throws LDAPException {
        return this.bind(new SimpleBindRequest(bindDN, password));
    }

    @Override
    @NotNull
    public BindResult bind(@NotNull BindRequest bindRequest) throws LDAPException {
        BindRequestProtocolOp bindOp;
        BindRequest r;
        ArrayList<Control> requestControlList = new ArrayList<Control>(bindRequest.getControlList());
        requestControlList.add(new Control("1.3.6.1.4.1.30221.2.5.18", false));
        if (bindRequest instanceof SimpleBindRequest) {
            r = (SimpleBindRequest)bindRequest;
            bindOp = new BindRequestProtocolOp(((SimpleBindRequest)r).getBindDN(), ((SimpleBindRequest)r).getPassword().getValue());
        } else if (bindRequest instanceof PLAINBindRequest) {
            r = (PLAINBindRequest)bindRequest;
            byte[] authZIDBytes = StaticUtils.getBytes(((PLAINBindRequest)r).getAuthorizationID());
            byte[] authNIDBytes = StaticUtils.getBytes(((PLAINBindRequest)r).getAuthenticationID());
            byte[] passwordBytes = ((PLAINBindRequest)r).getPasswordBytes();
            byte[] credBytes = new byte[2 + authZIDBytes.length + authNIDBytes.length + passwordBytes.length];
            System.arraycopy(authZIDBytes, 0, credBytes, 0, authZIDBytes.length);
            int pos = authZIDBytes.length + 1;
            System.arraycopy(authNIDBytes, 0, credBytes, pos, authNIDBytes.length);
            System.arraycopy(passwordBytes, 0, credBytes, pos += authNIDBytes.length + 1, passwordBytes.length);
            bindOp = new BindRequestProtocolOp(null, "PLAIN", new ASN1OctetString(credBytes));
        } else {
            throw new LDAPException(ResultCode.AUTH_METHOD_NOT_SUPPORTED, ListenerMessages.ERR_MEM_DS_UNSUPPORTED_BIND_TYPE.get());
        }
        LDAPMessage responseMessage = this.inMemoryHandler.processBindRequest(1, bindOp, requestControlList);
        BindResponseProtocolOp bindResponse = responseMessage.getBindResponseProtocolOp();
        BindResult bindResult = new BindResult(new LDAPResult(responseMessage.getMessageID(), ResultCode.valueOf(bindResponse.getResultCode()), bindResponse.getDiagnosticMessage(), bindResponse.getMatchedDN(), bindResponse.getReferralURLs(), responseMessage.getControls()));
        switch (bindResponse.getResultCode()) {
            case 0: {
                return bindResult;
            }
        }
        throw new LDAPException(bindResult);
    }

    @Override
    @NotNull
    public CompareResult compare(@NotNull String dn, @NotNull String attributeName, @NotNull String assertionValue) throws LDAPException {
        return this.compare(new CompareRequest(dn, attributeName, assertionValue));
    }

    @Override
    @NotNull
    public CompareResult compare(@NotNull CompareRequest compareRequest) throws LDAPException {
        ArrayList<Control> requestControlList = new ArrayList<Control>(compareRequest.getControlList());
        requestControlList.add(new Control("1.3.6.1.4.1.30221.2.5.18", false));
        LDAPMessage responseMessage = this.inMemoryHandler.processCompareRequest(1, new CompareRequestProtocolOp(compareRequest.getDN(), compareRequest.getAttributeName(), compareRequest.getRawAssertionValue()), requestControlList);
        CompareResponseProtocolOp compareResponse = responseMessage.getCompareResponseProtocolOp();
        LDAPResult compareResult = new LDAPResult(responseMessage.getMessageID(), ResultCode.valueOf(compareResponse.getResultCode()), compareResponse.getDiagnosticMessage(), compareResponse.getMatchedDN(), compareResponse.getReferralURLs(), responseMessage.getControls());
        switch (compareResponse.getResultCode()) {
            case 5: 
            case 6: {
                return new CompareResult(compareResult);
            }
        }
        throw new LDAPException(compareResult);
    }

    @Override
    @NotNull
    public CompareResult compare(@NotNull ReadOnlyCompareRequest compareRequest) throws LDAPException {
        return this.compare(compareRequest.duplicate());
    }

    @Override
    @NotNull
    public LDAPResult delete(@NotNull String dn) throws LDAPException {
        return this.delete(new DeleteRequest(dn));
    }

    @Override
    @NotNull
    public LDAPResult delete(@NotNull DeleteRequest deleteRequest) throws LDAPException {
        return this.inMemoryHandler.delete(deleteRequest);
    }

    @Override
    @NotNull
    public LDAPResult delete(@NotNull ReadOnlyDeleteRequest deleteRequest) throws LDAPException {
        return this.delete(deleteRequest.duplicate());
    }

    public int deleteSubtree(@NotNull String baseDN) throws LDAPException {
        return this.inMemoryHandler.deleteSubtree(baseDN);
    }

    @Override
    @NotNull
    public ExtendedResult processExtendedOperation(@NotNull String requestOID) throws LDAPException {
        Validator.ensureNotNull(requestOID);
        return this.processExtendedOperation(new ExtendedRequest(requestOID));
    }

    @Override
    @NotNull
    public ExtendedResult processExtendedOperation(@NotNull String requestOID, @Nullable ASN1OctetString requestValue) throws LDAPException {
        Validator.ensureNotNull(requestOID);
        return this.processExtendedOperation(new ExtendedRequest(requestOID, requestValue));
    }

    @Override
    @NotNull
    public ExtendedResult processExtendedOperation(@NotNull ExtendedRequest extendedRequest) throws LDAPException {
        Control[] responseControls;
        String[] referralURLs;
        Validator.ensureNotNull(extendedRequest);
        ArrayList<Control> requestControlList = new ArrayList<Control>(extendedRequest.getControlList());
        requestControlList.add(new Control("1.3.6.1.4.1.30221.2.5.18", false));
        LDAPMessage responseMessage = this.inMemoryHandler.processExtendedRequest(1, new ExtendedRequestProtocolOp(extendedRequest.getOID(), extendedRequest.getValue()), requestControlList);
        ExtendedResponseProtocolOp extendedResponse = responseMessage.getExtendedResponseProtocolOp();
        ResultCode rc = ResultCode.valueOf(extendedResponse.getResultCode());
        List<String> referralURLList = extendedResponse.getReferralURLs();
        if (referralURLList == null || referralURLList.isEmpty()) {
            referralURLs = StaticUtils.NO_STRINGS;
        } else {
            referralURLs = new String[referralURLList.size()];
            referralURLList.toArray(referralURLs);
        }
        List<Control> controlList = responseMessage.getControls();
        if (controlList == null || controlList.isEmpty()) {
            responseControls = StaticUtils.NO_CONTROLS;
        } else {
            responseControls = new Control[controlList.size()];
            controlList.toArray(responseControls);
        }
        ExtendedResult extendedResult = new ExtendedResult(responseMessage.getMessageID(), rc, extendedResponse.getDiagnosticMessage(), extendedResponse.getMatchedDN(), referralURLs, extendedResponse.getResponseOID(), extendedResponse.getResponseValue(), responseControls);
        if (extendedResult.getOID() == null && extendedResult.getValue() == null) {
            switch (rc.intValue()) {
                case 1: 
                case 2: 
                case 51: 
                case 52: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 90: 
                case 91: {
                    throw new LDAPException(extendedResult);
                }
            }
        }
        return extendedResult;
    }

    @Override
    @NotNull
    public LDAPResult modify(@NotNull String dn, @NotNull Modification mod) throws LDAPException {
        return this.modify(new ModifyRequest(dn, mod));
    }

    @Override
    @NotNull
    public LDAPResult modify(@NotNull String dn, Modification ... mods) throws LDAPException {
        return this.modify(new ModifyRequest(dn, mods));
    }

    @Override
    @NotNull
    public LDAPResult modify(@NotNull String dn, @NotNull List<Modification> mods) throws LDAPException {
        return this.modify(new ModifyRequest(dn, mods));
    }

    @Override
    @NotNull
    public LDAPResult modify(String ... ldifModificationLines) throws LDIFException, LDAPException {
        return this.modify(new ModifyRequest(ldifModificationLines));
    }

    @Override
    @NotNull
    public LDAPResult modify(@NotNull ModifyRequest modifyRequest) throws LDAPException {
        return this.inMemoryHandler.modify(modifyRequest);
    }

    @Override
    @NotNull
    public LDAPResult modify(@NotNull ReadOnlyModifyRequest modifyRequest) throws LDAPException {
        return this.modify(modifyRequest.duplicate());
    }

    @Override
    @NotNull
    public LDAPResult modifyDN(@NotNull String dn, @NotNull String newRDN, boolean deleteOldRDN) throws LDAPException {
        return this.modifyDN(new ModifyDNRequest(dn, newRDN, deleteOldRDN));
    }

    @Override
    @NotNull
    public LDAPResult modifyDN(@NotNull String dn, @NotNull String newRDN, boolean deleteOldRDN, @Nullable String newSuperiorDN) throws LDAPException {
        return this.modifyDN(new ModifyDNRequest(dn, newRDN, deleteOldRDN, newSuperiorDN));
    }

    @Override
    @NotNull
    public LDAPResult modifyDN(@NotNull ModifyDNRequest modifyDNRequest) throws LDAPException {
        return this.inMemoryHandler.modifyDN(modifyDNRequest);
    }

    @Override
    @NotNull
    public LDAPResult modifyDN(@NotNull ReadOnlyModifyDNRequest modifyDNRequest) throws LDAPException {
        return this.modifyDN(modifyDNRequest.duplicate());
    }

    @Override
    @NotNull
    public SearchResult search(@NotNull String baseDN, @NotNull SearchScope scope, @NotNull String filter, String ... attributes) throws LDAPSearchException {
        return this.search(new SearchRequest(baseDN, scope, InMemoryDirectoryServer.parseFilter(filter), attributes));
    }

    @Override
    @NotNull
    public SearchResult search(@NotNull String baseDN, @NotNull SearchScope scope, @NotNull Filter filter, String ... attributes) throws LDAPSearchException {
        return this.search(new SearchRequest(baseDN, scope, filter, attributes));
    }

    @Override
    @NotNull
    public SearchResult search(@Nullable SearchResultListener searchResultListener, @NotNull String baseDN, @NotNull SearchScope scope, @NotNull String filter, String ... attributes) throws LDAPSearchException {
        return this.search(new SearchRequest(searchResultListener, baseDN, scope, InMemoryDirectoryServer.parseFilter(filter), attributes));
    }

    @Override
    @NotNull
    public SearchResult search(@Nullable SearchResultListener searchResultListener, @NotNull String baseDN, @NotNull SearchScope scope, @NotNull Filter filter, String ... attributes) throws LDAPSearchException {
        return this.search(new SearchRequest(searchResultListener, baseDN, scope, filter, attributes));
    }

    @Override
    @NotNull
    public SearchResult search(@NotNull String baseDN, @NotNull SearchScope scope, @NotNull DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, @NotNull String filter, String ... attributes) throws LDAPSearchException {
        return this.search(new SearchRequest(baseDN, scope, derefPolicy, sizeLimit, timeLimit, typesOnly, InMemoryDirectoryServer.parseFilter(filter), attributes));
    }

    @Override
    @NotNull
    public SearchResult search(@NotNull String baseDN, @NotNull SearchScope scope, @NotNull DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, @NotNull Filter filter, String ... attributes) throws LDAPSearchException {
        return this.search(new SearchRequest(baseDN, scope, derefPolicy, sizeLimit, timeLimit, typesOnly, filter, attributes));
    }

    @Override
    @NotNull
    public SearchResult search(@Nullable SearchResultListener searchResultListener, @NotNull String baseDN, @NotNull SearchScope scope, @NotNull DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, @NotNull String filter, String ... attributes) throws LDAPSearchException {
        return this.search(new SearchRequest(searchResultListener, baseDN, scope, derefPolicy, sizeLimit, timeLimit, typesOnly, InMemoryDirectoryServer.parseFilter(filter), attributes));
    }

    @Override
    @NotNull
    public SearchResult search(@Nullable SearchResultListener searchResultListener, @NotNull String baseDN, @NotNull SearchScope scope, @NotNull DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, @NotNull Filter filter, String ... attributes) throws LDAPSearchException {
        return this.search(new SearchRequest(searchResultListener, baseDN, scope, derefPolicy, sizeLimit, timeLimit, typesOnly, filter, attributes));
    }

    @Override
    @NotNull
    public SearchResult search(@NotNull SearchRequest searchRequest) throws LDAPSearchException {
        Control[] responseControls;
        String[] referralURLs;
        List<SearchResultReference> returnReferenceList;
        List<SearchResultEntry> returnEntryList;
        ArrayList<Control> requestControlList = new ArrayList<Control>(searchRequest.getControlList());
        requestControlList.add(new Control("1.3.6.1.4.1.30221.2.5.18", false));
        ArrayList<SearchResultEntry> entryList = new ArrayList<SearchResultEntry>(10);
        ArrayList<SearchResultReference> referenceList = new ArrayList<SearchResultReference>(10);
        LDAPMessage responseMessage = this.inMemoryHandler.processSearchRequest(1, new SearchRequestProtocolOp(searchRequest.getBaseDN(), searchRequest.getScope(), searchRequest.getDereferencePolicy(), searchRequest.getSizeLimit(), searchRequest.getTimeLimitSeconds(), searchRequest.typesOnly(), searchRequest.getFilter(), searchRequest.getAttributeList()), requestControlList, entryList, referenceList);
        SearchResultListener searchListener = searchRequest.getSearchResultListener();
        if (searchListener == null) {
            returnEntryList = Collections.unmodifiableList(entryList);
            returnReferenceList = Collections.unmodifiableList(referenceList);
        } else {
            returnEntryList = null;
            returnReferenceList = null;
            for (SearchResultEntry e : entryList) {
                searchListener.searchEntryReturned(e);
            }
            for (SearchResultReference r : referenceList) {
                searchListener.searchReferenceReturned(r);
            }
        }
        SearchResultDoneProtocolOp searchDone = responseMessage.getSearchResultDoneProtocolOp();
        ResultCode rc = ResultCode.valueOf(searchDone.getResultCode());
        List<String> referralURLList = searchDone.getReferralURLs();
        if (referralURLList == null || referralURLList.isEmpty()) {
            referralURLs = StaticUtils.NO_STRINGS;
        } else {
            referralURLs = new String[referralURLList.size()];
            referralURLList.toArray(referralURLs);
        }
        List<Control> controlList = responseMessage.getControls();
        if (controlList == null || controlList.isEmpty()) {
            responseControls = StaticUtils.NO_CONTROLS;
        } else {
            responseControls = new Control[controlList.size()];
            controlList.toArray(responseControls);
        }
        SearchResult searchResult = new SearchResult(responseMessage.getMessageID(), rc, searchDone.getDiagnosticMessage(), searchDone.getMatchedDN(), referralURLs, returnEntryList, returnReferenceList, entryList.size(), referenceList.size(), responseControls);
        if (rc == ResultCode.SUCCESS) {
            return searchResult;
        }
        throw new LDAPSearchException(searchResult);
    }

    @Override
    @NotNull
    public SearchResult search(@NotNull ReadOnlySearchRequest searchRequest) throws LDAPSearchException {
        return this.search(searchRequest.duplicate());
    }

    @Override
    @Nullable
    public SearchResultEntry searchForEntry(@NotNull String baseDN, @NotNull SearchScope scope, @NotNull String filter, String ... attributes) throws LDAPSearchException {
        return this.searchForEntry(new SearchRequest(baseDN, scope, InMemoryDirectoryServer.parseFilter(filter), attributes));
    }

    @Override
    @Nullable
    public SearchResultEntry searchForEntry(@NotNull String baseDN, @NotNull SearchScope scope, @NotNull Filter filter, String ... attributes) throws LDAPSearchException {
        return this.searchForEntry(new SearchRequest(baseDN, scope, filter, attributes));
    }

    @Override
    @Nullable
    public SearchResultEntry searchForEntry(@NotNull String baseDN, @NotNull SearchScope scope, @NotNull DereferencePolicy derefPolicy, int timeLimit, boolean typesOnly, @NotNull String filter, String ... attributes) throws LDAPSearchException {
        return this.searchForEntry(new SearchRequest(baseDN, scope, derefPolicy, 1, timeLimit, typesOnly, InMemoryDirectoryServer.parseFilter(filter), attributes));
    }

    @Override
    @Nullable
    public SearchResultEntry searchForEntry(@NotNull String baseDN, @NotNull SearchScope scope, @NotNull DereferencePolicy derefPolicy, int timeLimit, boolean typesOnly, @NotNull Filter filter, String ... attributes) throws LDAPSearchException {
        return this.searchForEntry(new SearchRequest(baseDN, scope, derefPolicy, 1, timeLimit, typesOnly, filter, attributes));
    }

    @Override
    @Nullable
    public SearchResultEntry searchForEntry(@NotNull SearchRequest searchRequest) throws LDAPSearchException {
        SearchResult result;
        SearchRequest r;
        ArrayList<Control> requestControlList = new ArrayList<Control>(searchRequest.getControlList());
        requestControlList.add(new Control("1.3.6.1.4.1.30221.2.5.18", false));
        if (searchRequest.getSizeLimit() == 1 && searchRequest.getSearchResultListener() == null) {
            r = searchRequest;
        } else {
            r = new SearchRequest(searchRequest.getBaseDN(), searchRequest.getScope(), searchRequest.getDereferencePolicy(), 1, searchRequest.getTimeLimitSeconds(), searchRequest.typesOnly(), searchRequest.getFilter(), searchRequest.getAttributes());
            r.setFollowReferrals(InternalSDKHelper.followReferralsInternal(r));
            r.setReferralConnector(InternalSDKHelper.getReferralConnectorInternal(r));
            r.setResponseTimeoutMillis(searchRequest.getResponseTimeoutMillis(null));
            r.setControls(requestControlList);
        }
        try {
            result = this.search(r);
        }
        catch (LDAPSearchException lse) {
            Debug.debugException(lse);
            if (lse.getResultCode() == ResultCode.NO_SUCH_OBJECT) {
                return null;
            }
            throw lse;
        }
        if (result.getEntryCount() == 0) {
            return null;
        }
        return result.getSearchEntries().get(0);
    }

    @Override
    @Nullable
    public SearchResultEntry searchForEntry(@NotNull ReadOnlySearchRequest searchRequest) throws LDAPSearchException {
        return this.searchForEntry(searchRequest.duplicate());
    }

    @NotNull
    public List<String> getPasswordAttributes() {
        return this.inMemoryHandler.getPasswordAttributes();
    }

    @Nullable
    public InMemoryPasswordEncoder getPrimaryPasswordEncoder() {
        return this.inMemoryHandler.getPrimaryPasswordEncoder();
    }

    @NotNull
    public List<InMemoryPasswordEncoder> getAllPasswordEncoders() {
        return this.inMemoryHandler.getAllPasswordEncoders();
    }

    @NotNull
    public List<InMemoryDirectoryServerPassword> getPasswordsInEntry(@NotNull Entry entry, @Nullable ASN1OctetString clearPasswordToMatch) {
        return this.inMemoryHandler.getPasswordsInEntry(entry, clearPasswordToMatch);
    }

    @NotNull
    private static Filter parseFilter(@NotNull String s) throws LDAPSearchException {
        try {
            return Filter.create(s);
        }
        catch (LDAPException le) {
            throw new LDAPSearchException(le);
        }
    }

    public boolean entryExists(@NotNull String dn) throws LDAPException {
        return this.inMemoryHandler.entryExists(dn);
    }

    public boolean entryExists(@NotNull String dn, @NotNull String filter) throws LDAPException {
        return this.inMemoryHandler.entryExists(dn, filter);
    }

    public boolean entryExists(@NotNull Entry entry) throws LDAPException {
        return this.inMemoryHandler.entryExists(entry);
    }

    public void assertEntryExists(@NotNull String dn) throws LDAPException, AssertionError {
        this.inMemoryHandler.assertEntryExists(dn);
    }

    public void assertEntryExists(@NotNull String dn, @NotNull String filter) throws LDAPException, AssertionError {
        this.inMemoryHandler.assertEntryExists(dn, filter);
    }

    public void assertEntryExists(@NotNull Entry entry) throws LDAPException, AssertionError {
        this.inMemoryHandler.assertEntryExists(entry);
    }

    @NotNull
    public List<String> getMissingEntryDNs(String ... dns) throws LDAPException {
        return this.inMemoryHandler.getMissingEntryDNs(StaticUtils.toList(dns));
    }

    @NotNull
    public List<String> getMissingEntryDNs(@NotNull Collection<String> dns) throws LDAPException {
        return this.inMemoryHandler.getMissingEntryDNs(dns);
    }

    public void assertEntriesExist(String ... dns) throws LDAPException, AssertionError {
        this.inMemoryHandler.assertEntriesExist(StaticUtils.toList(dns));
    }

    public void assertEntriesExist(@NotNull Collection<String> dns) throws LDAPException, AssertionError {
        this.inMemoryHandler.assertEntriesExist(dns);
    }

    @Nullable
    public List<String> getMissingAttributeNames(@NotNull String dn, String ... attributeNames) throws LDAPException {
        return this.inMemoryHandler.getMissingAttributeNames(dn, StaticUtils.toList(attributeNames));
    }

    @Nullable
    public List<String> getMissingAttributeNames(@NotNull String dn, @NotNull Collection<String> attributeNames) throws LDAPException {
        return this.inMemoryHandler.getMissingAttributeNames(dn, attributeNames);
    }

    public void assertAttributeExists(@NotNull String dn, String ... attributeNames) throws LDAPException, AssertionError {
        this.inMemoryHandler.assertAttributeExists(dn, StaticUtils.toList(attributeNames));
    }

    public void assertAttributeExists(@NotNull String dn, @NotNull Collection<String> attributeNames) throws LDAPException, AssertionError {
        this.inMemoryHandler.assertAttributeExists(dn, attributeNames);
    }

    @Nullable
    public List<String> getMissingAttributeValues(@NotNull String dn, @NotNull String attributeName, String ... attributeValues) throws LDAPException {
        return this.inMemoryHandler.getMissingAttributeValues(dn, attributeName, StaticUtils.toList(attributeValues));
    }

    @Nullable
    public List<String> getMissingAttributeValues(@NotNull String dn, @NotNull String attributeName, @NotNull Collection<String> attributeValues) throws LDAPException {
        return this.inMemoryHandler.getMissingAttributeValues(dn, attributeName, attributeValues);
    }

    public void assertValueExists(@NotNull String dn, @NotNull String attributeName, String ... attributeValues) throws LDAPException, AssertionError {
        this.inMemoryHandler.assertValueExists(dn, attributeName, StaticUtils.toList(attributeValues));
    }

    public void assertValueExists(@NotNull String dn, @NotNull String attributeName, @NotNull Collection<String> attributeValues) throws LDAPException, AssertionError {
        this.inMemoryHandler.assertValueExists(dn, attributeName, attributeValues);
    }

    public void assertEntryMissing(@NotNull String dn) throws LDAPException, AssertionError {
        this.inMemoryHandler.assertEntryMissing(dn);
    }

    public void assertAttributeMissing(@NotNull String dn, String ... attributeNames) throws LDAPException, AssertionError {
        this.inMemoryHandler.assertAttributeMissing(dn, StaticUtils.toList(attributeNames));
    }

    public void assertAttributeMissing(@NotNull String dn, @NotNull Collection<String> attributeNames) throws LDAPException, AssertionError {
        this.inMemoryHandler.assertAttributeMissing(dn, attributeNames);
    }

    public void assertValueMissing(@NotNull String dn, @NotNull String attributeName, String ... attributeValues) throws LDAPException, AssertionError {
        this.inMemoryHandler.assertValueMissing(dn, attributeName, StaticUtils.toList(attributeValues));
    }

    public void assertValueMissing(@NotNull String dn, @NotNull String attributeName, @NotNull Collection<String> attributeValues) throws LDAPException, AssertionError {
        this.inMemoryHandler.assertValueMissing(dn, attributeName, attributeValues);
    }
}

