/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.support;

import java.util.Iterator;
import org.parboiled.common.Preconditions;
import org.parboiled.support.Checks;
import org.parboiled.support.ValueStack;

public class DefaultValueStack<V>
implements ValueStack<V> {
    protected Element head;
    protected V tempValue;

    public DefaultValueStack() {
    }

    public DefaultValueStack(Iterable<V> iterable) {
        this.pushAll(iterable);
    }

    @Override
    public boolean isEmpty() {
        return this.head == null;
    }

    @Override
    public int size() {
        Element element = this.head;
        int n = 0;
        while (element != null) {
            ++n;
            element = element.tail;
        }
        return n;
    }

    @Override
    public void clear() {
        this.head = null;
    }

    @Override
    public Object takeSnapshot() {
        return this.head;
    }

    @Override
    public void restoreSnapshot(Object object) {
        try {
            this.head = (Element)object;
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Given argument '" + object + "' is not a valid snapshot element");
        }
    }

    @Override
    public void push(V v) {
        this.head = new Element(v, this.head);
    }

    @Override
    public void push(int n, V v) {
        this.head = DefaultValueStack.push(n, v, this.head);
    }

    private static Element push(int n, Object object, Element element) {
        if (n == 0) {
            return new Element(object, element);
        }
        Preconditions.checkArgument(element != null, "Cannot push beyond the bottom of the stack");
        if (n > 0) {
            return new Element(element.value, DefaultValueStack.push(n - 1, object, element.tail));
        }
        throw new IllegalArgumentException("Argument 'down' must not be negative");
    }

    @Override
    public void pushAll(V v, V ... VArray) {
        this.push(v);
        for (V v2 : VArray) {
            this.push(v2);
        }
    }

    @Override
    public void pushAll(Iterable<V> iterable) {
        this.head = null;
        for (V v : iterable) {
            this.push(v);
        }
    }

    @Override
    public V pop() {
        return this.pop(0);
    }

    @Override
    public V pop(int n) {
        this.head = this.pop(n, this.head);
        V v = this.tempValue;
        this.tempValue = null;
        return v;
    }

    private Element pop(int n, Element element) {
        Preconditions.checkArgument(element != null, "Cannot pop from beyond the bottom of the stack");
        if (n == 0) {
            this.tempValue = element.value;
            return element.tail;
        }
        if (n > 0) {
            return new Element(element.value, this.pop(n - 1, element.tail));
        }
        throw new IllegalArgumentException("Argument 'down' must not be negative");
    }

    @Override
    public V peek() {
        return this.peek(0);
    }

    @Override
    public V peek(int n) {
        return (V)DefaultValueStack.peek(n, this.head);
    }

    private static Object peek(int n, Element element) {
        Preconditions.checkArgument(element != null, "Cannot peek beyond the bottom of the stack");
        if (n == 0) {
            return element.value;
        }
        if (n > 0) {
            return DefaultValueStack.peek(n - 1, element.tail);
        }
        throw new IllegalArgumentException("Argument 'down' must not be negative");
    }

    @Override
    public void poke(V v) {
        this.poke(0, v);
    }

    @Override
    public void poke(int n, V v) {
        this.head = DefaultValueStack.poke(n, v, this.head);
    }

    private static Element poke(int n, Object object, Element element) {
        Preconditions.checkArgument(element != null, "Cannot poke beyond the bottom of the stack");
        if (n == 0) {
            return new Element(object, element.tail);
        }
        if (n > 0) {
            return new Element(element.value, DefaultValueStack.poke(n - 1, object, element.tail));
        }
        throw new IllegalArgumentException("Argument 'down' must not be negative");
    }

    @Override
    public void dup() {
        this.push(this.peek());
    }

    @Override
    public void swap() {
        Checks.ensure(DefaultValueStack.isSizeGTE(2, this.head), "Swap not allowed on stack with less than two elements");
        Element element = this.head.tail;
        this.head = new Element(element.value, new Element(this.head.value, element.tail));
    }

    @Override
    public void swap3() {
        Checks.ensure(DefaultValueStack.isSizeGTE(3, this.head), "Swap3 not allowed on stack with less than 3 elements");
        Element element = this.head.tail;
        Element element2 = element.tail;
        this.head = new Element(element2.value, new Element(element.value, new Element(this.head.value, element2.tail)));
    }

    @Override
    public void swap4() {
        Checks.ensure(DefaultValueStack.isSizeGTE(4, this.head), "Swap4 not allowed on stack with less than 4 elements");
        Element element = this.head.tail;
        Element element2 = element.tail;
        Element element3 = element2.tail;
        this.head = new Element(element3.value, new Element(element2.value, new Element(element.value, new Element(this.head.value, element3.tail))));
    }

    @Override
    public void swap5() {
        Checks.ensure(DefaultValueStack.isSizeGTE(5, this.head), "Swap5 not allowed on stack with less than 5 elements");
        Element element = this.head.tail;
        Element element2 = element.tail;
        Element element3 = element2.tail;
        Element element4 = element3.tail;
        this.head = new Element(element4.value, new Element(element3.value, new Element(element2.value, new Element(element.value, new Element(this.head.value, element4.tail)))));
    }

    @Override
    public void swap6() {
        Checks.ensure(DefaultValueStack.isSizeGTE(6, this.head), "Swap6 not allowed on stack with less than 6 elements");
        Element element = this.head.tail;
        Element element2 = element.tail;
        Element element3 = element2.tail;
        Element element4 = element3.tail;
        Element element5 = element4.tail;
        this.head = new Element(element5.value, new Element(element4.value, new Element(element3.value, new Element(element2.value, new Element(element.value, new Element(this.head.value, element5.tail))))));
    }

    private static boolean isSizeGTE(int n, Element element) {
        return n == 1 ? element != null : DefaultValueStack.isSizeGTE(n - 1, element.tail);
    }

    @Override
    public Iterator<V> iterator() {
        return new Iterator<V>(){
            private Element next;
            {
                this.next = DefaultValueStack.this.head;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public V next() {
                Object object = this.next.value;
                this.next = this.next.tail;
                return object;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected static class Element {
        protected final Object value;
        protected final Element tail;

        protected Element(Object object, Element element) {
            this.value = object;
            this.tail = element;
        }
    }
}

