/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.lmtpserver;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.james.core.MailAddress;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.WiringException;
import org.apache.james.protocols.lmtp.LMTPMultiResponse;
import org.apache.james.protocols.lmtp.hook.DeliverToRecipientHook;
import org.apache.james.protocols.smtp.MailEnvelope;
import org.apache.james.protocols.smtp.SMTPResponse;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.AbstractHookableCmdHandler;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.smtpserver.DataLineJamesMessageHookHandler;
import org.apache.mailet.Mail;

public class DataLineLMTPHandler
extends DataLineJamesMessageHookHandler {
    private final List<DeliverToRecipientHook> handlers = new ArrayList<DeliverToRecipientHook>();

    protected Response processExtensions(SMTPSession session, Mail mail) {
        LMTPMultiResponse mResponse = null;
        this.executeJamesMessageHooks(session, mail);
        ReadOnlyMailEnvelope env = new ReadOnlyMailEnvelope(mail);
        for (MailAddress recipient : mail.getRecipients()) {
            DeliverToRecipientHook handler;
            SMTPResponse response = null;
            Iterator<DeliverToRecipientHook> iterator = this.handlers.iterator();
            while (iterator.hasNext() && (response = AbstractHookableCmdHandler.calcDefaultSMTPResponse((HookResult)(handler = iterator.next()).deliver(session, recipient, (MailEnvelope)env))) == null) {
            }
            if (response == null) {
                response = new SMTPResponse("451", (CharSequence)(DSNStatus.getStatus((int)4, (String)"0.0") + "Temporary error deliver message to " + recipient));
            }
            if (mResponse == null) {
                mResponse = new LMTPMultiResponse(response);
                continue;
            }
            mResponse.addResponse(response);
        }
        return mResponse;
    }

    public List<Class<?>> getMarkerInterfaces() {
        ArrayList markers = new ArrayList();
        markers.add(DeliverToRecipientHook.class);
        return markers;
    }

    public void wireExtensions(Class<?> interfaceName, List<?> extension) throws WiringException {
        if (interfaceName.equals(DeliverToRecipientHook.class)) {
            this.handlers.addAll(extension);
        }
    }

    private static final class ReadOnlyMailEnvelope
    extends DataLineJamesMessageHookHandler.MailToMailEnvelopeWrapper {
        public ReadOnlyMailEnvelope(Mail mail) {
            super(mail, null);
        }

        public OutputStream getMessageOutputStream() throws IOException {
            throw new IOException("Read-only envelope");
        }
    }
}

