/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.TypeTokens;
import com.google.common.reflect.TypeToken;
import java.util.Set;
import javax.mail.Flags;
import org.apache.james.mailbox.cassandra.table.Flag;

public class FlagsExtractor {
    public static final TypeToken<Set<String>> STRING_SET = TypeTokens.setOf(String.class);
    public static final TypeCodec<Set<String>> SET_OF_STRINGS_CODEC = CodecRegistry.DEFAULT_INSTANCE.codecFor((DataType)DataType.set((DataType)DataType.text()), STRING_SET);

    public static Flags getFlags(Row row) {
        Flags flags = new Flags();
        for (String flag : Flag.ALL_LOWERCASE) {
            if (!row.getBool(flag)) continue;
            flags.add((Flags.Flag)Flag.JAVAX_MAIL_FLAG.get((Object)flag));
        }
        ((Set)row.get(Flag.USER_FLAGS_LOWERCASE, SET_OF_STRINGS_CODEC)).forEach(arg_0 -> ((Flags)flags).add(arg_0));
        return flags;
    }

    public static Flags getApplicableFlags(Row row) {
        Flags flags = new Flags();
        ((Set)row.get("userFlags", SET_OF_STRINGS_CODEC)).forEach(arg_0 -> ((Flags)flags).add(arg_0));
        return flags;
    }
}

