/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.cassandra.init;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.schemabuilder.SchemaBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.james.backends.cassandra.init.configuration.KeyspaceConfiguration;

public class KeyspaceFactory {
    private static final String SYSTEM_SCHEMA = "system_schema";
    private static final String KEYSPACES = "keyspaces";
    private static final String KEYSPACE_NAME = "keyspace_name";

    public static void createKeyspace(KeyspaceConfiguration configuration, Cluster cluster) {
        try (Session session = cluster.connect();){
            if (!KeyspaceFactory.keyspaceExist(cluster, configuration.getKeyspace())) {
                session.execute((Statement)SchemaBuilder.createKeyspace((String)configuration.getKeyspace()).with().replication((Map)ImmutableMap.builder().put((Object)"class", (Object)"SimpleStrategy").put((Object)"replication_factor", (Object)configuration.getReplicationFactor()).build()).durableWrites(Boolean.valueOf(configuration.isDurableWrites())));
            }
        }
    }

    @VisibleForTesting
    public static boolean keyspaceExist(Cluster cluster, String keyspaceName) {
        try (Session session = cluster.connect(SYSTEM_SCHEMA);){
            long numberOfKeyspaces = session.execute((Statement)QueryBuilder.select().countAll().from(KEYSPACES).where(QueryBuilder.eq((String)KEYSPACE_NAME, (Object)keyspaceName))).one().getLong("count");
            if (numberOfKeyspaces > 1L || numberOfKeyspaces < 0L) {
                throw new IllegalStateException(String.format("unexpected keyspace('%s') count being %d", keyspaceName, numberOfKeyspaces));
            }
            boolean bl = numberOfKeyspaces == 1L;
            return bl;
        }
    }
}

