/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jspf.terms;

import java.util.List;
import org.apache.james.jspf.core.DNSLookupContinuation;
import org.apache.james.jspf.core.DNSRequest;
import org.apache.james.jspf.core.DNSResponse;
import org.apache.james.jspf.core.MacroExpand;
import org.apache.james.jspf.core.MacroExpandEnabled;
import org.apache.james.jspf.core.SPFChecker;
import org.apache.james.jspf.core.SPFCheckerDNSResponseListener;
import org.apache.james.jspf.core.SPFSession;
import org.apache.james.jspf.core.exceptions.NeutralException;
import org.apache.james.jspf.core.exceptions.NoneException;
import org.apache.james.jspf.core.exceptions.PermErrorException;
import org.apache.james.jspf.core.exceptions.TempErrorException;
import org.apache.james.jspf.core.exceptions.TimeoutException;
import org.apache.james.jspf.terms.GenericModifier;

public class ExpModifier
extends GenericModifier
implements MacroExpandEnabled,
SPFCheckerDNSResponseListener {
    private static final String ATTRIBUTE_EXPAND_EXPLANATION = "ExpModifier.ExpandExplanation";
    public static final String REGEX = "[eE][xX][pP]\\=((?:\\%(?:\\{[rctlsodipvhRCTLSODIPVH]\\d*[r]?[\\.\\-\\+,/_\\=]*\\}|\\%|\\_|\\-)|[\\x21-\\x24\\x26-\\x7e]{1})*(?:\\.(?:[a-zA-Z0-9]*[a-zA-Z]{1}[a-zA-Z0-9]*|(?:[a-zA-Z0-9]+\\-(?:[a-zA-Z0-9]|\\-)*[a-zA-Z0-9]))\\.?|\\%(?:\\{[rctlsodipvhRCTLSODIPVH]\\d*[r]?[\\.\\-\\+,/_\\=]*\\}|\\%|\\_|\\-)))";
    private MacroExpand macroExpand;
    private ExpandedChecker expandedChecker = new ExpandedChecker();
    private ExpandedExplanationChecker expandedExplanationChecker = new ExpandedExplanationChecker();

    protected DNSLookupContinuation checkSPFLogged(SPFSession spfData) throws PermErrorException, TempErrorException, NeutralException, NoneException {
        String host = this.getHost();
        if (host == null) {
            return null;
        }
        if (spfData.ignoreExplanation()) {
            return null;
        }
        if (spfData.getCurrentResult() == null || !spfData.getCurrentResult().equals("-")) {
            return null;
        }
        spfData.pushChecker(this.expandedChecker);
        return this.macroExpand.checkExpand(host, spfData, false);
    }

    public DNSLookupContinuation onDNSResponse(DNSResponse lookup, SPFSession spfData) throws PermErrorException, TempErrorException, NeutralException, NoneException {
        try {
            List<String> records = lookup.getResponse();
            if (records == null) {
                return null;
            }
            if (records.size() > 1) {
                this.log.debug("More then one TXT-Record found for explanation");
            } else {
                String exp = records.get(0);
                if (exp.length() >= 2 && exp.charAt(0) == '\"' && exp.charAt(exp.length() - 1) == '\"') {
                    exp = exp.substring(1, exp.length() - 1);
                }
                spfData.setAttribute(ATTRIBUTE_EXPAND_EXPLANATION, exp);
                if (exp != null && !exp.equals("")) {
                    try {
                        spfData.pushChecker(this.expandedExplanationChecker);
                        return this.macroExpand.checkExpand(exp, spfData, true);
                    }
                    catch (PermErrorException permErrorException) {}
                }
            }
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        return null;
    }

    public String toString() {
        return "exp=" + this.getHost();
    }

    public void enableMacroExpand(MacroExpand macroExpand) {
        this.macroExpand = macroExpand;
    }

    private final class ExpandedChecker
    implements SPFChecker {
        private ExpandedChecker() {
        }

        public DNSLookupContinuation checkSPF(SPFSession spfData) throws PermErrorException, NoneException, TempErrorException, NeutralException {
            String host = ExpModifier.this.macroExpand.expand(ExpModifier.this.getHost(), spfData, false);
            return new DNSLookupContinuation(new DNSRequest(host, 5), ExpModifier.this);
        }
    }

    private final class ExpandedExplanationChecker
    implements SPFChecker {
        private ExpandedExplanationChecker() {
        }

        public DNSLookupContinuation checkSPF(SPFSession spfData) throws PermErrorException, NoneException, TempErrorException, NeutralException {
            try {
                String exp = (String)spfData.getAttribute(ExpModifier.ATTRIBUTE_EXPAND_EXPLANATION);
                String expandedExplanation = ExpModifier.this.macroExpand.expand(exp, spfData, true);
                spfData.setExplanation(expandedExplanation);
            }
            catch (PermErrorException permErrorException) {
                // empty catch block
            }
            return null;
        }
    }
}

