/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jwt;

import com.google.common.collect.ImmutableList;
import java.security.PublicKey;
import java.util.List;
import org.apache.james.jwt.JwtConfiguration;
import org.apache.james.jwt.MissingOrInvalidKeyException;
import org.apache.james.jwt.PublicKeyProvider;
import org.apache.james.jwt.PublicKeyReader;

public class DefaultPublicKeyProvider
implements PublicKeyProvider {
    private final JwtConfiguration jwtConfiguration;
    private final PublicKeyReader reader;

    public DefaultPublicKeyProvider(JwtConfiguration jwtConfiguration, PublicKeyReader reader) {
        this.jwtConfiguration = jwtConfiguration;
        this.reader = reader;
    }

    @Override
    public List<PublicKey> get() throws MissingOrInvalidKeyException {
        ImmutableList keys = (ImmutableList)this.jwtConfiguration.getJwtPublicKeyPem().stream().flatMap(s -> this.reader.fromPEM((String)s).stream()).collect(ImmutableList.toImmutableList());
        if (keys.size() != this.jwtConfiguration.getJwtPublicKeyPem().size()) {
            throw new MissingOrInvalidKeyException();
        }
        return keys;
    }
}

