/*
 * Decompiled with CFR 0.152.
 */
package reactor.math;

import java.math.BigInteger;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.publisher.Flux;
import reactor.math.MathSubscriber;
import reactor.math.MonoFromFluxOperator;

final class MonoSumBigInteger<T>
extends MonoFromFluxOperator<T, BigInteger>
implements Fuseable {
    private final Function<? super T, ? extends Number> mapping;

    MonoSumBigInteger(Publisher<? extends T> source, Function<? super T, ? extends Number> mapping) {
        super(Flux.from(source));
        this.mapping = mapping;
    }

    public void subscribe(CoreSubscriber<? super BigInteger> actual) {
        this.source.subscribe(new SumBigIntegerSubscriber<T>(actual, this.mapping));
    }

    private static final class SumBigIntegerSubscriber<T>
    extends MathSubscriber<T, BigInteger> {
        private final Function<? super T, ? extends Number> mapping;
        BigInteger sum;
        boolean hasValue;

        SumBigIntegerSubscriber(CoreSubscriber<? super BigInteger> actual, Function<? super T, ? extends Number> mapping) {
            super(actual);
            this.mapping = mapping;
        }

        @Override
        protected void reset() {
            this.sum = BigInteger.ZERO;
            this.hasValue = false;
        }

        @Override
        protected BigInteger result() {
            return this.hasValue ? this.sum : null;
        }

        @Override
        protected void updateResult(T newValue) {
            Number number = this.mapping.apply(newValue);
            BigInteger bigIntegerValue = BigInteger.valueOf(number.longValue());
            this.sum = this.hasValue ? this.sum.add(bigIntegerValue) : bigIntegerValue;
            this.hasValue = true;
        }
    }
}

