/*
 * Decompiled with CFR 0.152.
 */
package org.jvyaml;

import java.io.FileReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jvyaml.Parser;
import org.jvyaml.ParserException;
import org.jvyaml.Scanner;
import org.jvyaml.ScannerImpl;
import org.jvyaml.YAML;
import org.jvyaml.YAMLConfig;
import org.jvyaml.events.AliasEvent;
import org.jvyaml.events.DocumentEndEvent;
import org.jvyaml.events.DocumentStartEvent;
import org.jvyaml.events.Event;
import org.jvyaml.events.MappingEndEvent;
import org.jvyaml.events.MappingStartEvent;
import org.jvyaml.events.ScalarEvent;
import org.jvyaml.events.SequenceEndEvent;
import org.jvyaml.events.SequenceStartEvent;
import org.jvyaml.events.StreamEndEvent;
import org.jvyaml.events.StreamStartEvent;
import org.jvyaml.tokens.AliasToken;
import org.jvyaml.tokens.AnchorToken;
import org.jvyaml.tokens.BlockEndToken;
import org.jvyaml.tokens.BlockEntryToken;
import org.jvyaml.tokens.BlockMappingStartToken;
import org.jvyaml.tokens.BlockSequenceStartToken;
import org.jvyaml.tokens.DirectiveToken;
import org.jvyaml.tokens.DocumentEndToken;
import org.jvyaml.tokens.DocumentStartToken;
import org.jvyaml.tokens.FlowEntryToken;
import org.jvyaml.tokens.FlowMappingEndToken;
import org.jvyaml.tokens.FlowMappingStartToken;
import org.jvyaml.tokens.FlowSequenceEndToken;
import org.jvyaml.tokens.FlowSequenceStartToken;
import org.jvyaml.tokens.KeyToken;
import org.jvyaml.tokens.ScalarToken;
import org.jvyaml.tokens.StreamEndToken;
import org.jvyaml.tokens.TagToken;
import org.jvyaml.tokens.Token;
import org.jvyaml.tokens.ValueToken;

public class ParserImpl
implements Parser {
    private static final int P_STREAM = 0;
    private static final int P_STREAM_START = 1;
    private static final int P_STREAM_END = 2;
    private static final int P_IMPLICIT_DOCUMENT = 3;
    private static final int P_EXPLICIT_DOCUMENT = 4;
    private static final int P_DOCUMENT_START = 5;
    private static final int P_DOCUMENT_START_IMPLICIT = 6;
    private static final int P_DOCUMENT_END = 7;
    private static final int P_BLOCK_NODE = 8;
    private static final int P_BLOCK_CONTENT = 9;
    private static final int P_PROPERTIES = 10;
    private static final int P_PROPERTIES_END = 11;
    private static final int P_FLOW_CONTENT = 12;
    private static final int P_BLOCK_SEQUENCE = 13;
    private static final int P_BLOCK_MAPPING = 14;
    private static final int P_FLOW_SEQUENCE = 15;
    private static final int P_FLOW_MAPPING = 16;
    private static final int P_SCALAR = 17;
    private static final int P_BLOCK_SEQUENCE_ENTRY = 18;
    private static final int P_BLOCK_MAPPING_ENTRY = 19;
    private static final int P_BLOCK_MAPPING_ENTRY_VALUE = 20;
    private static final int P_BLOCK_NODE_OR_INDENTLESS_SEQUENCE = 21;
    private static final int P_BLOCK_SEQUENCE_START = 22;
    private static final int P_BLOCK_SEQUENCE_END = 23;
    private static final int P_BLOCK_MAPPING_START = 24;
    private static final int P_BLOCK_MAPPING_END = 25;
    private static final int P_INDENTLESS_BLOCK_SEQUENCE = 26;
    private static final int P_BLOCK_INDENTLESS_SEQUENCE_START = 27;
    private static final int P_INDENTLESS_BLOCK_SEQUENCE_ENTRY = 28;
    private static final int P_BLOCK_INDENTLESS_SEQUENCE_END = 29;
    private static final int P_FLOW_SEQUENCE_START = 30;
    private static final int P_FLOW_SEQUENCE_ENTRY = 31;
    private static final int P_FLOW_SEQUENCE_END = 32;
    private static final int P_FLOW_MAPPING_START = 33;
    private static final int P_FLOW_MAPPING_ENTRY = 34;
    private static final int P_FLOW_MAPPING_END = 35;
    private static final int P_FLOW_INTERNAL_MAPPING_START = 36;
    private static final int P_FLOW_INTERNAL_CONTENT = 37;
    private static final int P_FLOW_INTERNAL_VALUE = 38;
    private static final int P_FLOW_INTERNAL_MAPPING_END = 39;
    private static final int P_FLOW_ENTRY_MARKER = 40;
    private static final int P_FLOW_NODE = 41;
    private static final int P_FLOW_MAPPING_INTERNAL_CONTENT = 42;
    private static final int P_FLOW_MAPPING_INTERNAL_VALUE = 43;
    private static final int P_ALIAS = 44;
    private static final int P_EMPTY_SCALAR = 45;
    private static final Event DOCUMENT_END_TRUE = new DocumentEndEvent(true);
    private static final Event DOCUMENT_END_FALSE = new DocumentEndEvent(false);
    private static final Event MAPPING_END = new MappingEndEvent();
    private static final Event SEQUENCE_END = new SequenceEndEvent();
    private static final Event STREAM_END = new StreamEndEvent();
    private static final Event STREAM_START = new StreamStartEvent();
    private static final Production[] P_TABLE = new Production[46];
    private static final Map DEFAULT_TAGS_1_0 = new HashMap();
    private static final Map DEFAULT_TAGS_1_1 = new HashMap();
    private Scanner scanner = null;
    private YAMLConfig cfg = null;
    private Event currentEvent = null;
    private List parseStack = null;
    private ProductionEnvironment pEnv = null;

    private static Event processEmptyScalar() {
        return new ScalarEvent(null, null, new boolean[]{true, false}, "", '\u0000');
    }

    private static Object[] processDirectives(ProductionEnvironment env, Scanner scanner) {
        while (scanner.peekToken() instanceof DirectiveToken) {
            DirectiveToken tok = (DirectiveToken)scanner.getToken();
            if (tok.getName().equals("YAML")) {
                if (env.getYamlVersion() != null) {
                    throw new ParserException(null, "found duplicate YAML directive", null);
                }
                int major = Integer.parseInt(tok.getValue()[0]);
                int minor = Integer.parseInt(tok.getValue()[1]);
                if (major != 1) {
                    throw new ParserException(null, "found incompatible YAML document (version 1.* is required)", null);
                }
                env.setYamlVersion(new int[]{major, minor});
                continue;
            }
            if (!tok.getName().equals("TAG")) continue;
            String handle = tok.getValue()[0];
            String prefix = tok.getValue()[1];
            if (env.getTagHandles().containsKey(handle)) {
                throw new ParserException(null, "duplicate tag handle " + handle, null);
            }
            env.getTagHandles().put(handle, prefix);
        }
        Object[] value = new Object[2];
        value[0] = env.getFinalYamlVersion();
        if (!env.getTagHandles().isEmpty()) {
            value[1] = new HashMap(env.getTagHandles());
        }
        Map baseTags = ((int[])value[0])[1] == 0 ? DEFAULT_TAGS_1_0 : DEFAULT_TAGS_1_1;
        Iterator iter = baseTags.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            if (env.getTagHandles().containsKey(key)) continue;
            env.getTagHandles().put(key, baseTags.get(key));
        }
        return value;
    }

    public ParserImpl(Scanner scanner) {
        this(scanner, YAML.config());
    }

    public ParserImpl(Scanner scanner, YAMLConfig cfg) {
        this.scanner = scanner;
        this.cfg = cfg;
    }

    public boolean checkEvent(Class[] choices) {
        this.parseStream();
        if (this.currentEvent == null) {
            this.currentEvent = this.parseStreamNext();
        }
        if (this.currentEvent != null) {
            if (choices.length == 0) {
                return true;
            }
            int j = choices.length;
            for (int i = 0; i < j; ++i) {
                if (!choices[i].isInstance(this.currentEvent)) continue;
                return true;
            }
        }
        return false;
    }

    public Event peekEvent() {
        this.parseStream();
        if (this.currentEvent == null) {
            this.currentEvent = this.parseStreamNext();
        }
        return this.currentEvent;
    }

    public Event getEvent() {
        this.parseStream();
        if (this.currentEvent == null) {
            this.currentEvent = this.parseStreamNext();
        }
        Event value = this.currentEvent;
        this.currentEvent = null;
        return value;
    }

    public Iterator eachEvent() {
        return new EventIterator();
    }

    public Iterator iterator() {
        return this.eachEvent();
    }

    public void parseStream() {
        if (null == this.parseStack) {
            this.parseStack = new LinkedList();
            this.parseStack.add(0, P_TABLE[0]);
            this.pEnv = new ProductionEnvironment(this.cfg);
        }
    }

    public Event parseStreamNext() {
        while (!this.parseStack.isEmpty()) {
            Event value = ((Production)this.parseStack.remove(0)).produce(this.parseStack, this.pEnv, this.scanner);
            if (null == value) continue;
            return value;
        }
        this.pEnv = null;
        return null;
    }

    public static void tmain(String[] args) throws Exception {
        String filename = args[0];
        System.out.println("Reading of file: \"" + filename + "\"");
        StringBuffer input = new StringBuffer();
        FileReader reader = new FileReader(filename);
        char[] buff = new char[1024];
        int read = 0;
        do {
            read = reader.read(buff);
            input.append(buff, 0, read);
        } while (read >= 1024);
        ((Reader)reader).close();
        String str = input.toString();
        long before = System.currentTimeMillis();
        for (int i = 0; i < 1; ++i) {
            ParserImpl pars = new ParserImpl(new ScannerImpl(str));
            Iterator iter = pars.eachEvent();
            while (iter.hasNext()) {
                iter.next();
            }
        }
        long after = System.currentTimeMillis();
        long time = after - before;
        double timeS = (double)(after - before) / 1000.0;
        System.out.println("Walking through the events for the file: " + filename + " took " + time + "ms, or " + timeS + " seconds");
    }

    public static void main(String[] args) throws Exception {
        String filename = args[0];
        ParserImpl pars = new ParserImpl(new ScannerImpl(new FileReader(filename)));
        Iterator iter = pars.eachEvent();
        while (iter.hasNext()) {
            System.out.println(iter.next().getClass().getName());
        }
    }

    static {
        DEFAULT_TAGS_1_0.put("!", "tag:yaml.org,2002:");
        DEFAULT_TAGS_1_1.put("!", "!");
        DEFAULT_TAGS_1_1.put("!!", "tag:yaml.org,2002:");
        ParserImpl.P_TABLE[0] = new Production(){

            public Event produce(List parseStack, ProductionEnvironment env, Scanner scanner) {
                parseStack.add(0, P_TABLE[2]);
                parseStack.add(0, P_TABLE[4]);
                parseStack.add(0, P_TABLE[3]);
                parseStack.add(0, P_TABLE[1]);
                return null;
            }
        };
        ParserImpl.P_TABLE[1] = new Production(){

            public Event produce(List parseStack, ProductionEnvironment env, Scanner scanner) {
                scanner.getToken();
                return STREAM_START;
            }
        };
        ParserImpl.P_TABLE[2] = new Production(){

            public Event produce(List parseStack, ProductionEnvironment env, Scanner scanner) {
                scanner.getToken();
                return STREAM_END;
            }
        };
        ParserImpl.P_TABLE[3] = new Production(){

            public Event produce(List parseStack, ProductionEnvironment env, Scanner scanner) {
                Token curr = scanner.peekToken();
                if (!(curr instanceof DirectiveToken || curr instanceof DocumentStartToken || curr instanceof StreamEndToken)) {
                    parseStack.add(0, P_TABLE[7]);
                    parseStack.add(0, P_TABLE[8]);
                    parseStack.add(0, P_TABLE[6]);
                }
                return null;
            }
        };
        ParserImpl.P_TABLE[4] = new Production(){

            public Event produce(List parseStack, ProductionEnvironment env, Scanner scanner) {
                if (!(scanner.peekToken() instanceof StreamEndToken)) {
                    parseStack.add(0, P_TABLE[4]);
                    parseStack.add(0, P_TABLE[7]);
                    parseStack.add(0, P_TABLE[8]);
                    parseStack.add(0, P_TABLE[5]);
                }
                return null;
            }
        };
        ParserImpl.P_TABLE[5] = new Production(){

            public Event produce(List parseStack, ProductionEnvironment env, Scanner scanner) {
                Token tok = scanner.peekToken();
                Object[] directives = ParserImpl.processDirectives(env, scanner);
                if (!(scanner.peekToken() instanceof DocumentStartToken)) {
                    throw new ParserException(null, "expected '<document start>', but found " + tok.getClass().getName(), null);
                }
                scanner.getToken();
                return new DocumentStartEvent(true, (int[])directives[0], (Map)directives[1]);
            }
        };
        ParserImpl.P_TABLE[6] = new Production(){

            public Event produce(List parseStack, ProductionEnvironment env, Scanner scanner) {
                Object[] directives = ParserImpl.processDirectives(env, scanner);
                return new DocumentStartEvent(false, (int[])directives[0], (Map)directives[1]);
            }
        };
        ParserImpl.P_TABLE[7] = new Production(){

            public Event produce(List parseStack, ProductionEnvironment env, Scanner scanner) {
                Token tok = scanner.peekToken();
                boolean explicit = false;
                while (scanner.peekToken() instanceof DocumentEndToken) {
                    scanner.getToken();
                    explicit = true;
                }
                return explicit ? DOCUMENT_END_TRUE : DOCUMENT_END_FALSE;
            }
        };
        ParserImpl.P_TABLE[8] = new Production(){

            public Event produce(List parseStack, ProductionEnvironment env, Scanner scanner) {
                Token curr = scanner.peekToken();
                if (curr instanceof DirectiveToken || curr instanceof DocumentStartToken || curr instanceof DocumentEndToken || curr instanceof StreamEndToken) {
                    parseStack.add(0, P_TABLE[45]);
                } else if (curr instanceof AliasToken) {
                    parseStack.add(0, P_TABLE[44]);
                } else {
                    parseStack.add(0, P_TABLE[11]);
                    parseStack.add(0, P_TABLE[9]);
                    parseStack.add(0, P_TABLE[10]);
                }
                return null;
            }
        };
        ParserImpl.P_TABLE[9] = new Production(){

            public Event produce(List parseStack, ProductionEnvironment env, Scanner scanner) {
                Token tok = scanner.peekToken();
                if (tok instanceof BlockSequenceStartToken) {
                    parseStack.add(0, P_TABLE[13]);
                } else if (tok instanceof BlockMappingStartToken) {
                    parseStack.add(0, P_TABLE[14]);
                } else if (tok instanceof FlowSequenceStartToken) {
                    parseStack.add(0, P_TABLE[15]);
                } else if (tok instanceof FlowMappingStartToken) {
                    parseStack.add(0, P_TABLE[16]);
                } else if (tok instanceof ScalarToken) {
                    parseStack.add(0, P_TABLE[17]);
                } else {
                    throw new ParserException("while scanning a node", "expected the node content, but found " + tok.getClass().getName(), null);
                }
                return null;
            }
        };
        ParserImpl.P_TABLE[10] = new Production(){

            public Event produce(List parseStack, ProductionEnvironment env, Scanner scanner) {
                String anchor = null;
                Object tag = null;
                if (scanner.peekToken() instanceof AnchorToken) {
                    anchor = ((AnchorToken)scanner.getToken()).getValue();
                    if (scanner.peekToken() instanceof TagToken) {
                        scanner.getToken();
                    }
                } else if (scanner.peekToken() instanceof TagToken) {
                    tag = ((TagToken)scanner.getToken()).getValue();
                    if (scanner.peekToken() instanceof AnchorToken) {
                        anchor = ((AnchorToken)scanner.getToken()).getValue();
                    }
                }
                if (tag != null && !tag.equals("!")) {
                    String handle = tag[0];
                    String suffix = tag[1];
                    if (handle != null) {
                        if (!env.getTagHandles().containsKey(handle)) {
                            throw new ParserException("while parsing a node", "found undefined tag handle " + handle, null);
                        }
                        tag = (String)env.getTagHandles().get(handle) + suffix;
                    } else {
                        tag = suffix;
                    }
                }
                env.getAnchors().add(0, anchor);
                env.getTags().add(0, tag);
                return null;
            }
        };
        ParserImpl.P_TABLE[11] = new Production(){

            public Event produce(List parseStack, ProductionEnvironment env, Scanner scanner) {
                env.getAnchors().remove(0);
                env.getTags().remove(0);
                return null;
            }
        };
        ParserImpl.P_TABLE[12] = new Production(){

            public Event produce(List parseStack, ProductionEnvironment env, Scanner scanner) {
                Token tok = scanner.peekToken();
                if (tok instanceof FlowSequenceStartToken) {
                    parseStack.add(0, P_TABLE[15]);
                } else if (tok instanceof FlowMappingStartToken) {
                    parseStack.add(0, P_TABLE[16]);
                } else if (tok instanceof ScalarToken) {
                    parseStack.add(0, P_TABLE[17]);
                } else {
                    throw new ParserException("while scanning a flow node", "expected the node content, but found " + tok.getClass().getName(), null);
                }
                return null;
            }
        };
        ParserImpl.P_TABLE[13] = new Production(){

            public Event produce(List parseStack, ProductionEnvironment env, Scanner scanner) {
                parseStack.add(0, P_TABLE[23]);
                parseStack.add(0, P_TABLE[18]);
                parseStack.add(0, P_TABLE[22]);
                return null;
            }
        };
        ParserImpl.P_TABLE[14] = new Production(){

            public Event produce(List parseStack, ProductionEnvironment env, Scanner scanner) {
                parseStack.add(0, P_TABLE[25]);
                parseStack.add(0, P_TABLE[19]);
                parseStack.add(0, P_TABLE[24]);
                return null;
            }
        };
        ParserImpl.P_TABLE[15] = new Production(){

            public Event produce(List parseStack, ProductionEnvironment env, Scanner scanner) {
                parseStack.add(0, P_TABLE[32]);
                parseStack.add(0, P_TABLE[31]);
                parseStack.add(0, P_TABLE[30]);
                return null;
            }
        };
        ParserImpl.P_TABLE[16] = new Production(){

            public Event produce(List parseStack, ProductionEnvironment env, Scanner scanner) {
                parseStack.add(0, P_TABLE[35]);
                parseStack.add(0, P_TABLE[34]);
                parseStack.add(0, P_TABLE[33]);
                return null;
            }
        };
        ParserImpl.P_TABLE[17] = new Production(){

            public Event produce(List parseStack, ProductionEnvironment env, Scanner scanner) {
                ScalarToken tok = (ScalarToken)scanner.getToken();
                boolean[] implicit = null;
                implicit = tok.getPlain() && env.getTags().get(0) == null || "!".equals(env.getTags().get(0)) ? new boolean[]{true, false} : (env.getTags().get(0) == null ? new boolean[]{false, true} : new boolean[]{false, false});
                return new ScalarEvent((String)env.getAnchors().get(0), (String)env.getTags().get(0), implicit, tok.getValue(), tok.getStyle());
            }
        };
        ParserImpl.P_TABLE[18] = new Production(){

            public Event produce(List parseStack, ProductionEnvironment env, Scanner scanner) {
                if (scanner.peekToken() instanceof BlockEntryToken) {
                    scanner.getToken();
                    if (!(scanner.peekToken() instanceof BlockEntryToken) && !(scanner.peekToken() instanceof BlockEndToken)) {
                        parseStack.add(0, P_TABLE[18]);
                        parseStack.add(0, P_TABLE[8]);
                    } else {
                        parseStack.add(0, P_TABLE[18]);
                        parseStack.add(0, P_TABLE[45]);
                    }
                }
                return null;
            }
        };
        ParserImpl.P_TABLE[19] = new Production(){

            public Event produce(List parseStack, ProductionEnvironment env, Scanner scanner) {
                if (scanner.peekToken() instanceof KeyToken || scanner.peekToken() instanceof ValueToken) {
                    if (scanner.peekToken() instanceof KeyToken) {
                        scanner.getToken();
                        Token curr = scanner.peekToken();
                        if (!(curr instanceof KeyToken || curr instanceof ValueToken || curr instanceof BlockEndToken)) {
                            parseStack.add(0, P_TABLE[19]);
                            parseStack.add(0, P_TABLE[20]);
                            parseStack.add(0, P_TABLE[21]);
                        } else {
                            parseStack.add(0, P_TABLE[19]);
                            parseStack.add(0, P_TABLE[20]);
                            parseStack.add(0, P_TABLE[45]);
                        }
                    } else {
                        parseStack.add(0, P_TABLE[19]);
                        parseStack.add(0, P_TABLE[20]);
                        parseStack.add(0, P_TABLE[45]);
                    }
                }
                return null;
            }
        };
        ParserImpl.P_TABLE[20] = new Production(){

            public Event produce(List parseStack, ProductionEnvironment env, Scanner scanner) {
                if (scanner.peekToken() instanceof KeyToken || scanner.peekToken() instanceof ValueToken) {
                    if (scanner.peekToken() instanceof ValueToken) {
                        scanner.getToken();
                        Token curr = scanner.peekToken();
                        if (!(curr instanceof KeyToken || curr instanceof ValueToken || curr instanceof BlockEndToken)) {
                            parseStack.add(0, P_TABLE[21]);
                        } else {
                            parseStack.add(0, P_TABLE[45]);
                        }
                    } else {
                        parseStack.add(0, P_TABLE[45]);
                    }
                }
                return null;
            }
        };
        ParserImpl.P_TABLE[21] = new Production(){

            public Event produce(List parseStack, ProductionEnvironment env, Scanner scanner) {
                if (scanner.peekToken() instanceof AliasToken) {
                    parseStack.add(0, P_TABLE[44]);
                } else if (scanner.peekToken() instanceof BlockEntryToken) {
                    parseStack.add(0, P_TABLE[26]);
                    parseStack.add(0, P_TABLE[10]);
                } else {
                    parseStack.add(0, P_TABLE[9]);
                    parseStack.add(0, P_TABLE[10]);
                }
                return null;
            }
        };
        ParserImpl.P_TABLE[22] = new Production(){

            public Event produce(List parseStack, ProductionEnvironment env, Scanner scanner) {
                boolean implicit = env.getTags().get(0) == null || env.getTags().get(0).equals("!");
                scanner.getToken();
                return new SequenceStartEvent((String)env.getAnchors().get(0), (String)env.getTags().get(0), implicit, false);
            }
        };
        ParserImpl.P_TABLE[23] = new Production(){

            public Event produce(List parseStack, ProductionEnvironment env, Scanner scanner) {
                Token tok = null;
                if (!(scanner.peekToken() instanceof BlockEndToken)) {
                    tok = scanner.peekToken();
                    throw new ParserException("while scanning a block collection", "expected <block end>, but found " + tok.getClass().getName(), null);
                }
                scanner.getToken();
                return SEQUENCE_END;
            }
        };
        ParserImpl.P_TABLE[24] = new Production(){

            public Event produce(List parseStack, ProductionEnvironment env, Scanner scanner) {
                boolean implicit = env.getTags().get(0) == null || env.getTags().get(0).equals("!");
                scanner.getToken();
                return new MappingStartEvent((String)env.getAnchors().get(0), (String)env.getTags().get(0), implicit, false);
            }
        };
        ParserImpl.P_TABLE[25] = new Production(){

            public Event produce(List parseStack, ProductionEnvironment env, Scanner scanner) {
                Token tok = null;
                if (!(scanner.peekToken() instanceof BlockEndToken)) {
                    tok = scanner.peekToken();
                    throw new ParserException("while scanning a block mapping", "expected <block end>, but found " + tok.getClass().getName(), null);
                }
                scanner.getToken();
                return MAPPING_END;
            }
        };
        ParserImpl.P_TABLE[26] = new Production(){

            public Event produce(List parseStack, ProductionEnvironment env, Scanner scanner) {
                parseStack.add(0, P_TABLE[29]);
                parseStack.add(0, P_TABLE[28]);
                parseStack.add(0, P_TABLE[27]);
                return null;
            }
        };
        ParserImpl.P_TABLE[27] = new Production(){

            public Event produce(List parseStack, ProductionEnvironment env, Scanner scanner) {
                boolean implicit = env.getTags().get(0) == null || env.getTags().get(0).equals("!");
                return new SequenceStartEvent((String)env.getAnchors().get(0), (String)env.getTags().get(0), implicit, false);
            }
        };
        ParserImpl.P_TABLE[28] = new Production(){

            public Event produce(List parseStack, ProductionEnvironment env, Scanner scanner) {
                if (scanner.peekToken() instanceof BlockEntryToken) {
                    scanner.getToken();
                    Token curr = scanner.peekToken();
                    if (!(curr instanceof BlockEntryToken || curr instanceof KeyToken || curr instanceof ValueToken || curr instanceof BlockEndToken)) {
                        parseStack.add(0, P_TABLE[28]);
                        parseStack.add(0, P_TABLE[8]);
                    } else {
                        parseStack.add(0, P_TABLE[28]);
                        parseStack.add(0, P_TABLE[45]);
                    }
                }
                return null;
            }
        };
        ParserImpl.P_TABLE[29] = new Production(){

            public Event produce(List parseStack, ProductionEnvironment env, Scanner scanner) {
                return SEQUENCE_END;
            }
        };
        ParserImpl.P_TABLE[30] = new Production(){

            public Event produce(List parseStack, ProductionEnvironment env, Scanner scanner) {
                boolean implicit = env.getTags().get(0) == null || env.getTags().get(0).equals("!");
                scanner.getToken();
                return new SequenceStartEvent((String)env.getAnchors().get(0), (String)env.getTags().get(0), implicit, true);
            }
        };
        ParserImpl.P_TABLE[31] = new Production(){

            public Event produce(List parseStack, ProductionEnvironment env, Scanner scanner) {
                if (!(scanner.peekToken() instanceof FlowSequenceEndToken)) {
                    if (scanner.peekToken() instanceof KeyToken) {
                        parseStack.add(0, P_TABLE[31]);
                        parseStack.add(0, P_TABLE[40]);
                        parseStack.add(0, P_TABLE[39]);
                        parseStack.add(0, P_TABLE[38]);
                        parseStack.add(0, P_TABLE[37]);
                        parseStack.add(0, P_TABLE[36]);
                    } else {
                        parseStack.add(0, P_TABLE[31]);
                        parseStack.add(0, P_TABLE[41]);
                        parseStack.add(0, P_TABLE[40]);
                    }
                }
                return null;
            }
        };
        ParserImpl.P_TABLE[32] = new Production(){

            public Event produce(List parseStack, ProductionEnvironment env, Scanner scanner) {
                scanner.getToken();
                return SEQUENCE_END;
            }
        };
        ParserImpl.P_TABLE[33] = new Production(){

            public Event produce(List parseStack, ProductionEnvironment env, Scanner scanner) {
                boolean implicit = env.getTags().get(0) == null || env.getTags().get(0).equals("!");
                scanner.getToken();
                return new MappingStartEvent((String)env.getAnchors().get(0), (String)env.getTags().get(0), implicit, true);
            }
        };
        ParserImpl.P_TABLE[34] = new Production(){

            public Event produce(List parseStack, ProductionEnvironment env, Scanner scanner) {
                if (!(scanner.peekToken() instanceof FlowMappingEndToken)) {
                    if (scanner.peekToken() instanceof KeyToken) {
                        parseStack.add(0, P_TABLE[34]);
                        parseStack.add(0, P_TABLE[40]);
                        parseStack.add(0, P_TABLE[43]);
                        parseStack.add(0, P_TABLE[42]);
                    } else {
                        parseStack.add(0, P_TABLE[34]);
                        parseStack.add(0, P_TABLE[41]);
                        parseStack.add(0, P_TABLE[40]);
                    }
                }
                return null;
            }
        };
        ParserImpl.P_TABLE[35] = new Production(){

            public Event produce(List parseStack, ProductionEnvironment env, Scanner scanner) {
                scanner.getToken();
                return MAPPING_END;
            }
        };
        ParserImpl.P_TABLE[36] = new Production(){

            public Event produce(List parseStack, ProductionEnvironment env, Scanner scanner) {
                scanner.getToken();
                return new MappingStartEvent(null, null, true, true);
            }
        };
        ParserImpl.P_TABLE[37] = new Production(){

            public Event produce(List parseStack, ProductionEnvironment env, Scanner scanner) {
                Token curr = scanner.peekToken();
                if (!(curr instanceof ValueToken || curr instanceof FlowEntryToken || curr instanceof FlowSequenceEndToken)) {
                    parseStack.add(0, P_TABLE[41]);
                } else {
                    parseStack.add(0, P_TABLE[45]);
                }
                return null;
            }
        };
        ParserImpl.P_TABLE[38] = new Production(){

            public Event produce(List parseStack, ProductionEnvironment env, Scanner scanner) {
                if (scanner.peekToken() instanceof ValueToken) {
                    scanner.getToken();
                    if (!(scanner.peekToken() instanceof FlowEntryToken) && !(scanner.peekToken() instanceof FlowSequenceEndToken)) {
                        parseStack.add(0, P_TABLE[41]);
                    } else {
                        parseStack.add(0, P_TABLE[45]);
                    }
                } else {
                    parseStack.add(0, P_TABLE[45]);
                }
                return null;
            }
        };
        ParserImpl.P_TABLE[39] = new Production(){

            public Event produce(List parseStack, ProductionEnvironment env, Scanner scanner) {
                return MAPPING_END;
            }
        };
        ParserImpl.P_TABLE[40] = new Production(){

            public Event produce(List parseStack, ProductionEnvironment env, Scanner scanner) {
                if (scanner.peekToken() instanceof FlowEntryToken) {
                    scanner.getToken();
                }
                return null;
            }
        };
        ParserImpl.P_TABLE[41] = new Production(){

            public Event produce(List parseStack, ProductionEnvironment env, Scanner scanner) {
                if (scanner.peekToken() instanceof AliasToken) {
                    parseStack.add(0, P_TABLE[44]);
                } else {
                    parseStack.add(0, P_TABLE[11]);
                    parseStack.add(0, P_TABLE[12]);
                    parseStack.add(0, P_TABLE[10]);
                }
                return null;
            }
        };
        ParserImpl.P_TABLE[42] = new Production(){

            public Event produce(List parseStack, ProductionEnvironment env, Scanner scanner) {
                Token curr = scanner.peekToken();
                if (!(curr instanceof ValueToken || curr instanceof FlowEntryToken || curr instanceof FlowMappingEndToken)) {
                    scanner.getToken();
                    parseStack.add(0, P_TABLE[41]);
                } else {
                    parseStack.add(0, P_TABLE[45]);
                }
                return null;
            }
        };
        ParserImpl.P_TABLE[43] = new Production(){

            public Event produce(List parseStack, ProductionEnvironment env, Scanner scanner) {
                if (scanner.peekToken() instanceof ValueToken) {
                    scanner.getToken();
                    if (!(scanner.peekToken() instanceof FlowEntryToken) && !(scanner.peekToken() instanceof FlowMappingEndToken)) {
                        parseStack.add(0, P_TABLE[41]);
                    } else {
                        parseStack.add(0, P_TABLE[45]);
                    }
                } else {
                    parseStack.add(0, P_TABLE[45]);
                }
                return null;
            }
        };
        ParserImpl.P_TABLE[44] = new Production(){

            public Event produce(List parseStack, ProductionEnvironment env, Scanner scanner) {
                AliasToken tok = (AliasToken)scanner.getToken();
                return new AliasEvent(tok.getValue());
            }
        };
        ParserImpl.P_TABLE[45] = new Production(){

            public Event produce(List parseStack, ProductionEnvironment env, Scanner scanner) {
                return ParserImpl.processEmptyScalar();
            }
        };
    }

    private class EventIterator
    implements Iterator {
        private EventIterator() {
        }

        public boolean hasNext() {
            return null != ParserImpl.this.peekEvent();
        }

        public Object next() {
            return ParserImpl.this.getEvent();
        }

        public void remove() {
        }
    }

    private static interface Production {
        public Event produce(List var1, ProductionEnvironment var2, Scanner var3);
    }

    private static class ProductionEnvironment {
        private List tags = new LinkedList();
        private List anchors = new LinkedList();
        private Map tagHandles = new HashMap();
        private int[] yamlVersion = null;
        private int[] defaultYamlVersion = new int[2];

        public ProductionEnvironment(YAMLConfig cfg) {
            this.defaultYamlVersion[0] = Integer.parseInt(cfg.version().substring(0, cfg.version().indexOf(46)));
            this.defaultYamlVersion[1] = Integer.parseInt(cfg.version().substring(cfg.version().indexOf(46) + 1));
        }

        public List getTags() {
            return this.tags;
        }

        public List getAnchors() {
            return this.anchors;
        }

        public Map getTagHandles() {
            return this.tagHandles;
        }

        public int[] getYamlVersion() {
            return this.yamlVersion;
        }

        public int[] getFinalYamlVersion() {
            if (null == this.yamlVersion) {
                return this.defaultYamlVersion;
            }
            return this.yamlVersion;
        }

        public void setYamlVersion(int[] yamlVersion) {
            this.yamlVersion = yamlVersion;
        }
    }
}

