/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.iot.logdispatcher;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.commons.memory.AtomicLongMemoryBlock;
import org.apache.iotdb.commons.memory.IMemoryBlock;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.consensus.common.request.IndexedConsensusRequest;
import org.apache.iotdb.consensus.iot.logdispatcher.Batch;
import org.apache.iotdb.consensus.iot.logdispatcher.IoTConsensusMemoryManagerMetrics;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTConsensusMemoryManager {
    private static final Logger logger = LoggerFactory.getLogger(IoTConsensusMemoryManager.class);
    private final AtomicLong queueMemorySizeInByte = new AtomicLong(0L);
    private final AtomicLong syncMemorySizeInByte = new AtomicLong(0L);
    private IMemoryBlock memoryBlock = new AtomicLongMemoryBlock("Consensus-Default", null, Runtime.getRuntime().maxMemory() / 10L);
    private Double maxMemoryRatioForQueue = 0.6;
    private static final IoTConsensusMemoryManager INSTANCE = new IoTConsensusMemoryManager();

    private IoTConsensusMemoryManager() {
        MetricService.getInstance().addMetricSet((IMetricSet)new IoTConsensusMemoryManagerMetrics(this));
    }

    public boolean reserve(IndexedConsensusRequest request) {
        long prevRef = request.incRef();
        if (prevRef == 0L) {
            boolean reserved = this.reserve(request.getMemorySize(), true);
            if (reserved) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Reserving {} bytes for request {} succeeds, current total usage {}", new Object[]{request.getMemorySize(), request.getSearchIndex(), this.memoryBlock.getUsedMemoryInBytes()});
                }
            } else {
                request.decRef();
                if (logger.isDebugEnabled()) {
                    logger.debug("Reserving {} bytes for request {} fails, current total usage {}", new Object[]{request.getMemorySize(), request.getSearchIndex(), this.memoryBlock.getUsedMemoryInBytes()});
                }
            }
            return reserved;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Skip memory reservation for {} because its ref count is not 0", (Object)request.getSearchIndex());
        }
        return true;
    }

    public boolean reserve(Batch batch) {
        boolean reserved = this.reserve(batch.getMemorySize(), false);
        if (reserved && logger.isDebugEnabled()) {
            logger.debug("Reserving {} bytes for batch {}-{} succeeds, current total usage {}", new Object[]{batch.getMemorySize(), batch.getStartIndex(), batch.getEndIndex(), this.memoryBlock.getUsedMemoryInBytes()});
        } else if (logger.isDebugEnabled()) {
            logger.debug("Reserving {} bytes for batch {}-{} fails, current total usage {}", new Object[]{batch.getMemorySize(), batch.getStartIndex(), batch.getEndIndex(), this.memoryBlock.getUsedMemoryInBytes()});
        }
        return reserved;
    }

    private boolean reserve(long size, boolean fromQueue) {
        boolean result;
        boolean bl = result = fromQueue ? this.memoryBlock.allocateIfSufficient(size, this.maxMemoryRatioForQueue.doubleValue()) : this.memoryBlock.allocate(size);
        if (result) {
            if (fromQueue) {
                this.queueMemorySizeInByte.addAndGet(size);
            } else {
                this.syncMemorySizeInByte.addAndGet(size);
            }
        }
        return result;
    }

    public void free(IndexedConsensusRequest request) {
        long prevRef = request.decRef();
        if (prevRef == 1L) {
            this.free(request.getMemorySize(), true);
            if (logger.isDebugEnabled()) {
                logger.debug("Freed {} bytes for request {}, current total usage {}", new Object[]{request.getMemorySize(), request.getSearchIndex(), this.memoryBlock.getUsedMemoryInBytes()});
            }
        }
    }

    public void free(Batch batch) {
        this.free(batch.getMemorySize(), false);
        if (logger.isDebugEnabled()) {
            logger.debug("Freed {} bytes for batch {}-{}, current total usage {}", new Object[]{batch.getMemorySize(), batch.getStartIndex(), batch.getEndIndex(), this.getMemorySizeInByte()});
        }
    }

    private void free(long size, boolean fromQueue) {
        long currentUsedMemory = this.memoryBlock.release(size);
        if (fromQueue) {
            this.queueMemorySizeInByte.addAndGet(-size);
        } else {
            this.syncMemorySizeInByte.addAndGet(-size);
        }
        logger.debug("{} free {} bytes, total memory size: {} bytes.", new Object[]{Thread.currentThread().getName(), size, currentUsedMemory});
    }

    public void init(IMemoryBlock memoryBlock, double maxMemoryRatioForQueue) {
        this.memoryBlock = memoryBlock;
        this.maxMemoryRatioForQueue = maxMemoryRatioForQueue;
    }

    @TestOnly
    public void reset() {
        this.memoryBlock.release(this.memoryBlock.getUsedMemoryInBytes());
        this.queueMemorySizeInByte.set(0L);
        this.syncMemorySizeInByte.set(0L);
    }

    @TestOnly
    public IMemoryBlock getMemoryBlock() {
        return this.memoryBlock;
    }

    @TestOnly
    public void setMemoryBlock(IMemoryBlock memoryBlock) {
        this.memoryBlock = memoryBlock;
    }

    @TestOnly
    public Double getMaxMemoryRatioForQueue() {
        return this.maxMemoryRatioForQueue;
    }

    long getMemorySizeInByte() {
        return this.memoryBlock.getUsedMemoryInBytes();
    }

    long getQueueMemorySizeInByte() {
        return this.queueMemorySizeInByte.get();
    }

    long getSyncMemorySizeInByte() {
        return this.syncMemorySizeInByte.get();
    }

    public static IoTConsensusMemoryManager getInstance() {
        return INSTANCE;
    }
}

