/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.unary.scalar;

import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.unary.scalar.AbstractBitwise2ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.util.BitwiseUtils;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.type.Type;

public class BitwiseRightShift2ColumnTransformer
extends AbstractBitwise2ColumnTransformer {
    public BitwiseRightShift2ColumnTransformer(Type returnType, ColumnTransformer leftTransformer, ColumnTransformer rightTransformer) {
        super(returnType, leftTransformer, rightTransformer);
    }

    @Override
    protected void transform(Column leftColumn, Column rightColumn, ColumnBuilder columnBuilder, int i) {
        if (TSDataType.INT32.equals((Object)leftColumn.getDataType())) {
            int leftValue = leftColumn.getInt(i);
            if (TSDataType.INT32.equals((Object)rightColumn.getDataType())) {
                int rightValue = rightColumn.getInt(i);
                columnBuilder.writeInt(BitwiseUtils.bitwiseRightShiftTransform(leftValue, (long)rightValue));
            } else if (TSDataType.INT64.equals((Object)rightColumn.getDataType())) {
                long rightValue = rightColumn.getLong(i);
                columnBuilder.writeInt(BitwiseUtils.bitwiseRightShiftTransform(leftValue, rightValue));
            }
        } else if (TSDataType.INT64.equals((Object)leftColumn.getDataType())) {
            long leftValue = leftColumn.getLong(i);
            if (TSDataType.INT32.equals((Object)rightColumn.getDataType())) {
                int rightValue = rightColumn.getInt(i);
                columnBuilder.writeLong(BitwiseUtils.bitwiseRightShiftTransform(leftValue, (long)rightValue));
            } else if (TSDataType.INT64.equals((Object)rightColumn.getDataType())) {
                long rightValue = rightColumn.getLong(i);
                columnBuilder.writeLong(BitwiseUtils.bitwiseRightShiftTransform(leftValue, rightValue));
            }
        }
    }
}

