/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.execution.config.session;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.schema.column.ColumnHeader;
import org.apache.iotdb.commons.schema.column.ColumnHeaderConstant;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeaderFactory;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.queryengine.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.queryengine.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.utils.Binary;

public class ShowCurrentUserTask
implements IConfigTask {
    private final String currentUser;

    public ShowCurrentUserTask(String currentUser) {
        this.currentUser = currentUser;
    }

    public static void buildTsBlock(String currentUser, SettableFuture<ConfigTaskResult> future) {
        List outputDataTypes = ColumnHeaderConstant.SHOW_CURRENT_USER_COLUMN_HEADERS.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
        TsBlockBuilder tsBlockBuilder = new TsBlockBuilder(outputDataTypes);
        tsBlockBuilder.getTimeColumnBuilder().writeLong(0L);
        tsBlockBuilder.getColumnBuilder(0).writeBinary(new Binary(currentUser, TSFileConfig.STRING_CHARSET));
        tsBlockBuilder.declarePosition();
        future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS, tsBlockBuilder.build(), DatasetHeaderFactory.getShowCurrentUserHeader()));
    }

    @Override
    public ListenableFuture<ConfigTaskResult> execute(IConfigTaskExecutor configTaskExecutor) throws InterruptedException {
        return configTaskExecutor.showCurrentUser(this.currentUser);
    }
}

