/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.transformer.unary;

import java.io.IOException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.transformation.api.LayerReader;
import org.apache.iotdb.db.queryengine.transformation.dag.transformer.unary.UnaryTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;

public class ArithmeticNegationTransformer
extends UnaryTransformer {
    public ArithmeticNegationTransformer(LayerReader layerReader) {
        super(layerReader);
    }

    @Override
    public TSDataType[] getDataTypes() {
        return new TSDataType[]{this.layerReaderDataType};
    }

    @Override
    protected void transform(Column[] columns, ColumnBuilder builder) throws QueryProcessException, IOException {
        switch (this.layerReaderDataType) {
            case INT32: {
                this.transformInt(columns, builder);
                return;
            }
            case INT64: {
                this.transformLong(columns, builder);
                return;
            }
            case FLOAT: {
                this.transformFloat(columns, builder);
                return;
            }
            case DOUBLE: {
                this.transformDouble(columns, builder);
                return;
            }
        }
        throw new QueryProcessException("Unsupported data type: " + this.layerReaderDataType);
    }

    private void transformInt(Column[] columns, ColumnBuilder builder) {
        int count = columns[0].getPositionCount();
        int[] values = columns[0].getInts();
        boolean[] isNulls = columns[0].isNull();
        for (int i = 0; i < count; ++i) {
            if (!isNulls[i]) {
                builder.writeInt(-values[i]);
                continue;
            }
            builder.appendNull();
        }
    }

    private void transformLong(Column[] columns, ColumnBuilder builder) {
        int count = columns[0].getPositionCount();
        long[] values = columns[0].getLongs();
        boolean[] isNulls = columns[0].isNull();
        for (int i = 0; i < count; ++i) {
            if (!isNulls[i]) {
                builder.writeLong(-values[i]);
                continue;
            }
            builder.appendNull();
        }
    }

    private void transformFloat(Column[] columns, ColumnBuilder builder) {
        int count = columns[0].getPositionCount();
        float[] values = columns[0].getFloats();
        boolean[] isNulls = columns[0].isNull();
        for (int i = 0; i < count; ++i) {
            if (!isNulls[i]) {
                builder.writeFloat(-values[i]);
                continue;
            }
            builder.appendNull();
        }
    }

    private void transformDouble(Column[] columns, ColumnBuilder builder) {
        int count = columns[0].getPositionCount();
        double[] values = columns[0].getDoubles();
        boolean[] isNulls = columns[0].isNull();
        for (int i = 0; i < count; ++i) {
            if (!isNulls[i]) {
                builder.writeDouble(-values[i]);
                continue;
            }
            builder.appendNull();
        }
    }
}

