/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.service;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPeriodicalServiceWithAdvance {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPeriodicalServiceWithAdvance.class);
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    protected volatile boolean skipNextSleep = false;
    private volatile boolean allowSubmitListen = false;
    protected ExecutorService securityServiceExecutor;
    private final long intervalMillis;

    protected AbstractPeriodicalServiceWithAdvance(ExecutorService securityServiceExecutor, long intervalMillis) {
        this.securityServiceExecutor = securityServiceExecutor;
        this.intervalMillis = intervalMillis;
    }

    public void advanceExecution() {
        if (this.lock.tryLock()) {
            try {
                this.condition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        } else {
            this.skipNextSleep = true;
        }
    }

    private void execute() {
        this.lock.lock();
        try {
            this.executeTask();
            if (!this.skipNextSleep) {
                this.condition.await(this.intervalMillis, TimeUnit.MILLISECONDS);
            }
            this.skipNextSleep = false;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.warn("Interrupted when waiting for the next device view update: {}", (Object)e.getMessage());
        }
        finally {
            this.lock.unlock();
            if (this.allowSubmitListen) {
                this.securityServiceExecutor.submit(this::execute);
            }
        }
    }

    protected abstract void executeTask();

    public void startService() {
        this.allowSubmitListen = true;
        this.securityServiceExecutor.submit(this::execute);
        LOGGER.info("{} is started successfully.", (Object)this.getClass().getSimpleName());
    }

    public void stopService() {
        this.allowSubmitListen = false;
        LOGGER.info("{} is stopped successfully.", (Object)this.getClass().getSimpleName());
    }
}

