/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.parser;

import com.google.common.base.Preconditions;
import org.antlr.v4.runtime.RecognitionException;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;

public class ParsingException
extends RuntimeException {
    private final int line;
    private final int column;

    public ParsingException(String message, RecognitionException cause, int line, int column) {
        super(message, (Throwable)cause);
        Preconditions.checkArgument((line > 0 ? 1 : 0) != 0, (Object)"line must be > 0");
        Preconditions.checkArgument((column > 0 ? 1 : 0) != 0, (Object)"column must be > 0");
        this.line = line;
        this.column = column;
    }

    public ParsingException(String message) {
        this(message, null, 1, 1);
    }

    public ParsingException(String message, RecognitionException cause) {
        this(message, cause, 1, 1);
    }

    public ParsingException(String message, NodeLocation nodeLocation) {
        this(message, null, nodeLocation.getLineNumber(), nodeLocation.getColumnNumber());
    }

    public int getLineNumber() {
        return this.line;
    }

    public int getColumnNumber() {
        return this.column;
    }

    public String getErrorMessage() {
        return super.getMessage();
    }

    @Override
    public String getMessage() {
        return String.format("line %s:%s: %s", this.getLineNumber(), this.getColumnNumber(), this.getErrorMessage());
    }
}

