/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;

public class Parameter
extends Expression {
    private final int id;

    public Parameter(int id) {
        super(null);
        this.id = id;
    }

    public Parameter(NodeLocation location, int id) {
        super(Objects.requireNonNull(location, "location is null"));
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitParameter(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Parameter that = (Parameter)o;
        return Objects.equals(this.id, that.id);
    }

    @Override
    public int hashCode() {
        return this.id;
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!Parameter.sameClass(this, other)) {
            return false;
        }
        return this.id == ((Parameter)other).id;
    }
}

