/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.datastructure.interval;

import java.util.TreeSet;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iotdb.commons.pipe.datastructure.interval.Interval;

@NotThreadSafe
public class IntervalManager<T extends Interval<T>> {
    private final TreeSet<T> intervals = new TreeSet();

    public void addInterval(T newInterval) {
        Interval left = (Interval)this.intervals.floor(newInterval);
        Interval right = (Interval)this.intervals.ceiling(newInterval);
        while (left != null && left.end >= newInterval.start - 1L) {
            newInterval.start = Math.min(left.start, newInterval.start);
            newInterval.end = Math.max(left.end, newInterval.end);
            newInterval.onMerged((Interval)left);
            this.intervals.remove(left);
            left = (Interval)this.intervals.floor(newInterval);
        }
        while (right != null && newInterval.end >= right.start - 1L) {
            newInterval.start = Math.min(newInterval.start, right.start);
            newInterval.end = Math.max(newInterval.end, right.end);
            newInterval.onMerged((Interval)right);
            this.intervals.remove(right);
            right = (Interval)this.intervals.ceiling(newInterval);
        }
        this.intervals.add(newInterval);
    }

    public T peek() {
        return (T)((Interval)this.intervals.first());
    }

    public boolean remove(T interval) {
        if (this.intervals.remove(interval)) {
            ((Interval)interval).onRemoved();
            return true;
        }
        return false;
    }

    public int size() {
        return this.intervals.size();
    }

    public String toString() {
        return "IntervalManager{intervals=" + this.intervals + '}';
    }
}

