/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.logical.sys;

import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.logical.crud.QueryOperator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateContinuousQueryPlan;
import org.apache.iotdb.db.qp.strategy.PhysicalGenerator;

public class CreateContinuousQueryOperator
extends Operator {
    private String querySql;
    private QueryOperator queryOperator;
    private String continuousQueryName;
    private PartialPath targetPath;
    private long everyInterval;
    private long forInterval;
    private long groupByTimeInterval;
    private String groupByTimeIntervalString;
    private Long firstExecutionTimeBoundary;

    public CreateContinuousQueryOperator(int tokenIntType) {
        super(tokenIntType);
        this.operatorType = Operator.OperatorType.CREATE_CONTINUOUS_QUERY;
    }

    public void setQuerySql(String querySql) {
        this.querySql = querySql;
    }

    public void setContinuousQueryName(String continuousQueryName) {
        this.continuousQueryName = continuousQueryName;
    }

    public void setTargetPath(PartialPath targetPath) {
        this.targetPath = targetPath;
    }

    public void setEveryInterval(long everyInterval) {
        this.everyInterval = everyInterval;
    }

    public long getEveryInterval() {
        return this.everyInterval;
    }

    public void setForInterval(long forInterval) {
        this.forInterval = forInterval;
    }

    public long getForInterval() {
        return this.forInterval;
    }

    public void setGroupByTimeInterval(long groupByTimeInterval) {
        this.groupByTimeInterval = groupByTimeInterval;
    }

    public void setGroupByTimeIntervalString(String groupByTimeIntervalString) {
        this.groupByTimeIntervalString = groupByTimeIntervalString;
    }

    public void setFirstExecutionTimeBoundary(long firstExecutionTimeBoundary) {
        this.firstExecutionTimeBoundary = firstExecutionTimeBoundary;
    }

    public void setQueryOperator(QueryOperator queryOperator) {
        this.queryOperator = queryOperator;
    }

    public QueryOperator getQueryOperator() {
        return this.queryOperator;
    }

    @Override
    public PhysicalPlan generatePhysicalPlan(PhysicalGenerator generator) throws QueryProcessException {
        return new CreateContinuousQueryPlan(this.querySql, this.continuousQueryName, this.targetPath, this.everyInterval, this.forInterval, this.groupByTimeInterval, this.groupByTimeIntervalString, this.firstExecutionTimeBoundary);
    }
}

