/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.query;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.RaftNode;
import org.apache.iotdb.db.query.context.QueryContext;

public class RemoteQueryContext
extends QueryContext {
    private Map<RaftNode, Set<Node>> queriedNodesMap = new HashMap<RaftNode, Set<Node>>();
    private Set<Long> localReaderIds = new ConcurrentSkipListSet<Long>();
    private Set<Long> localGroupByExecutorIds = new ConcurrentSkipListSet<Long>();

    public RemoteQueryContext(long jobId) {
        super(jobId);
    }

    public RemoteQueryContext(long jobId, boolean debug, long startTime, String statement, long timeout) {
        super(jobId, debug, startTime, statement, timeout);
    }

    public void registerRemoteNode(Node node, RaftNode header) {
        this.queriedNodesMap.computeIfAbsent(header, n -> new HashSet()).add(node);
    }

    public void registerLocalReader(long readerId) {
        this.localReaderIds.add(readerId);
    }

    public void registerLocalGroupByExecutor(long executorId) {
        this.localGroupByExecutorIds.add(executorId);
    }

    public Set<Long> getLocalReaderIds() {
        return this.localReaderIds;
    }

    public Set<Long> getLocalGroupByExecutorIds() {
        return this.localGroupByExecutorIds;
    }

    public Map<RaftNode, Set<Node>> getQueriedNodesMap() {
        return this.queriedNodesMap;
    }
}

