/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.dropwizard.reporter;

import com.codahale.metrics.MetricFilter;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.metrics.AbstractMetricManager;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.dropwizard.DropwizardMetricManager;
import org.apache.iotdb.metrics.dropwizard.reporter.IoTDBReporter;
import org.apache.iotdb.metrics.reporter.Reporter;
import org.apache.iotdb.metrics.utils.ReporterType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropwizardIoTDBReporter
implements Reporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DropwizardIoTDBReporter.class);
    private AbstractMetricManager dropwizardMetricManager = null;
    private IoTDBReporter reporter;

    public boolean start() {
        if (this.reporter != null) {
            LOGGER.warn("Dropwizard IoTDBReporter already start!");
            return false;
        }
        this.reporter = IoTDBReporter.forRegistry(((DropwizardMetricManager)this.dropwizardMetricManager).getMetricRegistry()).prefixedWith("dropwizard:").filter(MetricFilter.ALL).build();
        this.reporter.start(MetricConfigDescriptor.getInstance().getMetricConfig().getIoTDBReporterConfig().getPushPeriodInSecond().intValue(), TimeUnit.SECONDS);
        return true;
    }

    public boolean stop() {
        if (this.reporter != null) {
            this.reporter.stop();
            this.reporter = null;
        }
        return true;
    }

    public ReporterType getReporterType() {
        return ReporterType.IOTDB;
    }

    public void setMetricManager(AbstractMetricManager metricManager) {
        this.dropwizardMetricManager = metricManager;
    }
}

