/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.chunk;

import java.io.IOException;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.reader.chunk.ChunkReaderByTimestamp;

public class DiskChunkReaderByTimestamp
implements IReaderByTimestamp {
    private ChunkReaderByTimestamp chunkReaderByTimestamp;
    private BatchData data;
    private long currentTime = Long.MIN_VALUE;

    public DiskChunkReaderByTimestamp(ChunkReaderByTimestamp chunkReaderByTimestamp) {
        this.chunkReaderByTimestamp = chunkReaderByTimestamp;
    }

    @Override
    public Object[] getValuesInTimestamps(long[] timestamps, int length) throws IOException {
        Object[] result = new Object[length];
        block0: for (int i = 0; i < length; ++i) {
            if (timestamps[i] < this.currentTime) {
                throw new IOException("time must be increasing when use ReaderByTimestamp");
            }
            this.currentTime = timestamps[i];
            while (this.hasNext()) {
                this.data = this.next();
                if (this.data.getMinTimestamp() > this.currentTime) {
                    result[i] = null;
                    continue block0;
                }
                result[i] = this.data.getValueInTimestamp(this.currentTime);
                if (this.data.hasCurrent() || !this.chunkReaderByTimestamp.hasNextSatisfiedPage()) continue;
                this.data = this.next();
            }
        }
        return result;
    }

    private boolean hasCacheData() {
        return this.data != null && this.data.hasCurrent();
    }

    private boolean hasNext() {
        return this.hasCacheData() || this.chunkReaderByTimestamp.hasNextSatisfiedPage();
    }

    private BatchData next() throws IOException {
        if (this.hasCacheData()) {
            return this.data;
        }
        return this.chunkReaderByTimestamp.nextPageData();
    }
}

